/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.internal;

import java.util.Hashtable;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.gyrex.monitoring.internal.DiagnosticsStatusMetrics;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class StatusTracker
extends ServiceTracker<IStatus, IStatus> {
    private final DiagnosticsStatusMetrics diagnosticsStatusMetrics;
    private ServiceRegistration<MetricSet> metricSetRegistration;
    private final CopyOnWriteArrayList<IStatus> statusList = new CopyOnWriteArrayList();

    static String getFormattedMessage(IStatus[] children, int ident) {
        StrBuilder builder = new StrBuilder();
        IStatus[] iStatusArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            builder.appendSeparator(SystemUtils.LINE_SEPARATOR);
            builder.appendPadding(ident, ' ');
            builder.append(StatusTracker.getSeverityText(child.getSeverity())).append(": ");
            builder.append(child.getMessage());
            if (child.getCode() != 0) {
                builder.append(" (code ").append(child.getCode()).append(")");
            }
            if (child.isMultiStatus()) {
                builder.appendNewLine();
                builder.append(StatusTracker.getFormattedMessage(child.getChildren(), ident + 2));
            }
            ++n2;
        }
        return builder.toString();
    }

    private static String getSeverityText(int severity) {
        switch (severity) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 4: {
                return "ERROR";
            }
            case 8: {
                return "CANCEL";
            }
        }
        return "UNKNOWN";
    }

    public StatusTracker(BundleContext context) {
        super(context, IStatus.class, null);
        this.diagnosticsStatusMetrics = new DiagnosticsStatusMetrics();
    }

    public IStatus addingService(ServiceReference<IStatus> reference) {
        IStatus status = (IStatus)super.addingService(reference);
        if (status != null) {
            this.statusList.add(status);
            this.updateStatus();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        StatusTracker statusTracker = this;
        synchronized (statusTracker) {
            if (this.metricSetRegistration != null) {
                try {
                    this.metricSetRegistration.unregister();
                }
                catch (Exception exception) {}
                this.metricSetRegistration = null;
            }
        }
        super.close();
    }

    public void modifiedService(ServiceReference<IStatus> reference, IStatus service) {
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(boolean trackAllServices) {
        super.open(trackAllServices);
        StatusTracker statusTracker = this;
        synchronized (statusTracker) {
            if (this.metricSetRegistration == null) {
                Hashtable<String, String> properties = new Hashtable<String, String>(3);
                properties.put("service.vendor", "Eclipse Gyrex");
                properties.put("service.description", this.diagnosticsStatusMetrics.getDescription());
                properties.put("service.pid", this.diagnosticsStatusMetrics.getId());
                this.metricSetRegistration = this.context.registerService(MetricSet.class, (Object)this.diagnosticsStatusMetrics, properties);
            }
        }
    }

    public void removedService(ServiceReference<IStatus> reference, IStatus service) {
        this.statusList.remove(service);
        this.updateStatus();
        super.removedService(reference, (Object)service);
    }

    private void updateStatus() {
        MultiStatus systemStatus = new MultiStatus("org.eclipse.gyrex.monitoring", 0, "System Status", null);
        for (IStatus status : this.statusList) {
            systemStatus.add(status);
        }
        this.diagnosticsStatusMetrics.setStatus(StatusTracker.getSeverityText(systemStatus.getSeverity()), StatusTracker.getFormattedMessage(systemStatus.getChildren(), 0));
    }
}

