/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.solr.internal;

import java.net.MalformedURLException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.impl.LBHttpSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.eclipse.gyrex.persistence.solr.SolrServerRepository;
import org.eclipse.gyrex.persistence.solr.config.SolrServerType;
import org.eclipse.gyrex.persistence.solr.internal.SolrActivator;
import org.eclipse.gyrex.persistence.solr.internal.SolrRepository;
import org.eclipse.gyrex.persistence.storage.Repository;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;
import org.osgi.service.prefs.BackingStoreException;

public class SolrRepositoryProvider
extends RepositoryProvider {
    public static final String PREF_KEY_SERVER_TYPE = "serverType";
    public static final String PREF_KEY_SERVER_URL = "serverUrl";
    public static final String PREF_KEY_SERVER_READ_URLS = "serverReadUrls";

    public SolrRepositoryProvider() {
        super("org.eclipse.gyrex.persistence.solr", SolrServerRepository.class);
    }

    private SolrServer createLoadBalancedReadServer(String[] readUrls) throws MalformedURLException {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(200);
        connectionManager.getParams().setMaxTotalConnections(200 * readUrls.length);
        LBHttpSolrServer solrServerForRead = new LBHttpSolrServer(new HttpClient((HttpConnectionManager)connectionManager), readUrls);
        solrServerForRead.setConnectionTimeout(1000);
        solrServerForRead.setConnectionManagerTimeout(1000);
        solrServerForRead.setSoTimeout(5000);
        return solrServerForRead;
    }

    public Repository createRepositoryInstance(String repositoryId, IRepositoryPreferences repositoryPreferences) {
        return new SolrRepository(repositoryId, this, this.createServers(repositoryId, repositoryPreferences));
    }

    private SolrServer[] createServers(String repositoryId, IRepositoryPreferences repositoryPreferences) {
        String typeStr = repositoryPreferences.get(PREF_KEY_SERVER_TYPE, null);
        SolrServerType serverType = typeStr == null ? SolrServerType.EMBEDDED : SolrServerType.valueOf(typeStr);
        switch (serverType) {
            case EMBEDDED: {
                SolrServer embeddedServer = this.getEmbeddedServer(repositoryId);
                return new SolrServer[]{embeddedServer, embeddedServer};
            }
            case REMOTE: {
                String masterUrlString = repositoryPreferences.get(PREF_KEY_SERVER_URL, null);
                try {
                    SolrServer readServer;
                    CommonsHttpSolrServer masterServer = new CommonsHttpSolrServer(masterUrlString);
                    String[] readUrlKeys = repositoryPreferences.getKeys(PREF_KEY_SERVER_READ_URLS);
                    if (readUrlKeys == null || readUrlKeys.length == 0) {
                        readServer = this.createSingleReadServer(masterUrlString);
                    } else if (readUrlKeys.length == 1) {
                        readServer = this.createSingleReadServer(repositoryPreferences.get("serverReadUrls//" + readUrlKeys[0], null));
                    } else {
                        String[] urls = new String[readUrlKeys.length];
                        try {
                            int i = 0;
                            while (i < readUrlKeys.length) {
                                int pos = NumberUtils.toInt((String)readUrlKeys[i], (int)-1);
                                urls[pos] = repositoryPreferences.get("serverReadUrls//" + readUrlKeys[0], null);
                                ++i;
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            throw new IllegalStateException(String.format("Unable to read replica urls for repository %s. %s", repositoryId, e.getMessage()), e);
                        }
                        readServer = this.createLoadBalancedReadServer(urls);
                    }
                    return new SolrServer[]{masterServer, readServer};
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(String.format("Repository %s not configured correctly. Server URL '%s' is invalid.  %s", repositoryId, masterUrlString, e.getMessage()));
                }
                catch (BackingStoreException e) {
                    throw new IllegalStateException(String.format("Unable to read repository settings for repository %s. %s", repositoryId, e.getMessage()), e);
                }
            }
        }
        throw new IllegalStateException(String.format("Repository %s not configured correctly. Unsupported server type %s", repositoryId, typeStr));
    }

    private SolrServer createSingleReadServer(String urlString) throws MalformedURLException {
        CommonsHttpSolrServer solrServerForRead = new CommonsHttpSolrServer(urlString);
        solrServerForRead.setConnectionTimeout(1000);
        solrServerForRead.setConnectionManagerTimeout(1000L);
        solrServerForRead.setSoTimeout(5000);
        return solrServerForRead;
    }

    private SolrServer getEmbeddedServer(String repositoryId) {
        String coreName = SolrActivator.getEmbeddedSolrCoreName(repositoryId);
        CoreContainer coreContainer = SolrActivator.getInstance().getEmbeddedCoreContainer();
        SolrCore core = coreContainer.getCore(coreName);
        if (core == null) {
            throw new IllegalStateException("Solr core '" + coreName + "' not found");
        }
        core.close();
        return new EmbeddedSolrServer(coreContainer, coreName);
    }
}

