/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerDescriptor;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompletionProposalCategory {
    private static final String ICON = "icon";
    private final String fId;
    private final String fName;
    private final IConfigurationElement fElement;
    private final ImageDescriptor fImage;
    private final Expression fEnablementExpression;
    private boolean fIsSeparateCommand = true;
    private boolean fIsEnabled = true;
    private boolean fIsIncluded = true;
    private final CompletionProposalComputerRegistry fRegistry;
    private int fSortOrder = 65534;
    private String fLastError = null;
    private boolean fNeedsSortingAfterFiltering;

    CompletionProposalCategory(IConfigurationElement element, CompletionProposalComputerRegistry registry) throws CoreException {
        Bundle bundle;
        this.fElement = element;
        this.fRegistry = registry;
        IExtension parent = (IExtension)element.getParent();
        this.fId = parent.getUniqueIdentifier();
        this.checkNotNull(this.fId, "id");
        String name = parent.getLabel();
        this.fName = name == null ? this.fId : name;
        IConfigurationElement[] children = this.fElement.getChildren("enablement");
        if (children.length == 1) {
            ExpressionConverter parser = ExpressionConverter.getDefault();
            this.fEnablementExpression = parser.perform(children[0]);
        } else {
            this.fEnablementExpression = null;
        }
        String icon = element.getAttribute(ICON);
        ImageDescriptor img = null;
        if (icon != null && (bundle = this.getBundle()) != null) {
            Path path = new Path(icon);
            URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
            img = ImageDescriptor.createFromURL((URL)url);
        }
        this.fImage = img;
    }

    CompletionProposalCategory(String id, String name, CompletionProposalComputerRegistry registry) {
        this.fRegistry = registry;
        this.fId = id;
        this.fName = name;
        this.fElement = null;
        this.fEnablementExpression = null;
        this.fImage = null;
    }

    private Bundle getBundle() {
        String namespace = this.fElement.getDeclaringExtension().getContributor().getName();
        Bundle bundle = Platform.getBundle((String)namespace);
        return bundle;
    }

    private void checkNotNull(Object value, String attribute) throws CoreException {
        if (value == null) {
            Object[] args = new Object[]{this.getId(), this.fElement.getContributor().getName(), attribute};
            String message = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_illegal_attribute_message, args);
            Status status = new Status(2, JavaPlugin.getPluginId(), 0, message, null);
            throw new CoreException((IStatus)status);
        }
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public String getDisplayName() {
        return LegacyActionTools.removeMnemonics((String)this.fName);
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fImage;
    }

    public void setSeparateCommand(boolean enabled) {
        this.fIsSeparateCommand = enabled;
    }

    public boolean isSeparateCommand() {
        return this.fIsSeparateCommand;
    }

    public void setIncluded(boolean included) {
        this.fIsIncluded = included;
    }

    public boolean isIncluded() {
        return this.fIsIncluded;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.fIsEnabled = isEnabled;
    }

    public boolean hasComputers() {
        List<CompletionProposalComputerDescriptor> descriptors = this.fRegistry.getProposalComputerDescriptors();
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() != this) continue;
            return true;
        }
        return false;
    }

    public boolean hasComputers(String partition) {
        List<CompletionProposalComputerDescriptor> descriptors = this.fRegistry.getProposalComputerDescriptors(partition);
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() != this) continue;
            return true;
        }
        return false;
    }

    public int getSortOrder() {
        return this.fSortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.fSortOrder = sortOrder;
    }

    public boolean matches(IJavaProject javaProject) {
        if (this.fEnablementExpression == null) {
            return true;
        }
        if (javaProject == null) {
            return false;
        }
        try {
            EvaluationContext evalContext = new EvaluationContext(null, (Object)javaProject);
            evalContext.addVariable("project", (Object)javaProject);
            return this.fEnablementExpression.evaluate((IEvaluationContext)evalContext) == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, String partition, SubProgressMonitor monitor) {
        this.fLastError = null;
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        ArrayList<CompletionProposalComputerDescriptor> descriptors = new ArrayList<CompletionProposalComputerDescriptor>(this.fRegistry.getProposalComputerDescriptors(partition));
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() == this) {
                result.addAll(desc.computeCompletionProposals(context, (IProgressMonitor)monitor));
            }
            if (this.fLastError != null || desc.getErrorMessage() == null) continue;
            this.fLastError = desc.getErrorMessage();
        }
        return result;
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, String partition, SubProgressMonitor monitor) {
        this.fLastError = null;
        ArrayList<IContextInformation> result = new ArrayList<IContextInformation>();
        ArrayList<CompletionProposalComputerDescriptor> descriptors = new ArrayList<CompletionProposalComputerDescriptor>(this.fRegistry.getProposalComputerDescriptors(partition));
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() == this && (this.isIncluded() || this.isSeparateCommand())) {
                result.addAll(desc.computeContextInformation(context, (IProgressMonitor)monitor));
            }
            if (this.fLastError != null) continue;
            this.fLastError = desc.getErrorMessage();
        }
        return result;
    }

    public String getErrorMessage() {
        return this.fLastError;
    }

    public void sessionStarted() {
        ArrayList<CompletionProposalComputerDescriptor> descriptors = new ArrayList<CompletionProposalComputerDescriptor>(this.fRegistry.getProposalComputerDescriptors());
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() == this) {
                desc.sessionStarted();
                boolean bl = this.fNeedsSortingAfterFiltering = this.fNeedsSortingAfterFiltering || desc.isSortingAfterFilteringNeeded();
            }
            if (this.fLastError != null) continue;
            this.fLastError = desc.getErrorMessage();
        }
    }

    public void sessionEnded() {
        this.fNeedsSortingAfterFiltering = false;
        ArrayList<CompletionProposalComputerDescriptor> descriptors = new ArrayList<CompletionProposalComputerDescriptor>(this.fRegistry.getProposalComputerDescriptors());
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() == this) {
                desc.sessionEnded();
            }
            if (this.fLastError != null) continue;
            this.fLastError = desc.getErrorMessage();
        }
    }

    public boolean isSortingAfterFilteringNeeded() {
        return this.fNeedsSortingAfterFiltering;
    }
}

