/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.core.resource.ResourceLocator;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJavaResourceLocator
implements ResourceLocator {
    protected static final IPath META_INF_PATH = new Path("META-INF");
    protected static final Transformer<IPackageFragmentRoot, IContainer> ROOT_CONTAINER_TRANSFORMER = new RootContainerTransformer();
    protected static final Filter<IPackageFragmentRoot> SOURCE_ROOT_FILTER = new SourceRootFilter();

    @Override
    public boolean resourceLocationIsValid(IProject project, IContainer container) {
        try {
            return this.resourceLocationIsValid_(project, container);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    protected boolean resourceLocationIsValid_(IProject project, IContainer container) throws JavaModelException {
        IJavaProject javaProject = this.getJavaProject(project);
        if (javaProject.isOnClasspath((IResource)container)) {
            return true;
        }
        IPath outputPath = javaProject.getOutputLocation();
        IPath containerPath = container.getFullPath();
        if (container.equals((Object)project) && outputPath.isPrefixOf(containerPath)) {
            return true;
        }
        if (outputPath.isPrefixOf(containerPath)) {
            return false;
        }
        Object[] objectArray = javaProject.getNonJavaResources();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder;
            Object resource = objectArray[n2];
            if (resource instanceof IFolder && (folder = (IFolder)resource).getFullPath().isPrefixOf(containerPath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IContainer getDefaultResourceLocation(IProject project) {
        try {
            return this.getDefaultResourceLocation_(project);
        }
        catch (Exception ex) {
            JptCommonCorePlugin.log(ex);
            return null;
        }
    }

    protected IContainer getDefaultResourceLocation_(IProject project) throws JavaModelException {
        IFolder defaultLocation = null;
        for (IContainer sourceFolder : this.getSourceFolders(project)) {
            IFolder metaInfFolder = sourceFolder.getFolder(META_INF_PATH);
            if (metaInfFolder.exists()) {
                return metaInfFolder;
            }
            if (defaultLocation != null) continue;
            defaultLocation = metaInfFolder;
        }
        IFolder metaInfFolder = project.getFolder(META_INF_PATH);
        if (metaInfFolder.exists()) {
            return metaInfFolder;
        }
        return defaultLocation;
    }

    @Override
    public IPath getResourcePath(IProject project, IPath runtimePath) {
        try {
            return this.getResourcePath_(project, runtimePath);
        }
        catch (Exception ex) {
            JptCommonCorePlugin.log(ex);
            return null;
        }
    }

    protected IPath getResourcePath_(IProject project, IPath runtimePath) throws JavaModelException {
        IPath defaultResourcePath = null;
        for (IContainer sourceFolder : this.getSourceFolders(project)) {
            IPath resourcePath = sourceFolder.getFullPath().append(runtimePath);
            IFile file = project.getWorkspace().getRoot().getFile(resourcePath);
            if (file.exists()) {
                return file.getFullPath();
            }
            if (defaultResourcePath != null) continue;
            defaultResourcePath = resourcePath;
        }
        return defaultResourcePath;
    }

    @Override
    public IPath getRuntimePath(IProject project, IPath resourcePath) {
        try {
            return this.getRuntimePath_(project, resourcePath);
        }
        catch (Exception ex) {
            JptCommonCorePlugin.log(ex);
            return resourcePath.makeRelativeTo(project.getFullPath());
        }
    }

    protected IPath getRuntimePath_(IProject project, IPath resourcePath) throws JavaModelException {
        IFile file = PlatformTools.getFile(resourcePath);
        for (IContainer sourceFolder : this.getSourceFolders(project)) {
            if (!sourceFolder.contains((ISchedulingRule)file)) continue;
            return resourcePath.makeRelativeTo(sourceFolder.getFullPath());
        }
        return resourcePath.makeRelativeTo(project.getFullPath());
    }

    protected Iterable<IContainer> getSourceFolders(IProject project) throws JavaModelException {
        return new TransformationIterable(this.getSourcePackageFragmentRoots(project), ROOT_CONTAINER_TRANSFORMER);
    }

    protected Iterable<IPackageFragmentRoot> getSourcePackageFragmentRoots(IProject project) throws JavaModelException {
        return new FilteringIterable(this.getPackageFragmentRoots(project), SOURCE_ROOT_FILTER);
    }

    protected Iterable<IPackageFragmentRoot> getPackageFragmentRoots(IProject project) throws JavaModelException {
        return new ArrayIterable((Object[])this.getPackageFragmentRootsArray(project));
    }

    protected IPackageFragmentRoot[] getPackageFragmentRootsArray(IProject project) throws JavaModelException {
        return this.getJavaProject(project).getPackageFragmentRoots();
    }

    protected IJavaProject getJavaProject(IProject project) {
        return JavaCore.create((IProject)project);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RootContainerTransformer
    implements Transformer<IPackageFragmentRoot, IContainer> {
        protected RootContainerTransformer() {
        }

        public IContainer transform(IPackageFragmentRoot pfr) {
            try {
                return this.transform_(pfr);
            }
            catch (JavaModelException ex) {
                throw new RuntimeException(ex);
            }
        }

        protected IContainer transform_(IPackageFragmentRoot pfr) throws JavaModelException {
            return (IContainer)pfr.getUnderlyingResource();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SourceRootFilter
    implements Filter<IPackageFragmentRoot> {
        protected SourceRootFilter() {
        }

        public boolean accept(IPackageFragmentRoot pfr) {
            try {
                return this.accept_(pfr);
            }
            catch (JavaModelException ex) {
                throw new RuntimeException(ex);
            }
        }

        protected boolean accept_(IPackageFragmentRoot pfr) throws JavaModelException {
            IResource resource = pfr.getUnderlyingResource();
            return resource != null && resource.getType() == 2;
        }
    }
}

