/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jpt.common.core.internal.resource.ResourceLocatorManager;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.core.resource.ResourceLocator;
import org.eclipse.jpt.common.utility.internal.StringTools;

public class SimpleProjectResourceLocator
implements ProjectResourceLocator {
    protected final IProject project;

    public SimpleProjectResourceLocator(IProject project) {
        this.project = project;
    }

    public boolean resourceLocationIsValid(IContainer container) {
        ResourceLocator resourceLocator = this.getResourceLocator();
        return resourceLocator != null && resourceLocator.resourceLocationIsValid(this.project, container);
    }

    public IContainer getDefaultResourceLocation() {
        ResourceLocator resourceLocator = this.getResourceLocator();
        return resourceLocator == null ? null : resourceLocator.getDefaultResourceLocation(this.project);
    }

    public IPath getResourcePath(IPath runtimePath) {
        ResourceLocator resourceLocator = this.getResourceLocator();
        return resourceLocator == null ? null : resourceLocator.getResourcePath(this.project, runtimePath);
    }

    public IPath getRuntimePath(IPath resourcePath) {
        ResourceLocator resourceLocator = this.getResourceLocator();
        return resourceLocator == null ? null : resourceLocator.getRuntimePath(this.project, resourcePath);
    }

    public IFile getPlatformFile(IPath runtimePath) {
        IPath sourcePath = this.getResourcePath(runtimePath);
        return sourcePath == null ? null : this.project.getWorkspace().getRoot().getFile(sourcePath);
    }

    protected ResourceLocator getResourceLocator() {
        return ResourceLocatorManager.instance().getResourceLocator(this.project);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.project);
    }
}

