/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BinaryAbstractType
extends BinaryMember
implements JavaResourceAbstractType {
    private String name;
    private String qualifiedName;
    private String packageName;
    private String declaringTypeName;
    private boolean memberType;

    protected BinaryAbstractType(JavaResourceNode parent, IType type) {
        super(parent, new TypeAdapter(type));
        this.name = this.buildName(type);
        this.qualifiedName = this.buildQualifiedName(type);
        this.packageName = this.buildPackageName(type);
        this.declaringTypeName = this.buildDeclaringTypeName(type);
        this.memberType = this.buildMemberType(type);
    }

    @Override
    protected void update(IMember member) {
        super.update(member);
        this.setName(this.buildName((IType)member));
        this.setQualifiedName(this.buildQualifiedName((IType)member));
        this.setPackageName(this.buildPackageName((IType)member));
        this.setDeclaringTypeName(this.buildDeclaringTypeName((IType)member));
        this.setMemberType(this.buildMemberType((IType)member));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    private String buildName(IType type) {
        return type.getElementName();
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    private void setQualifiedName(String qualifiedName) {
        String old = this.qualifiedName;
        this.qualifiedName = qualifiedName;
        this.firePropertyChanged("qualifiedName", old, qualifiedName);
    }

    private String buildQualifiedName(IType type) {
        return type.getFullyQualifiedName('.');
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    private void setPackageName(String packageName) {
        String old = this.packageName;
        this.packageName = packageName;
        this.firePropertyChanged("packageName", old, packageName);
    }

    private String buildPackageName(IType type) {
        return type.getPackageFragment().getElementName();
    }

    @Override
    public boolean isIn(IPackageFragment packageFragment) {
        return StringTools.stringsAreEqual((String)packageFragment.getElementName(), (String)this.packageName);
    }

    @Override
    public boolean isIn(IPackageFragmentRoot sourceFolder) {
        return this.getSourceFolder().equals(sourceFolder);
    }

    private IPackageFragmentRoot getSourceFolder() {
        return (IPackageFragmentRoot)this.getMember().getAncestor(3);
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    private void setDeclaringTypeName(String declaringTypeName) {
        String old = this.declaringTypeName;
        this.declaringTypeName = declaringTypeName;
        this.firePropertyChanged("declaringTypeName", old, declaringTypeName);
    }

    private String buildDeclaringTypeName(IType type) {
        IType declaringType = type.getDeclaringType();
        return declaringType == null ? null : declaringType.getFullyQualifiedName('.');
    }

    @Override
    public boolean isMemberType() {
        return this.memberType;
    }

    private void setMemberType(boolean memberType) {
        boolean old = this.memberType;
        this.memberType = memberType;
        this.firePropertyChanged("memberType", old, memberType);
    }

    private boolean buildMemberType(IType type) {
        try {
            return type.isMember();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    public IType getMember() {
        return (IType)super.getMember();
    }

    @Override
    public Iterable<JavaResourceType> getTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<JavaResourceEnum> getEnums() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<JavaResourceType> getAllTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<JavaResourceEnum> getAllEnums() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypeAdapter
    implements BinaryMember.Adapter {
        private final IType type;

        TypeAdapter(IType type) {
            this.type = type;
        }

        public IType getElement() {
            return this.type;
        }

        @Override
        public Iterable<ITypeParameter> getTypeParameters() {
            try {
                return new ArrayIterable((Object[])this.type.getTypeParameters());
            }
            catch (JavaModelException jme) {
                JptCommonCorePlugin.log(jme);
                return EmptyIterable.instance();
            }
        }

        @Override
        public IAnnotation[] getAnnotations() throws JavaModelException {
            return this.type.getAnnotations();
        }
    }
}

