/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BinaryMember
extends BinaryAnnotatedElement
implements JavaResourceMember {
    private boolean final_;
    private boolean transient_;
    private boolean public_;
    private boolean static_;
    private boolean protected_;

    public BinaryMember(JavaResourceNode parent, Adapter adapter) {
        super(parent, adapter);
        IMember member = adapter.getElement();
        this.final_ = this.buildFinal(member);
        this.transient_ = this.buildTransient(member);
        this.public_ = this.buildPublic(member);
        this.static_ = this.buildStatic(member);
        this.protected_ = this.buildProtected(member);
    }

    @Override
    public void update() {
        super.update();
        this.update(this.getMember());
    }

    protected void update(IMember member) {
        this.setFinal(this.buildFinal(member));
        this.setTransient(this.buildTransient(member));
        this.setPublic(this.buildPublic(member));
        this.setStatic(this.buildStatic(member));
        this.setProtected(this.buildProtected(member));
    }

    @Override
    public boolean isFinal() {
        return this.final_;
    }

    private void setFinal(boolean final_) {
        boolean old = this.final_;
        this.final_ = final_;
        this.firePropertyChanged("final", old, final_);
    }

    private boolean buildFinal(IMember member) {
        try {
            return Flags.isFinal((int)member.getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean isTransient() {
        return this.transient_;
    }

    private void setTransient(boolean transient_) {
        boolean old = this.transient_;
        this.transient_ = transient_;
        this.firePropertyChanged("transient", old, transient_);
    }

    private boolean buildTransient(IMember member) {
        try {
            return Flags.isTransient((int)member.getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean isPublic() {
        return this.public_;
    }

    private void setPublic(boolean public_) {
        boolean old = this.public_;
        this.public_ = public_;
        this.firePropertyChanged("public", old, public_);
    }

    private boolean buildPublic(IMember member) {
        try {
            return Flags.isPublic((int)member.getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean isStatic() {
        return this.static_;
    }

    private void setStatic(boolean static_) {
        boolean old = this.static_;
        this.static_ = static_;
        this.firePropertyChanged("static", old, static_);
    }

    private boolean buildStatic(IMember member) {
        try {
            return Flags.isStatic((int)member.getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean isProtected() {
        return this.protected_;
    }

    private void setProtected(boolean protected_) {
        boolean old = this.protected_;
        this.protected_ = protected_;
        this.firePropertyChanged("protected", old, protected_);
    }

    private boolean buildProtected(IMember member) {
        try {
            return Flags.isProtected((int)member.getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    IMember getMember() {
        return this.getAdapter().getElement();
    }

    private Adapter getAdapter() {
        return (Adapter)this.adapter;
    }

    static String convertTypeSignatureToTypeName(String typeSignature) {
        return BinaryMember.convertTypeSignatureToTypeName(typeSignature, EmptyIterable.instance());
    }

    static String convertTypeSignatureToTypeName(String typeSignature, Iterable<ITypeParameter> typeParameters) {
        return typeSignature == null ? null : BinaryMember.convertTypeSignatureToTypeName_(typeSignature, typeParameters);
    }

    static String convertTypeSignatureToTypeName_(String typeSignature) {
        return BinaryMember.convertTypeSignatureToTypeName(typeSignature, EmptyIterable.instance());
    }

    static String convertTypeSignatureToTypeName_(String typeSignature, Iterable<ITypeParameter> typeParameters) {
        String erasureSignature = Signature.getTypeErasure((String)typeSignature);
        if (Signature.getTypeSignatureKind((String)erasureSignature) == 3) {
            try {
                String typeParameterName = Signature.toString((String)erasureSignature);
                for (ITypeParameter typeParameter : typeParameters) {
                    String[] bounds;
                    if (!typeParameterName.equals(typeParameter.getElementName()) || (bounds = typeParameter.getBoundsSignatures()).length <= 0) continue;
                    return BinaryMember.convertTypeSignatureToTypeName_(bounds[0], typeParameters);
                }
            }
            catch (JavaModelException jme) {
                JptCommonCorePlugin.log(jme);
            }
        } else {
            if (Signature.getTypeSignatureKind((String)erasureSignature) == 4) {
                int dim = Signature.getArrayCount((String)erasureSignature);
                String arrayTypeName = BinaryMember.convertTypeSignatureToTypeName(Signature.getElementType((String)erasureSignature), typeParameters);
                return Signature.toString((String)Signature.createArraySignature((String)Signature.createTypeSignature((String)arrayTypeName, (boolean)true), (int)dim));
            }
            if (Signature.getTypeSignatureKind((String)erasureSignature) == 5) {
                if (String.valueOf('*').equals(erasureSignature) || erasureSignature.startsWith(String.valueOf('-'))) {
                    return Object.class.getName();
                }
                return Signature.toString((String)erasureSignature.substring(1));
            }
        }
        return Signature.toString((String)erasureSignature);
    }

    static boolean convertTypeSignatureToTypeIsArray(String typeSignature) {
        return typeSignature == null ? false : Signature.getTypeSignatureKind((String)typeSignature) == 4;
    }

    static int convertTypeSignatureToTypeArrayDimensionality(String typeSignature) {
        return typeSignature == null ? 0 : Signature.getArrayCount((String)typeSignature);
    }

    static String convertTypeSignatureToTypeArrayComponentTypeName(String typeSignature, Iterable<ITypeParameter> typeParameters) {
        return typeSignature == null ? null : BinaryMember.convertTypeSignatureToTypeName(Signature.getElementType((String)typeSignature), typeParameters);
    }

    static List<String> convertTypeSignatureToTypeTypeArgumentNames(String typeSignature, Iterable<ITypeParameter> typeParameters) {
        if (typeSignature == null) {
            return Collections.emptyList();
        }
        String[] typeArgumentSignatures = Signature.getTypeArguments((String)typeSignature);
        if (typeArgumentSignatures.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(typeArgumentSignatures.length);
        String[] stringArray = typeArgumentSignatures;
        int n = typeArgumentSignatures.length;
        int n2 = 0;
        while (n2 < n) {
            String typeArgumentSignature = stringArray[n2];
            names.add(BinaryMember.convertTypeSignatureToTypeName(typeArgumentSignature, typeParameters));
            ++n2;
        }
        return names;
    }

    @Override
    public boolean isPublicOrProtected() {
        return this.isPublic() || this.isProtected();
    }

    @Override
    public Annotation setPrimaryAnnotation(String primaryAnnotationName, Iterable<String> supportingAnnotationNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFor(String memberName, int occurrence) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Adapter
    extends BinaryAnnotatedElement.Adapter {
        public IMember getElement();

        public Iterable<ITypeParameter> getTypeParameters();
    }
}

