/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryEnum;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryType;
import org.eclipse.jpt.common.core.internal.resource.java.binary.RootBinaryNode;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.resource.java.JavaResourceTypeCache;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BinaryTypeCache
extends RootBinaryNode
implements JavaResourceTypeCache {
    private final Vector<Entry> entries = new Vector();

    public BinaryTypeCache(AnnotationProvider annotationProvider) {
        super(null, annotationProvider);
    }

    @Override
    public Iterable<JavaResourceAbstractType> getTypes() {
        return new TransformationIterable<Entry, JavaResourceAbstractType>(this.getEntries()){

            protected JavaResourceAbstractType transform(Entry entry) {
                return entry.type;
            }
        };
    }

    private Iterable<Entry> getEntries() {
        return new LiveCloneIterable(this.entries);
    }

    @Override
    public int getTypesSize() {
        return this.entries.size();
    }

    @Override
    public JavaResourceAbstractType addType(IType jdtType) {
        Entry entry = this.buildEntry(jdtType);
        this.entries.add(entry);
        this.fireItemAdded("types", entry.type);
        return entry.type;
    }

    private Entry buildEntry(IType jdtType) {
        return new Entry(this.buildType(jdtType), jdtType.getResource());
    }

    private JavaResourceAbstractType buildType(IType jdtType) {
        try {
            if (jdtType.isClass() || jdtType.isInterface()) {
                return new BinaryType((JavaResourceNode)this, jdtType);
            }
            if (jdtType.isEnum()) {
                return new BinaryEnum((JavaResourceNode)this, jdtType);
            }
        }
        catch (JavaModelException e) {
            JptCommonCorePlugin.log(e);
        }
        return null;
    }

    @Override
    public boolean removeTypes(IFile jarFile) {
        boolean modified = false;
        for (Entry entry : this.getEntries()) {
            IResource resource = entry.resource;
            if (resource == null || !resource.equals((Object)jarFile)) continue;
            this.removeEntry(entry);
            modified = true;
        }
        return modified;
    }

    private void removeEntry(Entry entry) {
        this.entries.remove(entry);
        this.fireItemRemoved("types", entry.type);
    }

    @Override
    protected void aspectChanged(String aspectName) {
        if (aspectName != null && !aspectName.equals("types")) {
            super.aspectChanged(aspectName);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.entries);
    }

    static class Entry {
        final JavaResourceAbstractType type;
        final IResource resource;

        Entry(JavaResourceAbstractType type, IResource resource) {
            this.type = type;
            this.resource = resource;
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.type);
        }
    }
}

