/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import java.util.HashMap;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProviderFactory;
import org.eclipse.jpt.common.ui.jface.ItemLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemStructuredContentProvider;
import org.eclipse.jpt.common.ui.jface.StructuredStateProvider;
import org.eclipse.jpt.common.utility.internal.RunnableAdapter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemStructuredStateProviderManager<V extends StructuredViewer, CP extends ItemStructuredContentProvider>
extends BaseLabelProvider
implements StructuredStateProvider,
ItemStructuredContentProvider.Manager,
ItemExtendedLabelProvider.Manager {
    protected final ItemExtendedLabelProviderFactory itemLabelProviderFactory;
    protected final HashMap<Object, CP> itemContentProviders = new HashMap();
    protected final HashMap<Object, ItemExtendedLabelProvider> itemLabelProviders = new HashMap();
    protected volatile V viewer;

    protected AbstractItemStructuredStateProviderManager(ItemExtendedLabelProviderFactory itemLabelProviderFactory) {
        this.itemLabelProviderFactory = itemLabelProviderFactory;
    }

    public synchronized void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (oldInput != newInput) {
            this.disposeProviders();
        }
        this.viewer = (StructuredViewer)v;
    }

    public Object[] getElements(Object inputElement) {
        CP provider = this.getItemContentProvider(inputElement);
        return provider == null ? EMPTY_ARRAY : provider.getElements();
    }

    public Image getImage(Object element) {
        ItemExtendedLabelProvider provider = this.getItemLabelProvider(element);
        return provider == null ? null : provider.getImage();
    }

    public String getText(Object element) {
        ItemExtendedLabelProvider provider = this.getItemLabelProvider(element);
        return provider == null ? null : provider.getText();
    }

    public String getDescription(Object element) {
        ItemExtendedLabelProvider provider = this.getItemLabelProvider(element);
        return provider == null ? null : provider.getDescription();
    }

    protected synchronized CP getItemContentProvider(Object item) {
        ItemStructuredContentProvider provider = (ItemStructuredContentProvider)this.itemContentProviders.get(item);
        if (provider == null && !this.itemContentProviders.containsKey(item)) {
            provider = this.buildItemContentProvider(item);
            this.itemContentProviders.put(item, provider);
        }
        return (CP)provider;
    }

    protected abstract CP buildItemContentProvider(Object var1);

    protected synchronized ItemExtendedLabelProvider getItemLabelProvider(Object item) {
        ItemExtendedLabelProvider provider = this.itemLabelProviders.get(item);
        if (provider == null && !this.itemLabelProviders.containsKey(item)) {
            provider = this.buildItemLabelProvider(item);
            this.itemLabelProviders.put(item, provider);
        }
        return provider;
    }

    protected ItemExtendedLabelProvider buildItemLabelProvider(Object item) {
        this.checkViewer();
        return this.itemLabelProviderFactory == null ? null : this.itemLabelProviderFactory.buildProvider(item, this);
    }

    protected void checkViewer() {
        if (this.viewer == null) {
            throw new IllegalStateException("This provider must be used as a content provider *as well as* a label provider.");
        }
    }

    @Override
    public void updateElements(Object inputElement) {
        this.execute((Runnable)((Object)new UpdateElementsRunnable(inputElement)));
    }

    void updateElements_(Object inputElement) {
        if (this.viewerIsAlive()) {
            this.viewer.refresh(inputElement);
        }
    }

    @Override
    public void updateLabel(Object item) {
        this.execute((Runnable)((Object)new UpdateLabelRunnable(item)));
    }

    void updateLabel_(Object item) {
        if (this.viewerIsAlive()) {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, item));
        }
    }

    @Override
    public void updateDescription(Object item) {
    }

    protected void execute(Runnable runnable) {
        SWTUtil.execute(this.viewer, runnable);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this);
    }

    protected boolean viewerIsAlive() {
        Control control;
        Control control2 = control = this.viewer == null ? null : this.viewer.getControl();
        return control != null && !control.isDisposed();
    }

    public synchronized void dispose() {
        this.disposeProviders();
        super.dispose();
    }

    protected synchronized void disposeProviders() {
        while (!this.itemContentProviders.isEmpty()) {
            this.dispose_(this.itemContentProviders.keySet().iterator().next());
        }
        while (!this.itemLabelProviders.isEmpty()) {
            this.dispose_(this.itemLabelProviders.keySet().iterator().next());
        }
    }

    @Override
    public synchronized void dispose(Object item) {
        this.dispose_(item);
    }

    private void dispose_(Object item) {
        ItemLabelProvider ilp;
        ItemStructuredContentProvider icp = (ItemStructuredContentProvider)this.itemContentProviders.remove(item);
        if (icp != null) {
            icp.dispose();
        }
        if ((ilp = (ItemLabelProvider)this.itemLabelProviders.remove(item)) != null) {
            ilp.dispose();
        }
    }

    class UpdateElementsRunnable
    extends RunnableAdapter {
        private final Object inputElement;

        UpdateElementsRunnable(Object inputElement) {
            this.inputElement = inputElement;
        }

        public void run() {
            AbstractItemStructuredStateProviderManager.this.updateElements_(this.inputElement);
        }
    }

    class UpdateLabelRunnable
    extends RunnableAdapter {
        private final Object item;

        UpdateLabelRunnable(Object item) {
            this.item = item;
        }

        public void run() {
            AbstractItemStructuredStateProviderManager.this.updateLabel_(this.item);
        }
    }
}

