/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.Serializable;
import org.eclipse.jpt.common.utility.internal.StringConverter;
import org.eclipse.jpt.common.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface BidiStringConverter<T>
extends StringConverter<T> {
    public T convertToObject(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BooleanConverter
    implements BidiStringConverter<Boolean>,
    Serializable {
        public static final BidiStringConverter<Boolean> INSTANCE = new BooleanConverter();
        private static final long serialVersionUID = 1L;

        public static BidiStringConverter<Boolean> instance() {
            return INSTANCE;
        }

        private BooleanConverter() {
        }

        @Override
        public String convertToString(Boolean b) {
            return b == null ? null : b.toString();
        }

        @Override
        public Boolean convertToObject(String s) {
            return s == null ? null : Boolean.valueOf(s);
        }

        public String toString() {
            return StringTools.buildSingletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Default<S>
    implements BidiStringConverter<S>,
    Serializable {
        public static final BidiStringConverter INSTANCE = new Default();
        private static final long serialVersionUID = 1L;

        public static <R> BidiStringConverter<R> instance() {
            return INSTANCE;
        }

        private Default() {
        }

        @Override
        public String convertToString(S o) {
            return o == null ? null : o.toString();
        }

        @Override
        public S convertToObject(String s) {
            return (S)s;
        }

        public String toString() {
            return StringTools.buildSingletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Disabled<S>
    implements BidiStringConverter<S>,
    Serializable {
        public static final BidiStringConverter INSTANCE = new Disabled();
        private static final long serialVersionUID = 1L;

        public static <R> BidiStringConverter<R> instance() {
            return INSTANCE;
        }

        private Disabled() {
        }

        @Override
        public String convertToString(S o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public S convertToObject(String s) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return StringTools.buildSingletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IntegerConverter
    implements BidiStringConverter<Integer>,
    Serializable {
        public static final BidiStringConverter<Integer> INSTANCE = new IntegerConverter();
        private static final long serialVersionUID = 1L;

        public static BidiStringConverter<Integer> instance() {
            return INSTANCE;
        }

        private IntegerConverter() {
        }

        @Override
        public String convertToString(Integer integer) {
            return integer == null ? null : integer.toString();
        }

        @Override
        public Integer convertToObject(String s) {
            return s == null ? null : Integer.valueOf(s);
        }

        public String toString() {
            return StringTools.buildSingletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

