/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ChainIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributesContainer;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.JaxbType;
import org.eclipse.jpt.jaxb.core.context.XmlAccessOrder;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.core.context.XmlNamedNodeMapping;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaTypeMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaAttributesContainer;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorOrderAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorTypeAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaClassMapping
extends AbstractJavaTypeMapping
implements JaxbClassMapping {
    protected String specifiedFactoryClass;
    protected String factoryMethod;
    protected final PropOrderContainer propOrderContainer;
    protected JaxbClassMapping superclass;
    protected XmlAccessType defaultAccessType;
    protected XmlAccessType specifiedAccessType;
    protected XmlAccessOrder defaultAccessOrder;
    protected XmlAccessOrder specifiedAccessOrder;
    protected boolean hasRootElementInHierarchy_loaded = false;
    protected boolean hasRootElementInHierarchy = false;
    protected final JaxbAttributesContainer attributesContainer;
    protected final Map<JaxbClassMapping, JaxbAttributesContainer> includedAttributesContainers = new Hashtable<JaxbClassMapping, JaxbAttributesContainer>();

    public GenericJavaClassMapping(JaxbClass parent) {
        super(parent);
        this.propOrderContainer = new PropOrderContainer();
        this.initFactoryClass();
        this.initFactoryMethod();
        this.initPropOrder();
        this.initSpecifiedAccessType();
        this.initDefaultAccessType();
        this.initSpecifiedAccessOrder();
        this.initDefaultAccessOrder();
        this.attributesContainer = new GenericJavaAttributesContainer(this, this.buildAttributesContainerOwner(), this.getJavaResourceType());
        this.initIncludedAttributes();
    }

    public JavaResourceType getJavaResourceType() {
        return (JavaResourceType)super.getJavaResourceType();
    }

    @Override
    public JaxbClass getJaxbType() {
        return (JaxbClass)super.getJaxbType();
    }

    public JaxbPackageInfo getPackageInfo() {
        JaxbPackage jaxbPackage = this.getJaxbPackage();
        return jaxbPackage == null ? null : jaxbPackage.getPackageInfo();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncFactoryClass();
        this.syncFactoryMethod();
        this.syncPropOrder();
        this.syncSpecifiedAccessType();
        this.syncSpecifiedAccessOrder();
        this.attributesContainer.synchronizeWithResourceModel();
        this.syncIncludedAttributes();
    }

    @Override
    public void update() {
        super.update();
        this.updateSuperclass();
        this.updateDefaultAccessType();
        this.updateDefaultAccessOrder();
        this.hasRootElementInHierarchy_loaded = false;
        this.attributesContainer.update();
        this.updateIncludedAttributes();
    }

    @Override
    public String getFactoryClass() {
        return this.specifiedFactoryClass != null ? this.specifiedFactoryClass : "javax.xml.bind.annotation.XmlType.DEFAULT";
    }

    @Override
    public String getSpecifiedFactoryClass() {
        return this.specifiedFactoryClass;
    }

    @Override
    public void setSpecifiedFactoryClass(String factoryClass) {
        this.getXmlTypeAnnotation().setFactoryClass(factoryClass);
        this.setSpecifiedFactoryClass_(factoryClass);
    }

    protected void setSpecifiedFactoryClass_(String factoryClass) {
        String old = this.specifiedFactoryClass;
        this.specifiedFactoryClass = factoryClass;
        this.firePropertyChanged("specifiedFactoryClass", old, factoryClass);
    }

    protected String getResourceFactoryClass() {
        return this.getXmlTypeAnnotation().getFactoryClass();
    }

    protected void initFactoryClass() {
        this.specifiedFactoryClass = this.getResourceFactoryClass();
    }

    protected void syncFactoryClass() {
        this.setSpecifiedFactoryClass_(this.getResourceFactoryClass());
    }

    @Override
    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    @Override
    public void setFactoryMethod(String factoryMethod) {
        this.getXmlTypeAnnotation().setFactoryMethod(factoryMethod);
        this.setFactoryMethod_(factoryMethod);
    }

    protected void setFactoryMethod_(String factoryMethod) {
        String old = this.factoryMethod;
        this.factoryMethod = factoryMethod;
        this.firePropertyChanged("factoryMethod", old, factoryMethod);
    }

    protected String getResourceFactoryMethod() {
        return this.getXmlTypeAnnotation().getFactoryMethod();
    }

    protected void initFactoryMethod() {
        this.factoryMethod = this.getResourceFactoryMethod();
    }

    protected void syncFactoryMethod() {
        this.setFactoryMethod_(this.getResourceFactoryMethod());
    }

    @Override
    public ListIterable<String> getPropOrder() {
        return this.propOrderContainer.getContextElements();
    }

    @Override
    public String getProp(int index) {
        return (String)this.propOrderContainer.getContextElement(index);
    }

    @Override
    public int getPropOrderSize() {
        return this.propOrderContainer.getContextElementsSize();
    }

    @Override
    public void addProp(int index, String prop) {
        this.getXmlTypeAnnotation().addProp(index, prop);
        this.propOrderContainer.addContextElement(index, prop);
    }

    @Override
    public void removeProp(String prop) {
        this.removeProp(this.propOrderContainer.indexOfContextElement(prop));
    }

    @Override
    public void removeProp(int index) {
        this.getXmlTypeAnnotation().removeProp(index);
        this.propOrderContainer.removeContextElement(index);
    }

    @Override
    public void moveProp(int targetIndex, int sourceIndex) {
        this.getXmlTypeAnnotation().moveProp(targetIndex, sourceIndex);
        this.propOrderContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected void initPropOrder() {
        this.propOrderContainer.initialize();
    }

    protected void syncPropOrder() {
        this.propOrderContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<String> getResourcePropOrder() {
        ListIterable<String> result = this.getXmlTypeAnnotation().getPropOrder();
        if (CollectionTools.size(result) == 1 && "".equals(CollectionTools.get(result, (int)0))) {
            return EmptyListIterable.instance();
        }
        return result;
    }

    @Override
    public XmlAccessType getAccessType() {
        return this.specifiedAccessType != null ? this.specifiedAccessType : this.defaultAccessType;
    }

    @Override
    public XmlAccessType getDefaultAccessType() {
        return this.defaultAccessType;
    }

    protected void setDefaultAccessType_(XmlAccessType access) {
        XmlAccessType old = this.defaultAccessType;
        this.defaultAccessType = access;
        this.firePropertyChanged("defaultAccessType", (Object)old, (Object)access);
    }

    @Override
    public XmlAccessType getSpecifiedAccessType() {
        return this.specifiedAccessType;
    }

    @Override
    public void setSpecifiedAccessType(XmlAccessType access) {
        this.getXmlAccessorTypeAnnotation().setValue(XmlAccessType.toJavaResourceModel(access));
        this.setSpecifiedAccessType_(access);
    }

    protected void setSpecifiedAccessType_(XmlAccessType access) {
        XmlAccessType old = this.specifiedAccessType;
        this.specifiedAccessType = access;
        this.firePropertyChanged("specifiedAccessType", (Object)old, (Object)access);
    }

    protected void initDefaultAccessType() {
        this.defaultAccessType = this.buildDefaultAccessType();
    }

    protected void updateDefaultAccessType() {
        this.setDefaultAccessType_(this.buildDefaultAccessType());
    }

    protected XmlAccessType buildDefaultAccessType() {
        XmlAccessType accessType = this.getSuperclassAccessType();
        if (accessType != null) {
            return accessType;
        }
        accessType = this.getPackageAccessType();
        if (accessType != null) {
            return accessType;
        }
        return XmlAccessType.PUBLIC_MEMBER;
    }

    protected XmlAccessType getSuperclassAccessType() {
        return this.superclass == null ? null : this.superclass.getSpecifiedAccessType();
    }

    protected XmlAccessType getPackageAccessType() {
        JaxbPackageInfo packageInfo = this.getPackageInfo();
        return packageInfo == null ? null : packageInfo.getAccessType();
    }

    protected XmlAccessorTypeAnnotation getXmlAccessorTypeAnnotation() {
        return (XmlAccessorTypeAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.xml.bind.annotation.XmlAccessorType");
    }

    protected XmlAccessType getResourceAccessType() {
        return XmlAccessType.fromJavaResourceModel(this.getXmlAccessorTypeAnnotation().getValue());
    }

    protected void initSpecifiedAccessType() {
        this.specifiedAccessType = this.getResourceAccessType();
    }

    protected void syncSpecifiedAccessType() {
        this.setSpecifiedAccessType_(this.getResourceAccessType());
    }

    @Override
    public XmlAccessOrder getAccessOrder() {
        return this.specifiedAccessOrder != null ? this.specifiedAccessOrder : this.defaultAccessOrder;
    }

    @Override
    public XmlAccessOrder getDefaultAccessOrder() {
        return this.defaultAccessOrder;
    }

    protected void setDefaultAccessOrder_(XmlAccessOrder accessOrder) {
        XmlAccessOrder old = this.defaultAccessOrder;
        this.defaultAccessOrder = accessOrder;
        this.firePropertyChanged("defaultAccessOrder", (Object)old, (Object)accessOrder);
    }

    @Override
    public XmlAccessOrder getSpecifiedAccessOrder() {
        return this.specifiedAccessOrder;
    }

    @Override
    public void setSpecifiedAccessOrder(XmlAccessOrder accessOrder) {
        this.getXmlAccessorOrderAnnotation().setValue(XmlAccessOrder.toJavaResourceModel(accessOrder));
        this.setSpecifiedAccessOrder_(accessOrder);
    }

    protected void setSpecifiedAccessOrder_(XmlAccessOrder accessOrder) {
        XmlAccessOrder old = this.specifiedAccessOrder;
        this.specifiedAccessOrder = accessOrder;
        this.firePropertyChanged("specifiedAccessOrder", (Object)old, (Object)accessOrder);
    }

    protected void initDefaultAccessOrder() {
        this.defaultAccessOrder = this.buildDefaultAccessOrder();
    }

    protected void updateDefaultAccessOrder() {
        this.setDefaultAccessOrder_(this.buildDefaultAccessOrder());
    }

    protected XmlAccessOrder buildDefaultAccessOrder() {
        XmlAccessOrder accessOrder = this.getSuperclassAccessOrder();
        if (accessOrder != null) {
            return accessOrder;
        }
        accessOrder = this.getPackageAccessOrder();
        if (accessOrder != null) {
            return accessOrder;
        }
        return XmlAccessOrder.UNDEFINED;
    }

    protected XmlAccessOrder getSuperclassAccessOrder() {
        JaxbClassMapping superclass = this.superclass;
        while (superclass != null) {
            XmlAccessOrder accessOrder = superclass.getSpecifiedAccessOrder();
            if (accessOrder != null) {
                return accessOrder;
            }
            superclass = superclass.getSuperclass();
        }
        return null;
    }

    protected XmlAccessOrder getPackageAccessOrder() {
        JaxbPackageInfo packageInfo = this.getPackageInfo();
        return packageInfo == null ? null : packageInfo.getAccessOrder();
    }

    protected XmlAccessorOrderAnnotation getXmlAccessorOrderAnnotation() {
        return (XmlAccessorOrderAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
    }

    protected XmlAccessOrder getResourceAccessOrder() {
        return XmlAccessOrder.fromJavaResourceModel(this.getXmlAccessorOrderAnnotation().getValue());
    }

    protected void initSpecifiedAccessOrder() {
        this.specifiedAccessOrder = this.getResourceAccessOrder();
    }

    protected void syncSpecifiedAccessOrder() {
        this.setSpecifiedAccessOrder_(this.getResourceAccessOrder());
    }

    @Override
    public JaxbClassMapping getSuperclass() {
        return this.superclass;
    }

    protected void setSuperclass_(JaxbClassMapping superclass) {
        JaxbClassMapping old = this.superclass;
        this.superclass = superclass;
        this.firePropertyChanged("superclass", old, superclass);
    }

    protected void updateSuperclass() {
        this.setSuperclass_(this.findSuperclass());
    }

    protected JaxbClassMapping findSuperclass() {
        JavaResourceType resourceType = this.getSuperclass(this.getJavaResourceType());
        while (resourceType != null && resourceType != this) {
            JaxbType jaxbType = this.getJaxbProject().getContextRoot().getType(resourceType.getQualifiedName());
            if (jaxbType == null || jaxbType.getKind() != JaxbType.Kind.CLASS) {
                return null;
            }
            JaxbClassMapping jaxbClassMapping = ((JaxbClass)jaxbType).getMapping();
            if (jaxbClassMapping != null) {
                return jaxbClassMapping;
            }
            resourceType = this.getSuperclass(resourceType);
        }
        return null;
    }

    protected JavaResourceType getSuperclass(JavaResourceType resourceType) {
        String superclassName = resourceType.getSuperclassQualifiedName();
        if (superclassName == null) {
            return null;
        }
        return (JavaResourceType)this.getJaxbProject().getJavaResourceType(superclassName, JavaResourceAnnotatedElement.Kind.TYPE);
    }

    @Override
    public Iterable<JaxbPersistentAttribute> getAttributes() {
        return this.attributesContainer.getAttributes();
    }

    @Override
    public int getAttributesSize() {
        return this.attributesContainer.getAttributesSize();
    }

    protected GenericJavaAttributesContainer.Owner buildAttributesContainerOwner() {
        return new GenericJavaAttributesContainer.Owner(){

            public XmlAccessType getAccessType() {
                return GenericJavaClassMapping.this.getAccessType();
            }

            public void fireAttributeAdded(JaxbPersistentAttribute attribute) {
                GenericJavaClassMapping.this.fireItemAdded("attributes", attribute);
            }

            public void fireAttributeRemoved(JaxbPersistentAttribute attribute) {
                GenericJavaClassMapping.this.fireItemRemoved("attributes", attribute);
            }
        };
    }

    @Override
    public Iterable<JaxbPersistentAttribute> getIncludedAttributes() {
        return new CompositeIterable(this.getIncludedAttributeSets());
    }

    protected Iterable<Iterable<JaxbPersistentAttribute>> getIncludedAttributeSets() {
        return new TransformationIterable<JaxbAttributesContainer, Iterable<JaxbPersistentAttribute>>(this.getIncludedAttributesContainers()){

            protected Iterable<JaxbPersistentAttribute> transform(JaxbAttributesContainer attributesContainer) {
                return attributesContainer.getAttributes();
            }
        };
    }

    protected Iterable<JaxbAttributesContainer> getIncludedAttributesContainers() {
        return new LiveCloneIterable(this.includedAttributesContainers.values());
    }

    @Override
    public int getIncludedAttributesSize() {
        int size = 0;
        for (JaxbAttributesContainer attributesContainer : this.getIncludedAttributesContainers()) {
            size += attributesContainer.getAttributesSize();
        }
        return size;
    }

    protected void initIncludedAttributes() {
        if (this.isXmlTransient()) {
            return;
        }
        JaxbClassMapping superclass = this.superclass;
        while (superclass != null && superclass.isXmlTransient()) {
            this.includedAttributesContainers.put(superclass, this.buildIncludedAttributesContainer(superclass));
            superclass = superclass.getSuperclass();
        }
    }

    protected void syncIncludedAttributes() {
        for (JaxbAttributesContainer attributesContainer : this.includedAttributesContainers.values()) {
            attributesContainer.synchronizeWithResourceModel();
        }
    }

    protected void updateIncludedAttributes() {
        HashSet oldSuperclasses = CollectionTools.set(this.includedAttributesContainers.keySet());
        HashSet oldAttributes = CollectionTools.set(this.getIncludedAttributes());
        if (!this.isXmlTransient()) {
            JaxbClassMapping superclass = this.superclass;
            while (superclass != null && superclass.isXmlTransient()) {
                if (this.includedAttributesContainers.containsKey(superclass)) {
                    this.includedAttributesContainers.get(superclass).update();
                    oldSuperclasses.remove(superclass);
                } else {
                    this.includedAttributesContainers.put(superclass, this.buildIncludedAttributesContainer(superclass));
                }
                superclass = superclass.getSuperclass();
            }
        }
        for (JaxbClassMapping oldSuperclass : oldSuperclasses) {
            this.includedAttributesContainers.remove(oldSuperclass);
        }
        HashSet newAttributes = CollectionTools.set(this.getIncludedAttributes());
        if (CollectionTools.elementsAreDifferent((Iterable)oldAttributes, (Iterable)newAttributes)) {
            this.fireCollectionChanged("includedAttributes", newAttributes);
        }
    }

    protected JaxbAttributesContainer buildIncludedAttributesContainer(JaxbClassMapping jaxbClassMapping) {
        return new GenericJavaAttributesContainer(this, this.buildIncludedAttributesContainerOwner(), jaxbClassMapping.getJaxbType().getJavaResourceType());
    }

    protected GenericJavaAttributesContainer.Owner buildIncludedAttributesContainerOwner() {
        return new GenericJavaAttributesContainer.Owner(){

            public XmlAccessType getAccessType() {
                return GenericJavaClassMapping.this.getAccessType();
            }

            public void fireAttributeAdded(JaxbPersistentAttribute attribute) {
                GenericJavaClassMapping.this.fireItemAdded("includedAttributes", attribute);
            }

            public void fireAttributeRemoved(JaxbPersistentAttribute attribute) {
                GenericJavaClassMapping.this.fireItemRemoved("includedAttributes", attribute);
            }
        };
    }

    @Override
    public Iterable<JaxbPersistentAttribute> getAllLocallyDefinedAttributes() {
        return new CompositeIterable(new Iterable[]{this.getAttributes(), this.getIncludedAttributes()});
    }

    @Override
    public Iterable<JaxbPersistentAttribute> getInheritedAttributes() {
        return new CompositeIterable(new Iterable[]{this.getIncludedAttributes(), this.getOtherInheritedAttributes()});
    }

    public Iterable<JaxbPersistentAttribute> getAllAttributes() {
        return new CompositeIterable(new Iterable[]{this.getAttributes(), this.getIncludedAttributes(), this.getOtherInheritedAttributes()});
    }

    protected Iterable<JaxbPersistentAttribute> getOtherInheritedAttributes() {
        return new CompositeIterable((Iterable)new TransformationIterable<JaxbClassMapping, Iterable<JaxbPersistentAttribute>>((Iterable)new ChainIterable<JaxbClassMapping>(this.getSuperclass()){

            protected JaxbClassMapping nextLink(JaxbClassMapping currentLink) {
                return currentLink.getSuperclass();
            }
        }){

            protected Iterable<JaxbPersistentAttribute> transform(JaxbClassMapping o) {
                return o.getAttributes();
            }
        });
    }

    @Override
    public boolean hasRootElementInHierarchy() {
        if (!this.hasRootElementInHierarchy_loaded) {
            this.hasRootElementInHierarchy = this.calculateHasRootElementInHierarchy();
            this.hasRootElementInHierarchy_loaded = true;
        }
        return this.hasRootElementInHierarchy;
    }

    protected boolean calculateHasRootElementInHierarchy() {
        if (this.getXmlRootElement() != null) {
            return true;
        }
        for (JaxbType jaxbType : this.getJaxbProject().getContextRoot().getTypes()) {
            if (jaxbType.getMapping() == null || jaxbType.getMapping().isXmlTransient() || jaxbType.getMapping().getXmlRootElement() == null || !JDTTools.typeIsSubType((IJavaProject)this.getJaxbProject().getJavaProject(), (String)jaxbType.getFullyQualifiedName(), (String)this.getJaxbType().getFullyQualifiedName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Iterable<String> getTransientReferencedXmlTypeNames() {
        return new CompositeIterable(new Iterable[]{super.getTransientReferencedXmlTypeNames(), new SingleElementIterable((Object)this.getJavaResourceType().getSuperclassQualifiedName())});
    }

    @Override
    protected Iterable<String> getNonTransientReferencedXmlTypeNames() {
        return new CompositeIterable(new Iterable[]{super.getNonTransientReferencedXmlTypeNames(), new SingleElementIterable((Object)this.getJavaResourceType().getSuperclassQualifiedName()), new CompositeIterable((Iterable)new TransformationIterable<JaxbPersistentAttribute, Iterable<String>>(this.getAttributes()){

            protected Iterable<String> transform(JaxbPersistentAttribute o) {
                return o.getMapping().getReferencedXmlTypeNames();
            }
        })});
    }

    @Override
    public JaxbAttributeMapping getXmlIdMapping() {
        Iterator allXmlIdMappings = new FilteringIterable<XmlNamedNodeMapping>((Iterable)new SubIterableWrapper((Iterable)new FilteringIterable<JaxbAttributeMapping>((Iterable)new TransformationIterable<JaxbPersistentAttribute, JaxbAttributeMapping>(this.getAllAttributes()){

            protected JaxbAttributeMapping transform(JaxbPersistentAttribute o) {
                return o.getMapping();
            }
        }){

            protected boolean accept(JaxbAttributeMapping o) {
                return o.getKey() == "xml-element" || o.getKey() == "xml-attribute";
            }
        })){

            protected boolean accept(XmlNamedNodeMapping o) {
                return o.getXmlID() != null;
            }
        }.iterator();
        return allXmlIdMappings.hasNext() ? (XmlNamedNodeMapping)allXmlIdMappings.next() : null;
    }

    protected Iterable<? extends JaxbAttributeMapping> getAttributeMappings() {
        return new TransformationIterable<JaxbPersistentAttribute, JaxbAttributeMapping>(this.getAttributes()){

            protected JaxbAttributeMapping transform(JaxbPersistentAttribute attribute) {
                return attribute.getMapping();
            }
        };
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        if (this.propTouches(pos, astRoot)) {
            return this.getPropProposals(filter);
        }
        for (JaxbPersistentAttribute attribute : this.getAttributes()) {
            result = attribute.getJavaCompletionProposals(pos, filter, astRoot);
            if (CollectionTools.isEmpty(result)) continue;
            return result;
        }
        return EmptyIterable.instance();
    }

    protected Iterable<String> getPropProposals(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals((Iterable)new FilteringIterable((Iterable)new TransformationIterable<JaxbPersistentAttribute, String>(this.getAllLocallyDefinedAttributes()){

            protected String transform(JaxbPersistentAttribute o) {
                return o.getName();
            }
        }, filter));
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateConstructor(messages, reporter, astRoot);
        this.validatePropOrder(messages, reporter, astRoot);
        this.validateXmlAnyAttributeMapping(messages, astRoot);
        this.validateXmlAnyElementMapping(messages, astRoot);
        this.validateXmlValueMapping(messages, astRoot);
        this.validateXmlIDs(messages, astRoot);
        for (JaxbPersistentAttribute attribute : this.getAttributes()) {
            attribute.validate(messages, reporter, astRoot);
        }
    }

    protected void validateConstructor(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (!"javax.xml.bind.annotation.XmlType.DEFAULT".equals(this.getFactoryClass())) {
            if (StringTools.stringIsEmpty((String)this.getFactoryMethod())) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_TYPE__UNSPECIFIED_FACTORY_METHOD", this, this.getFactoryClassTextRange(astRoot)));
            }
        } else if (this.getFactoryMethod() == null && this.getJaxbType().getXmlJavaTypeAdapter() == null && !this.getJavaResourceType().hasPublicOrProtectedNoArgConstructor()) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_TYPE__NO_PUBLIC_OR_PROTECTED_CONSTRUCTOR", this, this.getValidationTextRange(astRoot)));
        }
    }

    protected void validatePropOrder(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (CollectionTools.isEmpty(this.getPropOrder())) {
            return;
        }
        HashBag props = CollectionTools.bag(this.getPropOrder());
        HashSet<String> allAttributes = new HashSet<String>();
        HashSet<String> requiredAttributes = new HashSet<String>();
        HashSet<String> transientAttributes = new HashSet<String>();
        for (JaxbPersistentAttribute attribute : this.getAllLocallyDefinedAttributes()) {
            allAttributes.add(attribute.getName());
            transientAttributes.add(attribute.getName());
        }
        for (JaxbPersistentAttribute attribute : this.getAllLocallyDefinedAttributes()) {
            if (attribute.getMapping().isParticleMapping()) {
                requiredAttributes.add(attribute.getName());
            }
            if (attribute.getMapping().isTransient()) continue;
            transientAttributes.remove(attribute.getName());
        }
        HashSet<Integer> duplicateProps = new HashSet<Integer>();
        HashSet missingProps = new HashSet(requiredAttributes);
        HashSet<Integer> nonexistentProps = new HashSet<Integer>();
        HashSet<Integer> transientProps = new HashSet<Integer>();
        int i = 0;
        while (i < this.getPropOrderSize()) {
            String prop = this.getProp(i);
            if (props.count((Object)prop) > 1) {
                duplicateProps.add(i);
            }
            if (missingProps.contains(prop)) {
                missingProps.remove(prop);
            }
            if (!allAttributes.contains(prop)) {
                nonexistentProps.add(i);
            }
            if (transientAttributes.contains(prop)) {
                transientProps.add(i);
            }
            ++i;
        }
        Iterator iterator = duplicateProps.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_TYPE__DUPLICATE_PROP", new String[]{this.getProp(i)}, this, this.getPropTextRange(i, astRoot)));
        }
        for (String missingProp : missingProps) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_TYPE__MISSING_PROP", new String[]{missingProp}, this, this.getPropOrderTextRange(astRoot)));
        }
        iterator = nonexistentProps.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_TYPE__NONEXISTENT_PROP", new String[]{this.getProp(i)}, this, this.getPropTextRange(i, astRoot)));
        }
        iterator = transientProps.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_TYPE__TRANSIENT_PROP", new String[]{this.getProp(i)}, this, this.getPropTextRange(i, astRoot)));
        }
    }

    protected void validateXmlAnyAttributeMapping(List<IMessage> messages, CompilationUnit astRoot) {
        HashSet<JaxbPersistentAttribute> localAttributes = new HashSet<JaxbPersistentAttribute>();
        HashSet<JaxbPersistentAttribute> allAttributes = new HashSet<JaxbPersistentAttribute>();
        for (JaxbPersistentAttribute attribute : this.getAttributes()) {
            if (attribute.getMappingKey() != "xml-any-attribute") continue;
            localAttributes.add(attribute);
            allAttributes.add(attribute);
        }
        for (JaxbPersistentAttribute attribute : this.getInheritedAttributes()) {
            if (attribute.getMappingKey() != "xml-any-attribute") continue;
            allAttributes.add(attribute);
        }
        if (allAttributes.size() > 1) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ANY_ATTRIBUTE__MULTIPLE_MAPPINGS_DEFINED", this, this.getValidationTextRange(astRoot)));
            for (JaxbPersistentAttribute anyAttribute : localAttributes) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_ANY_ATTRIBUTE__MULTIPLE_MAPPINGS_DEFINED", anyAttribute.getMapping(), anyAttribute.getMapping().getValidationTextRange(astRoot)));
            }
        }
    }

    protected void validateXmlAnyElementMapping(List<IMessage> messages, CompilationUnit astRoot) {
        HashSet<JaxbPersistentAttribute> localAttributes = new HashSet<JaxbPersistentAttribute>();
        HashSet<JaxbPersistentAttribute> allAttributes = new HashSet<JaxbPersistentAttribute>();
        for (JaxbPersistentAttribute attribute : this.getAttributes()) {
            if (attribute.getMappingKey() != "xml-any-element") continue;
            localAttributes.add(attribute);
            allAttributes.add(attribute);
        }
        for (JaxbPersistentAttribute attribute : this.getInheritedAttributes()) {
            if (attribute.getMappingKey() != "xml-any-element") continue;
            allAttributes.add(attribute);
        }
        if (allAttributes.size() > 1) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ANY_ELEMENT__MULTIPLE_MAPPINGS_DEFINED", this, this.getValidationTextRange(astRoot)));
            for (JaxbPersistentAttribute anyAttribute : localAttributes) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_ANY_ELEMENT__MULTIPLE_MAPPINGS_DEFINED", anyAttribute.getMapping(), anyAttribute.getMapping().getValidationTextRange(astRoot)));
            }
        }
    }

    protected void validateXmlValueMapping(List<IMessage> messages, CompilationUnit astRoot) {
        HashSet<JaxbPersistentAttribute> localAttributes = new HashSet<JaxbPersistentAttribute>();
        HashSet<JaxbPersistentAttribute> allAttributes = new HashSet<JaxbPersistentAttribute>();
        for (JaxbPersistentAttribute attribute : this.getAttributes()) {
            if (attribute.getMappingKey() != "xml-value") continue;
            localAttributes.add(attribute);
            allAttributes.add(attribute);
        }
        for (JaxbPersistentAttribute attribute : this.getInheritedAttributes()) {
            if (attribute.getMappingKey() != "xml-value") continue;
            allAttributes.add(attribute);
        }
        if (allAttributes.size() > 1) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_VALUE__MULTIPLE_MAPPINGS_DEFINED", this, this.getValidationTextRange(astRoot)));
            for (JaxbPersistentAttribute anyAttribute : localAttributes) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_VALUE__MULTIPLE_MAPPINGS_DEFINED", anyAttribute.getMapping(), anyAttribute.getMapping().getValidationTextRange(astRoot)));
            }
        }
    }

    protected void validateXmlIDs(List<IMessage> messages, CompilationUnit astRoot) {
        HashSet<JaxbPersistentAttribute> localAttributes = new HashSet<JaxbPersistentAttribute>();
        HashSet<JaxbPersistentAttribute> allAttributes = new HashSet<JaxbPersistentAttribute>();
        for (JaxbPersistentAttribute attribute : this.getAttributes()) {
            if (attribute.getMappingKey() != "xml-attribute" && attribute.getMappingKey() != "xml-element" || ((XmlNamedNodeMapping)attribute.getMapping()).getXmlID() == null) continue;
            localAttributes.add(attribute);
            allAttributes.add(attribute);
        }
        for (JaxbPersistentAttribute attribute : this.getInheritedAttributes()) {
            if (attribute.getMappingKey() != "xml-attribute" && attribute.getMappingKey() != "xml-element" || ((XmlNamedNodeMapping)attribute.getMapping()).getXmlID() == null) continue;
            allAttributes.add(attribute);
        }
        if (allAttributes.size() > 1) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ID__MULTIPLE_MAPPINGS_DEFINED", this, this.getValidationTextRange(astRoot)));
            for (JaxbPersistentAttribute anyAttribute : localAttributes) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_ID__MULTIPLE_MAPPINGS_DEFINED", anyAttribute.getMapping(), anyAttribute.getMapping().getValidationTextRange(astRoot)));
            }
        }
    }

    protected TextRange getFactoryClassTextRange(CompilationUnit astRoot) {
        TextRange result = this.getXmlTypeAnnotation().getFactoryClassTextRange(astRoot);
        return result != null ? result : this.getValidationTextRange(astRoot);
    }

    protected TextRange getFactoryMethodTextRange(CompilationUnit astRoot) {
        TextRange result = this.getXmlTypeAnnotation().getFactoryMethodTextRange(astRoot);
        return result != null ? result : this.getValidationTextRange(astRoot);
    }

    protected TextRange getPropOrderTextRange(CompilationUnit astRoot) {
        TextRange result = this.getXmlTypeAnnotation().getPropOrderTextRange(astRoot);
        return result != null ? result : this.getValidationTextRange(astRoot);
    }

    protected TextRange getPropTextRange(int index, CompilationUnit astRoot) {
        return this.getXmlTypeAnnotation().getPropTextRange(index, astRoot);
    }

    protected boolean propTouches(int pos, CompilationUnit astRoot) {
        if (this.getXmlTypeAnnotation().propOrderTouches(pos, astRoot)) {
            int i = 0;
            while (i < this.getXmlTypeAnnotation().getPropOrderSize()) {
                if (this.getXmlTypeAnnotation().propTouches(i, pos, astRoot)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PropOrderContainer
    extends AbstractJaxbNode.ListContainer<String, String> {
        protected PropOrderContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "propOrder";
        }

        @Override
        protected String buildContextElement(String resourceElement) {
            return resourceElement;
        }

        @Override
        protected ListIterable<String> getResourceElements() {
            return GenericJavaClassMapping.this.getResourcePropOrder();
        }

        @Override
        protected String getResourceElement(String contextElement) {
            return contextElement;
        }
    }
}

