/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.context.XmlElementWrapper;
import org.eclipse.jpt.jaxb.core.context.XmlNsForm;
import org.eclipse.jpt.jaxb.core.context.java.JavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaQName;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.QNameAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementWrapperAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlElementWrapper
extends AbstractJavaContextNode
implements XmlElementWrapper {
    protected final Context context;
    protected JaxbQName qName;
    protected Boolean specifiedRequired;
    protected Boolean specifiedNillable;

    public GenericJavaXmlElementWrapper(JaxbAttributeMapping parent, Context context) {
        super(parent);
        this.context = context;
        this.qName = this.buildQName();
        this.specifiedRequired = this.buildSpecifiedRequired();
        this.specifiedNillable = this.buildSpecifiedNillable();
    }

    protected JaxbQName buildQName() {
        return new XmlElementQName(this);
    }

    @Override
    public JaxbAttributeMapping getParent() {
        return (JaxbAttributeMapping)super.getParent();
    }

    protected JaxbAttributeMapping getAttributeMapping() {
        return this.getParent();
    }

    protected JaxbPersistentAttribute getPersistentAttribute() {
        return this.getAttributeMapping().getPersistentAttribute();
    }

    protected JaxbClassMapping getJaxbClassMapping() {
        return this.getPersistentAttribute().getClassMapping();
    }

    protected JaxbPackage getJaxbPackage() {
        return this.getJaxbClassMapping().getJaxbType().getJaxbPackage();
    }

    protected XmlElementWrapperAnnotation getAnnotation() {
        return this.context.getAnnotation();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.qName.synchronizeWithResourceModel();
        this.setSpecifiedRequired_(this.buildSpecifiedRequired());
        this.setSpecifiedNillable_(this.buildSpecifiedNillable());
    }

    @Override
    public void update() {
        super.update();
        this.qName.update();
    }

    @Override
    public JaxbQName getQName() {
        return this.qName;
    }

    @Override
    public boolean isRequired() {
        return this.getSpecifiedRequired() == null ? this.isDefaultRequired() : this.getSpecifiedRequired().booleanValue();
    }

    @Override
    public boolean isDefaultRequired() {
        return false;
    }

    @Override
    public Boolean getSpecifiedRequired() {
        return this.specifiedRequired;
    }

    @Override
    public void setSpecifiedRequired(Boolean newSpecifiedRequired) {
        this.getAnnotation().setRequired(newSpecifiedRequired);
        this.setSpecifiedRequired_(newSpecifiedRequired);
    }

    protected void setSpecifiedRequired_(Boolean newSpecifiedRequired) {
        Boolean oldRequired = this.specifiedRequired;
        this.specifiedRequired = newSpecifiedRequired;
        this.firePropertyChanged("specifiedRequired", oldRequired, newSpecifiedRequired);
    }

    protected Boolean buildSpecifiedRequired() {
        return this.getAnnotation().getRequired();
    }

    @Override
    public boolean isNillable() {
        return this.getSpecifiedNillable() == null ? this.isDefaultNillable() : this.getSpecifiedNillable().booleanValue();
    }

    @Override
    public boolean isDefaultNillable() {
        return false;
    }

    @Override
    public Boolean getSpecifiedNillable() {
        return this.specifiedNillable;
    }

    @Override
    public void setSpecifiedNillable(Boolean newSpecifiedNillable) {
        this.getAnnotation().setNillable(newSpecifiedNillable);
        this.setSpecifiedNillable_(newSpecifiedNillable);
    }

    protected void setSpecifiedNillable_(Boolean newSpecifiedNillable) {
        Boolean oldNillable = this.specifiedNillable;
        this.specifiedNillable = newSpecifiedNillable;
        this.firePropertyChanged("specifiedNillable", oldNillable, newSpecifiedNillable);
    }

    protected Boolean buildSpecifiedNillable() {
        return this.getAnnotation().getNillable();
    }

    @Override
    public XsdElementDeclaration getXsdElementDeclaration() {
        XsdTypeDefinition xsdType = this.getPersistentAttribute().getClassMapping().getXsdTypeDefinition();
        return xsdType == null ? null : xsdType.getElement(this.qName.getNamespace(), this.qName.getName());
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        result = this.qName.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (!this.getPersistentAttribute().isJavaResourceAttributeCollectionType()) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ELEMENT_WRAPPER_DEFINED_ON_NON_ARRAY_NON_COLLECTION", this, this.getValidationTextRange(astRoot)));
        }
        this.validateQName(messages, reporter, astRoot);
    }

    protected void validateQName(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.qName.validate(messages, reporter, astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getAnnotation().getTextRange(astRoot);
    }

    public static interface Context {
        public XmlElementWrapperAnnotation getAnnotation();
    }

    protected class QNameAnnotationProxy
    extends AbstractJavaQName.AbstractQNameAnnotationProxy {
        protected QNameAnnotationProxy() {
        }

        protected QNameAnnotation getAnnotation(boolean createIfNull) {
            return GenericJavaXmlElementWrapper.this.getAnnotation();
        }
    }

    public static class SimpleContext
    implements Context {
        protected XmlElementWrapperAnnotation annotation;

        public SimpleContext(XmlElementWrapperAnnotation annotation) {
            this.annotation = annotation;
        }

        public XmlElementWrapperAnnotation getAnnotation() {
            return this.annotation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlElementQName
    extends AbstractJavaQName {
        protected XmlElementQName(JavaContextNode parent) {
            super(parent, new QNameAnnotationProxy());
        }

        @Override
        protected JaxbPackage getJaxbPackage() {
            return GenericJavaXmlElementWrapper.this.getJaxbPackage();
        }

        @Override
        public String getDefaultName() {
            return "";
        }

        @Override
        public String getDefaultNamespace() {
            JaxbPackage jaxbPackage = this.getJaxbPackage();
            return jaxbPackage != null && jaxbPackage.getElementFormDefault() == XmlNsForm.QUALIFIED ? GenericJavaXmlElementWrapper.this.getJaxbClassMapping().getQName().getNamespace() : "";
        }

        @Override
        public Iterable<String> getNameProposals(Filter<String> filter) {
            XsdTypeDefinition xsdType = GenericJavaXmlElementWrapper.this.getJaxbClassMapping().getXsdTypeDefinition();
            return xsdType == null ? EmptyIterable.instance() : xsdType.getElementNameProposals(this.getNamespace(), filter);
        }

        @Override
        public Iterable<String> getNamespaceProposals(Filter<String> filter) {
            XsdSchema schema = this.getXsdSchema();
            return schema == null ? EmptyIterable.instance() : schema.getNamespaceProposals(filter);
        }

        @Override
        public String getReferencedComponentTypeDescription() {
            return JptJaxbCoreMessages.XML_ELEMENT_DESC;
        }

        @Override
        protected void validateReference(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
            XsdTypeDefinition type = GenericJavaXmlElementWrapper.this.getJaxbClassMapping().getXsdTypeDefinition();
            if (type == null) {
                return;
            }
            if (type.getElement(this.getNamespace(), this.getName()) == null) {
                messages.add(this.getUnresolveSchemaComponentMessage(astRoot));
            }
        }
    }
}

