/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.XmlNs;
import org.eclipse.jpt.jaxb.core.context.XmlSchema;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.resource.java.XmlNsAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlNs
extends AbstractJavaContextNode
implements XmlNs {
    protected final XmlNsAnnotation resourceXmlNs;
    protected String namespaceURI;
    protected String prefix;

    public GenericJavaXmlNs(XmlSchema parent, XmlNsAnnotation xmlNsAnnotation) {
        super(parent);
        this.resourceXmlNs = xmlNsAnnotation;
        this.namespaceURI = this.getResourceNamespaceURI();
        this.prefix = this.getResourcePrefix();
    }

    @Override
    public XmlNsAnnotation getResourceXmlNs() {
        return this.resourceXmlNs;
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setNamespaceURI_(this.getResourceNamespaceURI());
        this.setPrefix_(this.getResourcePrefix());
    }

    protected JaxbPackageInfo getJaxbPackageInfo() {
        return this.getXmlSchema().getJaxbPackageInfo();
    }

    protected XmlSchema getXmlSchema() {
        return (XmlSchema)this.getParent();
    }

    protected JavaResourcePackage getResourcePackage() {
        return this.getJaxbPackageInfo().getResourcePackage();
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public void setNamespaceURI(String namespace) {
        this.resourceXmlNs.setNamespaceURI(namespace);
        this.setNamespaceURI_(namespace);
    }

    protected void setNamespaceURI_(String namespaceURI) {
        String old = this.namespaceURI;
        this.namespaceURI = namespaceURI;
        this.firePropertyChanged("namespaceURI", old, namespaceURI);
    }

    protected String getResourceNamespaceURI() {
        return this.resourceXmlNs.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.resourceXmlNs.setPrefix(prefix);
        this.setPrefix_(prefix);
    }

    protected void setPrefix_(String prefix) {
        String old = this.prefix;
        this.prefix = prefix;
        this.firePropertyChanged("prefix", old, prefix);
    }

    protected String getResourcePrefix() {
        return this.resourceXmlNs.getPrefix();
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        if (this.getResourceXmlNs().namespaceURITouches(pos, astRoot)) {
            return this.getNamespaceURICompletionProposals(pos, filter, astRoot);
        }
        return EmptyIterable.instance();
    }

    protected Iterable<String> getNamespaceURICompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        String packageNamespace = this.getJaxbPackageInfo().getJaxbPackage().getNamespace();
        Iterable result = StringTools.stringIsEmpty((String)packageNamespace) ? EmptyIterable.instance() : new SingleElementIterable((Object)StringTools.convertToJavaStringLiteral((String)packageNamespace));
        XsdSchema schema = this.getJaxbPackageInfo().getJaxbPackage().getXsdSchema();
        if (schema != null) {
            result = new CompositeIterable(new Iterable[]{result, schema.getNamespaceProposals(filter)});
        }
        return CollectionTools.set((Iterable)result);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getResourceXmlNs().getTextRange(astRoot);
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.namespaceURI);
    }
}

