/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.prefs;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jpt.jaxb.core.GenericJaxbPlatform;
import org.eclipse.jpt.jaxb.core.JaxbFacet;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.internal.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbPreferencesManager {
    private final IProject project;
    private static volatile boolean flushPreferences = true;
    protected static final String PLATFORM_PREF_NODE = "platform";
    protected static final String PLATFORM_ID_PREF_KEY = "platform-id";
    public static final String DEFAULT_JAXB_PLATFORM_2_1_PREF_KEY = "defaultJaxbPlatform_" + JaxbFacet.VERSION_2_1.getVersionString();
    public static final String DEFAULT_JAXB_PLATFORM_2_2_PREF_KEY = "defaultJaxbPlatform_" + JaxbFacet.VERSION_2_2.getVersionString();
    public static final String SCHEMAS_PREF_NODE = "schemas";
    public static final String SCHEMA_PREF_NODE_PREFIX = "schema-";
    public static final String SCHEMA_LOCATION_PREF_KEY = "location";

    private static IEclipsePreferences getPreferences(IScopeContext context) {
        return context.getNode("org.eclipse.jpt.jaxb.core");
    }

    public static IEclipsePreferences getWorkspacePreferences() {
        return JaxbPreferencesManager.getPreferences(InstanceScope.INSTANCE);
    }

    public static IEclipsePreferences getDefaultPreferences() {
        return JaxbPreferencesManager.getPreferences(DefaultScope.INSTANCE);
    }

    public static void setWorkspacePreference(String key, String value) {
        IEclipsePreferences wkspPrefs = JaxbPreferencesManager.getWorkspacePreferences();
        if (value == null) {
            wkspPrefs.remove(key);
        } else {
            wkspPrefs.put(key, value);
        }
        JaxbPreferencesManager.flush(wkspPrefs);
    }

    private static void doNotFlushPreferences() {
        flushPreferences = false;
    }

    private static void flush(IEclipsePreferences prefs) {
        if (flushPreferences) {
            new PreferencesFlushJob(prefs).schedule();
        }
    }

    public JaxbPreferencesManager(IProject project) {
        if (project == null) {
            throw new RuntimeException("Project is null");
        }
        this.project = project;
    }

    protected Preferences getProjectPreferences() {
        try {
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)this.project);
            return fproj.getPreferences(JaxbFacet.FACET);
        }
        catch (BackingStoreException bse) {
            JptJaxbCorePlugin.log(bse);
        }
        catch (CoreException ce) {
            JptJaxbCorePlugin.log(ce);
        }
        return null;
    }

    public String getJaxbPlatformId() {
        Preferences prefs = this.getProjectPreferences();
        Preferences platformPrefs = prefs.node(PLATFORM_PREF_NODE);
        return platformPrefs.get(PLATFORM_ID_PREF_KEY, GenericJaxbPlatform.VERSION_2_1.getId());
    }

    public void setJaxbPlatform(JaxbPlatformDescription platform) {
        Preferences prefs = this.getProjectPreferences();
        Preferences platformPrefs = prefs.node(PLATFORM_PREF_NODE);
        platformPrefs.put(PLATFORM_ID_PREF_KEY, platform.getId());
        try {
            platformPrefs.flush();
        }
        catch (BackingStoreException bse) {
            JptJaxbCorePlugin.log(bse);
        }
    }

    public List<String> getSchemaLocations() {
        Vector<String> schemaLocations = new Vector<String>();
        Preferences prefs = this.getProjectPreferences();
        Preferences schemasPrefs = prefs.node(SCHEMAS_PREF_NODE);
        try {
            boolean checkAnotherNode = true;
            int i = 1;
            while (checkAnotherNode) {
                String nodeName = SCHEMA_PREF_NODE_PREFIX + String.valueOf(i);
                if (schemasPrefs.nodeExists(nodeName)) {
                    Preferences schemaPrefs = schemasPrefs.node(nodeName);
                    String location = schemaPrefs.get(SCHEMA_LOCATION_PREF_KEY, null);
                    if (location != null) {
                        schemaLocations.add(location);
                    }
                } else {
                    checkAnotherNode = false;
                }
                ++i;
            }
        }
        catch (BackingStoreException bse) {
            JptJaxbCorePlugin.log(bse);
        }
        return schemaLocations;
    }

    public void setSchemaLocations(List<String> schemaLocations) {
        Preferences prefs = this.getProjectPreferences();
        Preferences schemasPrefs = prefs.node(SCHEMAS_PREF_NODE);
        try {
            int i = 1;
            for (String location : schemaLocations) {
                String nodeName = SCHEMA_PREF_NODE_PREFIX + String.valueOf(i);
                Preferences schemaPref = schemasPrefs.node(nodeName);
                schemaPref.put(SCHEMA_LOCATION_PREF_KEY, location);
                ++i;
            }
            boolean checkAnotherNode = true;
            while (checkAnotherNode) {
                String nodeName = SCHEMA_PREF_NODE_PREFIX + String.valueOf(i);
                if (schemasPrefs.nodeExists(nodeName)) {
                    schemasPrefs.node(nodeName).removeNode();
                } else {
                    checkAnotherNode = false;
                }
                ++i;
            }
            schemasPrefs.flush();
        }
        catch (BackingStoreException bse) {
            JptJaxbCorePlugin.log(bse);
        }
    }

    private static class PreferencesFlushJob
    extends Job {
        private final IEclipsePreferences prefs;

        PreferencesFlushJob(IEclipsePreferences prefs) {
            super(NLS.bind((String)JptJaxbCoreMessages.PREFERENCES_FLUSH_JOB_NAME, (Object)prefs.absolutePath()));
            this.prefs = prefs;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.prefs.flush();
            }
            catch (BackingStoreException ex) {
                JptJaxbCorePlugin.log(ex);
            }
            return Status.OK_STATUS;
        }
    }
}

