/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.jaxbindex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.iterables.SnapshotCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.internal.resource.AbstractJaxbFileResourceModel;
import org.eclipse.jpt.jaxb.core.resource.jaxbindex.JaxbIndexResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbIndexResourceImpl
extends AbstractJaxbFileResourceModel<Vector<String>>
implements JaxbIndexResource {
    public JaxbIndexResourceImpl(IFile file) {
        super(file);
    }

    @Override
    protected Vector<String> buildState() {
        return new Vector<String>();
    }

    @Override
    protected void reload() {
        ((Vector)this.state).clear();
        super.reload();
    }

    @Override
    protected void load(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = reader.readLine();
        while (line != null) {
            ((Vector)this.state).add(line.trim());
            line = reader.readLine();
        }
    }

    @Override
    public Iterable<String> getFullyQualifiedClassNames() {
        return this.packageName == null ? this.getSimpleClassNames() : this.getPrefixedClassNames();
    }

    protected Iterable<String> getSimpleClassNames() {
        return new SnapshotCloneIterable((Collection)this.state);
    }

    protected Iterable<String> getPrefixedClassNames() {
        return new TransformationIterable(this.getSimpleClassNames(), (Transformer)new PrefixTransformer(String.valueOf(this.packageName) + '.'));
    }

    public JptResourceType getResourceType() {
        return JptJaxbCorePlugin.JAXB_INDEX_RESOURCE_TYPE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PrefixTransformer
    implements Transformer<String, String> {
        protected final String prefix;

        protected PrefixTransformer(String prefix) {
            this.prefix = prefix;
        }

        public String transform(String string) {
            return String.valueOf(this.prefix) + string;
        }
    }
}

