/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.validation;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IProjectValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbValidator
extends AbstractValidator
implements IValidator {
    public void validate(IValidationContext context, IReporter reporter) {
        this.validate(reporter, ((IProjectValidationContext)context).getProject());
    }

    public void cleanup(IReporter reporter) {
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IReporter reporter = result.getReporter(monitor);
        IProject project = resource.getProject();
        this.clearMarkers(project);
        result.setSuspendValidation(project);
        this.validate(reporter, project);
        return result;
    }

    private void clearMarkers(IProject project) {
        try {
            this.clearMarkers_(project);
        }
        catch (CoreException ex) {
            JptJaxbCorePlugin.log(ex);
        }
    }

    private void clearMarkers_(IProject project) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = project.findMarkers("org.eclipse.jpt.jaxb.core.jaxbProblemMarker", true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.delete();
            ++n2;
        }
    }

    private void validate(IReporter reporter, IProject project) {
        for (IMessage message : this.buildValidationMessages(reporter, project)) {
            reporter.addMessage((IValidator)this, message);
        }
    }

    private Iterable<IMessage> buildValidationMessages(IReporter reporter, IProject project) {
        JaxbProject jaxbProject = JptJaxbCorePlugin.getJaxbProject(project);
        if (jaxbProject != null) {
            return jaxbProject.getValidationMessages(reporter);
        }
        return new SingleElementIterable((Object)DefaultValidationMessages.buildMessage(1, "NO_JAXB_PROJECT", (IResource)project));
    }
}

