/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.AspectChangeSupport;
import org.eclipse.jpt.common.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.jpa.core.JpaDataSource;
import org.eclipse.jpt.jpa.core.JpaFactory;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPlatformVariation;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.jpa2.JpaFactory2_0;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaNode
extends AbstractModel
implements JpaNode {
    protected final JpaNode parent;
    private static final HashMap<Class<? extends AbstractJpaNode>, HashSet<String>> NON_UPDATE_ASPECT_NAME_SETS = new HashMap();
    protected static final String[] EMPTY_STRING_ARRAY = StringTools.EMPTY_STRING_ARRAY;

    protected AbstractJpaNode(JpaNode parent) {
        this.checkParent(parent);
        this.parent = parent;
    }

    protected void checkParent(JpaNode p) {
        if (p == null) {
            if (this.requiresParent()) {
                throw new IllegalArgumentException("'parent' cannot be null");
            }
        } else if (this.forbidsParent()) {
            throw new IllegalArgumentException("'parent' must be null");
        }
    }

    protected boolean requiresParent() {
        return true;
    }

    protected final boolean forbidsParent() {
        return !this.requiresParent();
    }

    protected ChangeSupport buildChangeSupport() {
        return new AspectChangeSupport((Model)this, this.buildChangeSupportListener());
    }

    protected AspectChangeSupport.Listener buildChangeSupportListener() {
        return new AspectChangeSupport.Listener(){

            public void aspectChanged(String aspectName) {
                AbstractJpaNode.this.aspectChanged(aspectName);
            }
        };
    }

    public Object getAdapter(Class adapter) {
        return PlatformTools.getAdapter((Object)this, (Class)adapter);
    }

    @Override
    public JpaNode getParent() {
        return this.parent;
    }

    @Override
    public IResource getResource() {
        return this.parent.getResource();
    }

    @Override
    public JpaProject getJpaProject() {
        return this.parent.getJpaProject();
    }

    @Override
    public JpaProject.Manager getJpaProjectManager() {
        return this.getJpaProject().getManager();
    }

    protected IJavaProject getJavaProject() {
        return this.getJpaProject().getJavaProject();
    }

    public JpaPlatform getJpaPlatform() {
        return this.getJpaProject().getJpaPlatform();
    }

    protected JpaPlatform.Version getJpaPlatformVersion() {
        return this.getJpaPlatform().getJpaVersion();
    }

    protected boolean isJpa2_0Compatible() {
        return JptJpaCorePlugin.nodeIsJpa2_0Compatible(this);
    }

    protected JpaFactory2_0 getJpaFactory2_0() {
        return (JpaFactory2_0)this.getJpaFactory();
    }

    protected JpaFactory getJpaFactory() {
        return this.getJpaPlatform().getJpaFactory();
    }

    protected JpaPlatformVariation getJpaPlatformVariation() {
        return this.getJpaPlatform().getJpaVariation();
    }

    protected JpaFile getJpaFile(IFile file) {
        return this.getJpaProject().getJpaFile(file);
    }

    protected JpaDataSource getDataSource() {
        return this.getJpaProject().getDataSource();
    }

    protected Database getDatabase() {
        return this.getDataSource().getDatabase();
    }

    protected boolean connectionProfileIsActive() {
        return this.getDataSource().connectionProfileIsActive();
    }

    protected Catalog resolveDbCatalog(String catalog) {
        Database database = this.getDatabase();
        return database == null ? null : database.getCatalogForIdentifier(catalog);
    }

    protected void log(String msg) {
        this.getJpaProjectManager().log(msg);
    }

    protected void log(Throwable throwable) {
        this.getJpaProjectManager().log(throwable);
    }

    protected void log(String msg, Throwable throwable) {
        this.getJpaProjectManager().log(msg, throwable);
    }

    protected void aspectChanged(String aspectName) {
        if (this.aspectTriggersUpdate(aspectName)) {
            this.stateChanged();
        }
    }

    protected boolean aspectTriggersUpdate(String aspectName) {
        return !this.aspectDoesNotTriggerUpdate(aspectName);
    }

    protected boolean aspectDoesNotTriggerUpdate(String aspectName) {
        return aspectName == null || this.nonUpdateAspectNames().contains(aspectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<String> nonUpdateAspectNames() {
        HashMap<Class<? extends AbstractJpaNode>, HashSet<String>> hashMap = NON_UPDATE_ASPECT_NAME_SETS;
        synchronized (hashMap) {
            HashSet<String> nonUpdateAspectNames = NON_UPDATE_ASPECT_NAME_SETS.get(this.getClass());
            if (nonUpdateAspectNames == null) {
                nonUpdateAspectNames = new HashSet();
                this.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
                NON_UPDATE_ASPECT_NAME_SETS.put(this.getClass(), nonUpdateAspectNames);
            }
            return nonUpdateAspectNames;
        }
    }

    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
    }

    @Override
    public void stateChanged() {
        this.fireStateChanged();
        if (this.parent != null) {
            this.parent.stateChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractContextCollectionContainer<C extends JpaContextNode, R>
    extends CollectionContainer<C, R> {
        protected AbstractContextCollectionContainer() {
        }

        public void synchronizeWithResourceModel() {
            this.sync(true);
        }

        public void update() {
            this.sync(false);
        }

        protected void sync(boolean sync) {
            HashSet contextElements = CollectionTools.set(this.getContextElements());
            ArrayList<JpaContextNode> contextElementsToSync = new ArrayList<JpaContextNode>(contextElements.size());
            int resourceIndex = 0;
            for (Object resourceElement : this.getResourceElements()) {
                boolean match = false;
                Iterator stream = contextElements.iterator();
                while (stream.hasNext()) {
                    JpaContextNode contextElement = (JpaContextNode)stream.next();
                    if (!Tools.valuesAreEqual(this.getResourceElement(contextElement), resourceElement)) continue;
                    this.moveContextElement(resourceIndex, contextElement);
                    stream.remove();
                    contextElementsToSync.add(contextElement);
                    match = true;
                    break;
                }
                if (!match) {
                    this.addContextElement(resourceIndex, resourceElement);
                }
                ++resourceIndex;
            }
            for (JpaContextNode contextElement : contextElements) {
                this.removeContextElement(contextElement);
            }
            for (JpaContextNode contextElement : contextElementsToSync) {
                if (sync) {
                    contextElement.synchronizeWithResourceModel();
                    continue;
                }
                contextElement.update();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class CollectionContainer<C, R>
    implements Iterable<C> {
        protected final Vector<C> contextElements = new Vector();

        protected CollectionContainer() {
        }

        protected abstract Iterable<R> getResourceElements();

        protected abstract R getResourceElement(C var1);

        protected abstract C buildContextElement(R var1);

        protected abstract String getContextElementsPropertyName();

        public void initialize() {
            for (R resourceElement : this.getResourceElements()) {
                this.contextElements.add(this.buildContextElement(resourceElement));
            }
        }

        public Iterable<C> getContextElements() {
            return new LiveCloneIterable(this.contextElements);
        }

        public C get(int index) {
            return this.contextElements.get(index);
        }

        @Override
        public Iterator<C> iterator() {
            return new CloneIterator(this.contextElements);
        }

        public int getContextElementsSize() {
            return this.contextElements.size();
        }

        public C addContextElement(int index, R resourceElement) {
            return this.addContextElement_(index, this.buildContextElement(resourceElement));
        }

        protected abstract C addContextElement_(int var1, C var2);

        public Iterable<C> addContextElements(int index, Iterable<R> resourceElements) {
            ArrayList<C> newContextElements = new ArrayList<C>();
            for (R resourceElement : resourceElements) {
                newContextElements.add(this.buildContextElement(resourceElement));
            }
            return this.addAll(index, newContextElements);
        }

        protected abstract Iterable<C> addAll(int var1, Iterable<C> var2);

        public abstract void removeContextElement(C var1);

        public abstract void removeAll(Iterable<C> var1);

        protected abstract void moveContextElement(int var1, C var2);

        protected void disposeElement(C element) {
        }

        public String toString() {
            return this.contextElements.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ContextCollectionContainer<C extends JpaContextNode, R>
    extends AbstractContextCollectionContainer<C, R> {
        protected ContextCollectionContainer() {
        }

        @Override
        protected C addContextElement_(int index, C element) {
            AbstractJpaNode.this.addItemToCollection(element, this.contextElements, this.getContextElementsPropertyName());
            return element;
        }

        @Override
        protected Iterable<C> addAll(int index, Iterable<C> elements) {
            AbstractJpaNode.this.addItemsToCollection(elements, this.contextElements, this.getContextElementsPropertyName());
            return elements;
        }

        @Override
        public void removeContextElement(C contextElement) {
            AbstractJpaNode.this.removeItemFromCollection(contextElement, this.contextElements, this.getContextElementsPropertyName());
            this.disposeElement(contextElement);
        }

        @Override
        public void removeAll(Iterable<C> elements) {
            AbstractJpaNode.this.removeItemsFromCollection(elements, this.contextElements, this.getContextElementsPropertyName());
            for (JpaContextNode element : elements) {
                this.disposeElement(element);
            }
        }

        @Override
        protected void moveContextElement(int index, C element) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ContextListContainer<C extends JpaContextNode, R>
    extends AbstractContextCollectionContainer<C, R> {
        protected ContextListContainer() {
        }

        @Override
        public ListIterable<C> getContextElements() {
            return new LiveCloneListIterable((List)this.contextElements);
        }

        @Override
        protected abstract ListIterable<R> getResourceElements();

        public int indexOfContextElement(C element) {
            return this.contextElements.indexOf(element);
        }

        public C getContextElement(int index) {
            return (C)((JpaContextNode)this.contextElements.elementAt(index));
        }

        @Override
        protected C addContextElement_(int index, C element) {
            AbstractJpaNode.this.addItemToList(index, element, this.contextElements, this.getContextElementsPropertyName());
            return element;
        }

        @Override
        public Iterable<C> addAll(int index, Iterable<C> elements) {
            AbstractJpaNode.this.addItemsToList(index, elements, this.contextElements, this.getContextElementsPropertyName());
            return elements;
        }

        @Override
        public void moveContextElement(int targetIndex, int sourceIndex) {
            AbstractJpaNode.this.moveItemInList(targetIndex, sourceIndex, this.contextElements, this.getContextElementsPropertyName());
        }

        @Override
        public void moveContextElement(int index, C element) {
            AbstractJpaNode.this.moveItemInList(index, element, this.contextElements, this.getContextElementsPropertyName());
        }

        public void clearContextList() {
            for (JpaContextNode element : this.contextElements) {
                this.disposeElement(element);
            }
            AbstractJpaNode.this.clearList(this.contextElements, this.getContextElementsPropertyName());
        }

        public C removeContextElement(int index) {
            JpaContextNode element = (JpaContextNode)AbstractJpaNode.this.removeItemFromList(index, this.contextElements, this.getContextElementsPropertyName());
            this.disposeElement(element);
            return (C)element;
        }

        @Override
        public void removeContextElement(C element) {
            AbstractJpaNode.this.removeItemFromList(element, this.contextElements, this.getContextElementsPropertyName());
            this.disposeElement(element);
        }

        @Override
        public void removeAll(Iterable<C> elements) {
            AbstractJpaNode.this.removeItemsFromList(elements, this.contextElements, this.getContextElementsPropertyName());
            for (JpaContextNode element : elements) {
                this.disposeElement(element);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ListContainer<C, R>
    extends CollectionContainer<C, R> {
        protected ListContainer() {
        }

        @Override
        public ListIterable<C> getContextElements() {
            return new LiveCloneListIterable((List)this.contextElements);
        }

        @Override
        protected abstract ListIterable<R> getResourceElements();

        public int indexOfContextElement(C element) {
            return this.contextElements.indexOf(element);
        }

        public C getContextElement(int index) {
            return (C)this.contextElements.get(index);
        }

        @Override
        protected C addContextElement_(int index, C element) {
            AbstractJpaNode.this.addItemToList(index, element, this.contextElements, this.getContextElementsPropertyName());
            return element;
        }

        @Override
        protected Iterable<C> addAll(int index, Iterable<C> newContextElements) {
            AbstractJpaNode.this.addItemsToList(index, newContextElements, this.contextElements, this.getContextElementsPropertyName());
            return newContextElements;
        }

        @Override
        public void moveContextElement(int targetIndex, int sourceIndex) {
            AbstractJpaNode.this.moveItemInList(targetIndex, sourceIndex, this.contextElements, this.getContextElementsPropertyName());
        }

        @Override
        public void moveContextElement(int index, C element) {
            AbstractJpaNode.this.moveItemInList(index, element, this.contextElements, this.getContextElementsPropertyName());
        }

        @Override
        public void removeContextElement(C element) {
            AbstractJpaNode.this.removeItemFromList(element, this.contextElements, this.getContextElementsPropertyName());
            this.disposeElement(element);
        }

        public C removeContextElement(int index) {
            Object element = AbstractJpaNode.this.removeItemFromList(index, this.contextElements, this.getContextElementsPropertyName());
            this.disposeElement(element);
            return (C)element;
        }

        @Override
        public void removeAll(Iterable<C> elements) {
            AbstractJpaNode.this.removeItemsFromList(elements, this.contextElements, this.getContextElementsPropertyName());
            for (C element : elements) {
                this.disposeElement(element);
            }
        }

        @Override
        protected void disposeElement(C element) {
        }

        public void synchronizeWithResourceModel() {
            ListIterable<R> resourceElements = this.getResourceElements();
            int index = 0;
            for (Object resourceElement : resourceElements) {
                if (this.getContextElementsSize() > index) {
                    if (this.getContextElement(index) != resourceElement) {
                        this.addContextElement(index, resourceElement);
                    }
                } else {
                    this.addContextElement(index, resourceElement);
                }
                ++index;
            }
            while (index < this.getContextElementsSize()) {
                this.removeContextElement(index);
            }
        }
    }
}

