/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaNamedColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaNamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.resource.java.NamedColumnAnnotation;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaNamedColumn<A extends NamedColumnAnnotation, O extends JavaReadOnlyNamedColumn.Owner>
extends AbstractJavaJpaContextNode
implements JavaNamedColumn {
    protected final O owner;
    protected String specifiedName;
    protected String defaultName;
    protected String columnDefinition;

    protected AbstractJavaNamedColumn(JavaJpaContextNode parent, O owner) {
        this(parent, owner, null);
    }

    protected AbstractJavaNamedColumn(JavaJpaContextNode parent, O owner, A columnAnnotation) {
        super(parent);
        this.owner = owner;
        this.setColumnAnnotation(columnAnnotation);
        this.specifiedName = this.buildSpecifiedName();
        this.columnDefinition = this.buildColumnDefinition();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(this.buildSpecifiedName());
        this.setColumnDefinition_(this.buildColumnDefinition());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultName(this.buildDefaultName());
    }

    public abstract A getColumnAnnotation();

    protected void setColumnAnnotation(A columnAnnotation) {
        if (columnAnnotation != null) {
            throw new IllegalArgumentException("this method must be overridden if the column annotation is not null: " + columnAnnotation);
        }
    }

    protected void removeColumnAnnotationIfUnset() {
        if (this.getColumnAnnotation().isUnset()) {
            this.removeColumnAnnotation();
        }
    }

    protected abstract void removeColumnAnnotation();

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        if (this.valuesAreDifferent(this.specifiedName, name)) {
            this.getColumnAnnotation().setName(name);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedName_(name);
        }
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName() {
        return this.getColumnAnnotation().getName();
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected String buildDefaultName() {
        return this.owner.getDefaultColumnName(this);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void setColumnDefinition(String columnDefinition) {
        if (this.valuesAreDifferent(this.columnDefinition, columnDefinition)) {
            this.getColumnAnnotation().setColumnDefinition(columnDefinition);
            this.removeColumnAnnotationIfUnset();
            this.setColumnDefinition_(columnDefinition);
        }
    }

    protected void setColumnDefinition_(String columnDefinition) {
        String old = this.columnDefinition;
        this.columnDefinition = columnDefinition;
        this.firePropertyChanged("columnDefinition", old, columnDefinition);
    }

    public String buildColumnDefinition() {
        return this.getColumnAnnotation().getColumnDefinition();
    }

    protected Column getDbColumn() {
        Table table = this.getDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getName());
    }

    @Override
    public Table getDbTable() {
        return this.owner.resolveDbTable(this.getTable());
    }

    @Override
    public String getTable() {
        return this.owner.getDefaultTableName();
    }

    @Override
    public boolean isResolved() {
        return this.getDbColumn() != null;
    }

    @Override
    protected Iterable<String> getConnectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getConnectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.nameTouches(pos)) {
            return this.getJavaCandidateNames(filter);
        }
        return null;
    }

    protected boolean nameTouches(int pos) {
        return this.getColumnAnnotation().nameTouches(pos);
    }

    protected Iterable<String> getJavaCandidateNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateNames(filter));
    }

    protected Iterable<String> getCandidateNames(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateNames(), filter);
    }

    protected Iterable<String> getCandidateNames() {
        Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.buildValidator(astRoot).validate(messages, reporter);
    }

    protected JptValidator buildValidator(CompilationUnit astRoot) {
        return this.owner.buildColumnValidator(this, this.buildTextRangeResolver(astRoot));
    }

    protected NamedColumnTextRangeResolver buildTextRangeResolver(CompilationUnit astRoot) {
        return new JavaNamedColumnTextRangeResolver(this, astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getColumnAnnotation().getTextRange(astRoot);
        return textRange != null ? textRange : this.owner.getValidationTextRange(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getColumnAnnotation().getNameTextRange(), astRoot);
    }

    @Override
    public boolean isVirtual() {
        return !this.getColumnAnnotation().isSpecified();
    }

    protected void initializeFrom(ReadOnlyNamedColumn oldColumn) {
        this.setSpecifiedName(oldColumn.getSpecifiedName());
        this.setColumnDefinition(oldColumn.getColumnDefinition());
    }

    protected void initializeFromVirtual(ReadOnlyNamedColumn virtualColumn) {
        this.setSpecifiedName(virtualColumn.getName());
        this.setColumnDefinition(virtualColumn.getColumnDefinition());
    }

    public void toString(StringBuilder sb) {
        String table = this.getTable();
        if (table != null) {
            sb.append(table);
            sb.append('.');
        }
        sb.append(this.getName());
    }
}

