/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.facet;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetActionDelegate;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetInstallDataModelProperties;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.core.internal.operations.PersistenceFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.db.JptJpaDbPlugin;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.validation.ValidationFramework;

public class JpaFacetInstallDelegate
extends JpaFacetActionDelegate
implements JpaFacetInstallDataModelProperties {
    protected void execute_(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        ValidationFramework.getDefault().addValidationBuilder(project);
        super.execute_(project, fv, config, (IProgressMonitor)sm.newChild(1));
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IDataModel dataModel = (IDataModel)config;
        this.addDbDriverLibraryToClasspath(javaProject, dataModel, (IProgressMonitor)sm.newChild(1));
        this.createProjectXml(project, dataModel.getBooleanProperty("JpaFacetInstallDataModelProperties.CREATE_ORM_XML"), (IProgressMonitor)sm.newChild(8));
    }

    protected void addDbDriverLibraryToClasspath(IJavaProject javaProject, IDataModel dataModel, IProgressMonitor monitor) throws CoreException {
        if (!dataModel.getBooleanProperty("JpaFacetInstallDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH")) {
            return;
        }
        String driverName = dataModel.getStringProperty("JpaFacetInstallDataModelProperties.DB_DRIVER_NAME");
        IClasspathContainer container = JptJpaDbPlugin.instance().buildDriverClasspathContainerFor(driverName);
        IClasspathEntry entry = JavaCore.newContainerEntry((IPath)container.getPath());
        this.addClasspathEntryToProject(entry, javaProject, monitor);
    }

    private void addClasspathEntryToProject(IClasspathEntry classpathEntry, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        Object[] classpath = javaProject.getRawClasspath();
        if (ArrayTools.contains((Object[])classpath, (Object)classpathEntry)) {
            return;
        }
        int len = classpath.length;
        IClasspathEntry[] newClasspath = new IClasspathEntry[len + 1];
        System.arraycopy(classpath, 0, newClasspath, 0, len);
        newClasspath[len] = classpathEntry;
        javaProject.setRawClasspath(newClasspath, monitor);
    }

    private void createProjectXml(IProject project, boolean buildOrmXml, IProgressMonitor monitor) {
        int tasks = 1 + (buildOrmXml ? 1 : 0);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)tasks);
        this.createPersistenceXml(project, (IProgressMonitor)sm.newChild(1));
        if (buildOrmXml) {
            this.createOrmXml(project, (IProgressMonitor)sm.newChild(1));
        }
    }

    private void createPersistenceXml(IProject project, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new PersistenceFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.defaultResourceLocation(project));
        sm.worked(1);
        try {
            config.getDefaultOperation().execute((IProgressMonitor)sm.newChild(4), null);
        }
        catch (ExecutionException ex) {
            JptJpaCorePlugin.log(ex);
        }
    }

    private void createOrmXml(IProject project, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new OrmFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.defaultResourceLocation(project));
        sm.worked(1);
        try {
            config.getDefaultOperation().execute((IProgressMonitor)sm.newChild(4), null);
        }
        catch (ExecutionException ex) {
            JptJpaCorePlugin.log(ex);
        }
    }

    protected IPath defaultResourceLocation(IProject project) {
        ProjectResourceLocator resourceLocator = (ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class);
        if (resourceLocator == null) {
            JptJpaCorePlugin.log("No resource locator for project: " + project);
            return null;
        }
        return resourceLocator.getDefaultResourceLocation().getFullPath();
    }
}

