/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.ArrayList;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.ReadOnlyUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.TableGenerator;
import org.eclipse.jpt.jpa.core.context.UniqueConstraint;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaTableGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaGenerator;
import org.eclipse.jpt.jpa.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaTableGenerator
extends AbstractJavaGenerator<TableGeneratorAnnotation>
implements JavaTableGenerator,
ReadOnlyUniqueConstraint.Owner {
    protected String specifiedTable;
    protected String defaultTable;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedPkColumnName;
    protected String defaultPkColumnName;
    protected String specifiedValueColumnName;
    protected String defaultValueColumnName;
    protected String specifiedPkColumnValue;
    protected String defaultPkColumnValue;
    protected final AbstractJpaNode.ContextListContainer<JavaUniqueConstraint, UniqueConstraintAnnotation> uniqueConstraintContainer;

    public GenericJavaTableGenerator(JavaGeneratorContainer parent, TableGeneratorAnnotation generatorAnnotation) {
        super(parent, generatorAnnotation);
        this.specifiedTable = generatorAnnotation.getTable();
        this.specifiedSchema = generatorAnnotation.getSchema();
        this.specifiedCatalog = generatorAnnotation.getCatalog();
        this.specifiedPkColumnName = generatorAnnotation.getPkColumnName();
        this.specifiedValueColumnName = generatorAnnotation.getValueColumnName();
        this.specifiedPkColumnValue = generatorAnnotation.getPkColumnValue();
        this.uniqueConstraintContainer = this.buildUniqueConstraintContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedTable_(((TableGeneratorAnnotation)this.generatorAnnotation).getTable());
        this.setSpecifiedSchema_(((TableGeneratorAnnotation)this.generatorAnnotation).getSchema());
        this.setSpecifiedCatalog_(((TableGeneratorAnnotation)this.generatorAnnotation).getCatalog());
        this.setSpecifiedPkColumnName_(((TableGeneratorAnnotation)this.generatorAnnotation).getPkColumnName());
        this.setSpecifiedValueColumnName_(((TableGeneratorAnnotation)this.generatorAnnotation).getValueColumnName());
        this.setSpecifiedPkColumnValue_(((TableGeneratorAnnotation)this.generatorAnnotation).getPkColumnValue());
        this.syncUniqueConstraints();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultTable(this.buildDefaultTable());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.setDefaultPkColumnName(this.buildDefaultPkColumnName());
        this.setDefaultValueColumnName(this.buildDefaultValueColumnName());
        this.setDefaultPkColumnValue(this.buildDefaultPkColumnValue());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getUniqueConstraints());
    }

    @Override
    protected int buildDefaultInitialValue() {
        return 0;
    }

    @Override
    public String getTable() {
        return this.specifiedTable != null ? this.specifiedTable : this.defaultTable;
    }

    @Override
    public String getSpecifiedTable() {
        return this.specifiedTable;
    }

    @Override
    public void setSpecifiedTable(String table) {
        ((TableGeneratorAnnotation)this.generatorAnnotation).setTable(table);
        this.setSpecifiedTable_(table);
    }

    protected void setSpecifiedTable_(String table) {
        String old = this.specifiedTable;
        this.specifiedTable = table;
        this.firePropertyChanged("specifiedTable", old, table);
    }

    @Override
    public String getDefaultTable() {
        return this.defaultTable;
    }

    protected void setDefaultTable(String table) {
        String old = this.defaultTable;
        this.defaultTable = table;
        this.firePropertyChanged("defaultTable", old, table);
    }

    protected String buildDefaultTable() {
        return null;
    }

    @Override
    public Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getTable());
    }

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        ((TableGeneratorAnnotation)this.generatorAnnotation).setSchema(schema);
        this.setSpecifiedSchema_(schema);
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        ((TableGeneratorAnnotation)this.generatorAnnotation).setCatalog(catalog);
        this.setSpecifiedCatalog_(catalog);
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    public String getPkColumnName() {
        return this.specifiedPkColumnName != null ? this.specifiedPkColumnName : this.defaultPkColumnName;
    }

    @Override
    public String getSpecifiedPkColumnName() {
        return this.specifiedPkColumnName;
    }

    @Override
    public void setSpecifiedPkColumnName(String name) {
        ((TableGeneratorAnnotation)this.generatorAnnotation).setPkColumnName(name);
        this.setSpecifiedPkColumnName_(name);
    }

    protected void setSpecifiedPkColumnName_(String name) {
        String old = this.specifiedPkColumnName;
        this.specifiedPkColumnName = name;
        this.firePropertyChanged("specifiedPkColumnName", old, name);
    }

    @Override
    public String getDefaultPkColumnName() {
        return this.defaultPkColumnName;
    }

    protected void setDefaultPkColumnName(String name) {
        String old = this.defaultPkColumnName;
        this.defaultPkColumnName = name;
        this.firePropertyChanged("defaultPkColumnName", old, name);
    }

    protected String buildDefaultPkColumnName() {
        return null;
    }

    @Override
    public String getValueColumnName() {
        return this.specifiedValueColumnName != null ? this.specifiedValueColumnName : this.defaultValueColumnName;
    }

    @Override
    public String getSpecifiedValueColumnName() {
        return this.specifiedValueColumnName;
    }

    @Override
    public void setSpecifiedValueColumnName(String name) {
        ((TableGeneratorAnnotation)this.generatorAnnotation).setValueColumnName(name);
        this.setSpecifiedValueColumnName_(name);
    }

    protected void setSpecifiedValueColumnName_(String name) {
        String old = this.specifiedValueColumnName;
        this.specifiedValueColumnName = name;
        this.firePropertyChanged("specifiedValueColumnName", old, name);
    }

    @Override
    public String getDefaultValueColumnName() {
        return this.defaultValueColumnName;
    }

    protected void setDefaultValueColumnName(String name) {
        String old = this.defaultValueColumnName;
        this.defaultValueColumnName = name;
        this.firePropertyChanged("defaultValueColumnName", old, name);
    }

    protected String buildDefaultValueColumnName() {
        return null;
    }

    @Override
    public String getPkColumnValue() {
        return this.specifiedPkColumnValue != null ? this.specifiedPkColumnValue : this.defaultPkColumnValue;
    }

    @Override
    public String getSpecifiedPkColumnValue() {
        return this.specifiedPkColumnValue;
    }

    @Override
    public void setSpecifiedPkColumnValue(String value) {
        ((TableGeneratorAnnotation)this.generatorAnnotation).setPkColumnValue(value);
        this.setSpecifiedPkColumnValue_(value);
    }

    protected void setSpecifiedPkColumnValue_(String value) {
        String old = this.specifiedPkColumnValue;
        this.specifiedPkColumnValue = value;
        this.firePropertyChanged("specifiedPkColummValue", old, value);
    }

    @Override
    public String getDefaultPkColumnValue() {
        return this.defaultPkColumnValue;
    }

    protected void setDefaultPkColumnValue(String value) {
        String old = this.defaultPkColumnValue;
        this.defaultPkColumnValue = value;
        this.firePropertyChanged("defaultPkColummValue", old, value);
    }

    protected String buildDefaultPkColumnValue() {
        return null;
    }

    public ListIterable<JavaUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraintContainer.getContextElements();
    }

    @Override
    public int getUniqueConstraintsSize() {
        return this.uniqueConstraintContainer.getContextElementsSize();
    }

    @Override
    public JavaUniqueConstraint getUniqueConstraint(int index) {
        return this.uniqueConstraintContainer.getContextElement(index);
    }

    @Override
    public JavaUniqueConstraint addUniqueConstraint() {
        return this.addUniqueConstraint(this.getUniqueConstraintsSize());
    }

    @Override
    public JavaUniqueConstraint addUniqueConstraint(int index) {
        UniqueConstraintAnnotation annotation = ((TableGeneratorAnnotation)this.getGeneratorAnnotation()).addUniqueConstraint(index);
        return (JavaUniqueConstraint)this.uniqueConstraintContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeUniqueConstraint(int index) {
        ((TableGeneratorAnnotation)this.getGeneratorAnnotation()).removeUniqueConstraint(index);
        this.uniqueConstraintContainer.removeContextElement(index);
    }

    @Override
    public void removeUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraintContainer.indexOfContextElement((JavaUniqueConstraint)uniqueConstraint));
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        ((TableGeneratorAnnotation)this.getGeneratorAnnotation()).moveUniqueConstraint(targetIndex, sourceIndex);
        this.uniqueConstraintContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected void syncUniqueConstraints() {
        this.uniqueConstraintContainer.synchronizeWithResourceModel();
    }

    protected void updateUniqueConstraints() {
        this.uniqueConstraintContainer.synchronizeWithResourceModel();
    }

    protected JavaUniqueConstraint buildUniqueConstraint(UniqueConstraintAnnotation constraintAnnotation) {
        return this.getJpaFactory().buildJavaUniqueConstraint(this, this, constraintAnnotation);
    }

    protected ListIterable<UniqueConstraintAnnotation> getUniqueConstraintAnnotations() {
        return ((TableGeneratorAnnotation)this.getGeneratorAnnotation()).getUniqueConstraints();
    }

    protected AbstractJpaNode.ContextListContainer<JavaUniqueConstraint, UniqueConstraintAnnotation> buildUniqueConstraintContainer() {
        UniqueConstraintContainer container = new UniqueConstraintContainer();
        container.initialize();
        return container;
    }

    @Override
    public Iterable<String> getCandidateUniqueConstraintColumnNames() {
        Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaUniqueConstraint constraint : this.getUniqueConstraints()) {
            result = constraint.getJavaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected Iterable<String> getConnectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getConnectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.tableTouches(pos)) {
            return this.getJavaCandidateTables(filter);
        }
        if (this.schemaTouches(pos)) {
            return this.getJavaCandidateSchemata(filter);
        }
        if (this.pkColumnNameTouches(pos)) {
            return this.getJavaCandidateColumnNames(filter);
        }
        if (this.valueColumnNameTouches(pos)) {
            return this.getJavaCandidateColumnNames(filter);
        }
        return null;
    }

    protected boolean tableTouches(int pos) {
        return ((TableGeneratorAnnotation)this.generatorAnnotation).tableTouches(pos);
    }

    protected Iterable<String> getJavaCandidateTables(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateTables(filter));
    }

    protected Iterable<String> getCandidateTables(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateTables(), filter);
    }

    protected Iterable<String> getCandidateTables() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.getSortedTableIdentifiers() : EmptyIterable.instance();
    }

    protected boolean schemaTouches(int pos) {
        return ((TableGeneratorAnnotation)this.generatorAnnotation).schemaTouches(pos);
    }

    protected Iterable<String> getJavaCandidateSchemata(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateSchemata(filter));
    }

    protected Iterable<String> getCandidateSchemata(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateSchemata(), filter);
    }

    protected Iterable<String> getCandidateSchemata() {
        SchemaContainer schemaContainer = this.getDbSchemaContainer();
        return schemaContainer != null ? schemaContainer.getSortedSchemaIdentifiers() : EmptyIterable.instance();
    }

    protected boolean catalogTouches(int pos) {
        return ((TableGeneratorAnnotation)this.generatorAnnotation).catalogTouches(pos);
    }

    protected Iterable<String> getJavaCandidateCatalogs(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateCatalogs(filter));
    }

    protected Iterable<String> getCandidateCatalogs(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateCatalogs(), filter);
    }

    protected Iterable<String> getCandidateCatalogs() {
        Database db = this.getDatabase();
        return db != null ? db.getSortedCatalogIdentifiers() : EmptyIterable.instance();
    }

    protected boolean pkColumnNameTouches(int pos) {
        return ((TableGeneratorAnnotation)this.generatorAnnotation).pkColumnNameTouches(pos);
    }

    protected Iterable<String> getJavaCandidateColumnNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateColumnNames(filter));
    }

    protected Iterable<String> getCandidateColumnNames(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateColumnNames(), filter);
    }

    protected Iterable<String> getCandidateColumnNames() {
        Table table = this.getDbTable();
        return table != null ? table.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    protected boolean valueColumnNameTouches(int pos) {
        return ((TableGeneratorAnnotation)this.generatorAnnotation).valueColumnNameTouches(pos);
    }

    @Override
    public void convertTo(EntityMappings entityMappings) {
        entityMappings.addTableGenerator().convertFrom(this);
    }

    @Override
    public void delete() {
        this.getParent().removeTableGenerator();
    }

    public Class<TableGenerator> getType() {
        return TableGenerator.class;
    }

    @Override
    protected boolean isEquivalentTo(Generator generator) {
        return super.isEquivalentTo(generator) && this.isEquivalentTo((TableGenerator)generator);
    }

    protected boolean isEquivalentTo(TableGenerator generator) {
        return Tools.valuesAreEqual((Object)this.specifiedTable, (Object)generator.getSpecifiedTable()) && Tools.valuesAreEqual((Object)this.specifiedSchema, (Object)generator.getSpecifiedSchema()) && Tools.valuesAreEqual((Object)this.specifiedCatalog, (Object)generator.getSpecifiedCatalog()) && Tools.valuesAreEqual((Object)this.specifiedPkColumnName, (Object)generator.getSpecifiedPkColumnName()) && Tools.valuesAreEqual((Object)this.specifiedPkColumnValue, (Object)generator.getSpecifiedPkColumnValue()) && Tools.valuesAreEqual((Object)this.specifiedValueColumnName, (Object)generator.getSpecifiedValueColumnName()) && this.uniqueConstrainsAreEquivalentTo(generator);
    }

    protected boolean uniqueConstrainsAreEquivalentTo(TableGenerator generator) {
        ArrayList uniqueConstraints1 = CollectionTools.list(this.getUniqueConstraints());
        ArrayList uniqueConstraints2 = CollectionTools.list(generator.getUniqueConstraints());
        if (uniqueConstraints1.size() != uniqueConstraints2.size()) {
            return false;
        }
        int i = 0;
        while (i < uniqueConstraints1.size()) {
            if (!((JavaUniqueConstraint)uniqueConstraints1.get(i)).isEquivalentTo((UniqueConstraint)uniqueConstraints2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UniqueConstraintContainer
    extends AbstractJpaNode.ContextListContainer<JavaUniqueConstraint, UniqueConstraintAnnotation> {
        protected UniqueConstraintContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "uniqueConstraints";
        }

        @Override
        protected JavaUniqueConstraint buildContextElement(UniqueConstraintAnnotation resourceElement) {
            return GenericJavaTableGenerator.this.buildUniqueConstraint(resourceElement);
        }

        @Override
        protected ListIterable<UniqueConstraintAnnotation> getResourceElements() {
            return GenericJavaTableGenerator.this.getUniqueConstraintAnnotations();
        }

        @Override
        protected UniqueConstraintAnnotation getResourceElement(JavaUniqueConstraint contextElement) {
            return contextElement.getUniqueConstraintAnnotation();
        }
    }
}

