/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTableRelationship;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.ReadOnlyRelationship;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.JoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.TableTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmVirtualOverrideRelationship2_0;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmVirtualOverrideJoinTableRelationshipStrategy2_0
extends AbstractOrmXmlContextNode
implements OrmVirtualJoinTableRelationshipStrategy,
ReadOnlyTable.Owner {
    protected OrmVirtualJoinTable joinTable;

    public GenericOrmVirtualOverrideJoinTableRelationshipStrategy2_0(OrmVirtualOverrideRelationship2_0 parent) {
        super(parent);
    }

    @Override
    public void update() {
        super.update();
        this.updateJoinTable();
    }

    @Override
    public OrmVirtualJoinTable getJoinTable() {
        return this.joinTable;
    }

    protected void setJoinTable(OrmVirtualJoinTable joinTable) {
        OrmVirtualJoinTable old = this.joinTable;
        this.joinTable = joinTable;
        this.firePropertyChanged("joinTable", old, joinTable);
    }

    protected void updateJoinTable() {
        ReadOnlyJoinTable overriddenJoinTable = this.getOverriddenJoinTable();
        if (overriddenJoinTable == null) {
            if (this.joinTable != null) {
                this.setJoinTable(null);
            }
        } else if (this.joinTable != null && this.joinTable.getOverriddenTable() == overriddenJoinTable) {
            this.joinTable.update();
        } else {
            this.setJoinTable(this.buildJoinTable(overriddenJoinTable));
        }
    }

    protected ReadOnlyJoinTable getOverriddenJoinTable() {
        ReadOnlyJoinTableRelationshipStrategy overriddenStrategy = this.getOverriddenStrategy();
        return overriddenStrategy == null ? null : overriddenStrategy.getJoinTable();
    }

    protected OrmVirtualJoinTable buildJoinTable(ReadOnlyJoinTable overriddenJoinTable) {
        return this.getContextNodeFactory().buildOrmVirtualJoinTable(this, this, overriddenJoinTable);
    }

    @Override
    public OrmVirtualOverrideRelationship2_0 getParent() {
        return (OrmVirtualOverrideRelationship2_0)super.getParent();
    }

    @Override
    public OrmVirtualOverrideRelationship2_0 getRelationship() {
        return this.getParent();
    }

    protected ReadOnlyJoinTableRelationshipStrategy getOverriddenStrategy() {
        ReadOnlyJoinTableRelationship relationship = this.getOverriddenJoinTableRelationship();
        return relationship == null ? null : relationship.getJoinTableStrategy();
    }

    protected ReadOnlyJoinTableRelationship getOverriddenJoinTableRelationship() {
        ReadOnlyRelationship relationship = this.resolveOverriddenRelationship();
        return relationship instanceof ReadOnlyJoinTableRelationship ? (ReadOnlyJoinTableRelationship)relationship : null;
    }

    protected ReadOnlyRelationship resolveOverriddenRelationship() {
        return this.getRelationship().resolveOverriddenRelationship();
    }

    @Override
    public String getTableName() {
        return this.joinTable.getName();
    }

    @Override
    public String getJoinTableDefaultName() {
        return MappingTools.buildJoinTableDefaultName(this.getRelationship());
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.joinTable != null) {
            this.joinTable.validate(messages, reporter);
        }
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getRelationship().getTypeMapping().validatesAgainstDatabase();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getRelationship().getValidationTextRange();
    }

    @Override
    public JptValidator buildTableValidator(ReadOnlyTable table, TableTextRangeResolver textRangeResolver) {
        return this.getRelationship().buildJoinTableValidator((ReadOnlyJoinTable)table, textRangeResolver);
    }

    @Override
    public JptValidator buildJoinTableJoinColumnValidator(ReadOnlyJoinColumn column, ReadOnlyJoinColumn.Owner owner, JoinColumnTextRangeResolver textRangeResolver) {
        return this.getRelationship().buildJoinTableJoinColumnValidator(column, owner, textRangeResolver);
    }

    @Override
    public JptValidator buildJoinTableInverseJoinColumnValidator(ReadOnlyJoinColumn column, ReadOnlyJoinColumn.Owner owner, JoinColumnTextRangeResolver textRangeResolver) {
        return this.getRelationship().buildJoinTableInverseJoinColumnValidator(column, owner, textRangeResolver);
    }
}

