/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceSequenceGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.SequenceGenerator2_0Annotation;

public final class SourceSequenceGenerator2_0Annotation
extends SourceSequenceGeneratorAnnotation
implements SequenceGenerator2_0Annotation {
    private static final DeclarationAnnotationElementAdapter<String> CATALOG_ADAPTER = SourceSequenceGenerator2_0Annotation.buildAdapter("catalog");
    private final AnnotationElementAdapter<String> catalogAdapter = this.buildAdapter(CATALOG_ADAPTER);
    private String catalog;
    private TextRange catalogTextRange;
    private static final DeclarationAnnotationElementAdapter<String> SCHEMA_ADAPTER = SourceSequenceGenerator2_0Annotation.buildAdapter("schema");
    private final AnnotationElementAdapter<String> schemaAdapter = this.buildAdapter(SCHEMA_ADAPTER);
    private String schema;
    private TextRange schemaTextRange;

    public SourceSequenceGenerator2_0Annotation(JavaResourceNode parent, AnnotatedElement element) {
        super(parent, element);
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.catalog = this.buildCatalog(astRoot);
        this.catalogTextRange = this.buildCatalogTextRange(astRoot);
        this.schema = this.buildSchema(astRoot);
        this.schemaTextRange = this.buildSchemaTextRange(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncCatalog(this.buildCatalog(astRoot));
        this.catalogTextRange = this.buildCatalogTextRange(astRoot);
        this.syncSchema(this.buildSchema(astRoot));
        this.schemaTextRange = this.buildSchemaTextRange(astRoot);
    }

    public boolean isUnset() {
        return super.isUnset() && this.catalog == null && this.schema == null;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        if (this.attributeValueHasChanged(this.catalog, catalog)) {
            this.catalog = catalog;
            this.catalogAdapter.setValue((Object)catalog);
        }
    }

    private void syncCatalog(String astCatalog) {
        String old = this.catalog;
        this.catalog = astCatalog;
        this.firePropertyChanged("catalog", old, astCatalog);
    }

    private String buildCatalog(CompilationUnit astRoot) {
        return (String)this.catalogAdapter.getValue(astRoot);
    }

    public TextRange getCatalogTextRange() {
        return this.catalogTextRange;
    }

    private TextRange buildCatalogTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(CATALOG_ADAPTER, astRoot);
    }

    public boolean catalogTouches(int pos) {
        return this.textRangeTouches(this.catalogTextRange, pos);
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        if (this.attributeValueHasChanged(this.schema, schema)) {
            this.schema = schema;
            this.schemaAdapter.setValue((Object)schema);
        }
    }

    private void syncSchema(String astSchema) {
        String old = this.schema;
        this.schema = astSchema;
        this.firePropertyChanged("schema", old, astSchema);
    }

    private String buildSchema(CompilationUnit astRoot) {
        return (String)this.schemaAdapter.getValue(astRoot);
    }

    public TextRange getSchemaTextRange() {
        return this.schemaTextRange;
    }

    private TextRange buildSchemaTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SCHEMA_ADAPTER, astRoot);
    }

    public boolean schemaTouches(int pos) {
        return this.textRangeTouches(this.schemaTextRange, pos);
    }
}

