/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.resource;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jem.util.emf.workbench.EMFWorkbenchContextBase;
import org.eclipse.jem.util.emf.workbench.FlexibleProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.IEMFContextContributor;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.resource.JpaXmlResourceProvider;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateInputProvider;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorImpl;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorPresenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXmlResourceProvider
implements JpaXmlResourceProvider,
IEMFContextContributor,
ResourceStateInputProvider,
ResourceStateValidator {
    protected IProject project;
    protected URI fileUri;
    protected JpaXmlResource resource;
    protected IContentType contentType;
    protected ResourceStateValidator stateValidator;
    private boolean contributedToEmfContext = false;

    public AbstractXmlResourceProvider(IProject project, IPath resourcePath, IContentType contentType) {
        this.project = project;
        this.fileUri = this.buildFileUri(resourcePath);
        this.contentType = contentType;
    }

    protected URI buildFileUri(IPath resourcePath) {
        URI resourceUri = null;
        if (resourcePath.isAbsolute()) {
            resourceUri = URI.createPlatformResourceURI((String)resourcePath.toString(), (boolean)false);
        } else {
            IPath absolutePath = this.getProjectResourceLocator().getResourcePath(resourcePath);
            resourceUri = URI.createPlatformResourceURI((String)absolutePath.toString(), (boolean)false);
        }
        URIConverter uriConverter = this.getResourceSet().getURIConverter();
        return uriConverter.normalize(resourceUri);
    }

    protected ProjectResourceLocator getProjectResourceLocator() {
        return (ProjectResourceLocator)this.project.getAdapter(ProjectResourceLocator.class);
    }

    @Override
    public JpaXmlResource getXmlResource() {
        if (this.resource == null) {
            JpaXmlResource newResource = (JpaXmlResource)WorkbenchResourceHelper.getOrCreateResource((URI)this.fileUri, (ResourceSet)this.getResourceSet());
            if (newResource == null) {
                return null;
            }
            if (newResource.getContentType().equals(this.contentType)) {
                this.resource = newResource;
            } else {
                this.createResourceAndLoad();
            }
        }
        return this.resource;
    }

    protected JpaXmlResource createResourceAndLoad() {
        this.resource = this.createResource();
        this.loadResource();
        return this.resource;
    }

    protected JpaXmlResource createResource() {
        Resource.Factory resourceFactory = WTPResourceFactoryRegistry.INSTANCE.getFactory(this.fileUri, this.contentType.getDefaultDescription());
        return (JpaXmlResource)this.getResourceSet().createResource(this.fileUri, resourceFactory);
    }

    protected void loadResource() {
        try {
            this.resource.load(this.getResourceSet().getLoadOptions());
        }
        catch (IOException e) {
            JptJpaCorePlugin.log(e);
        }
    }

    protected void createResourceAndUnderlyingFile(Object config) {
        this.resource = this.createResource();
        if (this.resource.fileExists()) {
            this.loadResource();
        } else {
            this.populateRoot(config);
            try {
                this.resource.saveIfNecessary();
            }
            catch (Exception e) {
                JptJpaCorePlugin.log(e);
            }
        }
    }

    public JpaXmlResource createFileAndResource(final Object config, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                AbstractXmlResourceProvider.this.createResourceAndUnderlyingFile(config);
            }
        };
        workspace.run(runnable, (ISchedulingRule)this.project, 1, monitor);
        return this.resource;
    }

    protected void populateRoot(Object config) {
    }

    protected EList<EObject> getResourceContents() {
        return this.resource.getContents();
    }

    protected FlexibleProjectResourceSet getResourceSet() {
        return (FlexibleProjectResourceSet)this.getEmfContext().getResourceSet();
    }

    protected EMFWorkbenchContextBase getEmfContext() {
        return WorkbenchResourceHelper.createEMFContext((IProject)this.project, (IEMFContextContributor)this);
    }

    public IProject getProject() {
        return this.project;
    }

    @Override
    public IStatus validateEdit(Object context) {
        IWorkspace work = ResourcesPlugin.getWorkspace();
        IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
        if (file != null) {
            IFile[] files = new IFile[]{file};
            if (context == null) {
                context = IWorkspace.VALIDATE_PROMPT;
            }
            return work.validateEdit(files, context);
        }
        return Status.OK_STATUS;
    }

    public void primaryContributeToContext(EMFWorkbenchContextBase context) {
        if (!this.contributedToEmfContext) {
            context.getResourceSet().setResourceFactoryRegistry((Resource.Factory.Registry)WTPResourceFactoryRegistry.INSTANCE);
            this.contributedToEmfContext = true;
        }
    }

    public void secondaryContributeToContext(EMFWorkbenchContextBase aNature) {
    }

    public ResourceStateValidator getStateValidator() {
        if (this.stateValidator == null) {
            this.stateValidator = this.createStateValidator();
        }
        return this.stateValidator;
    }

    private ResourceStateValidator createStateValidator() {
        return new ResourceStateValidatorImpl((ResourceStateInputProvider)this);
    }

    public void checkActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().checkActivation(presenter);
    }

    public void lostActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().lostActivation(presenter);
    }

    public IStatus validateState(ResourceStateValidatorPresenter presenter) throws CoreException {
        if (presenter == null) {
            return Status.OK_STATUS;
        }
        return this.getStateValidator().validateState(presenter);
    }

    public boolean checkSave(ResourceStateValidatorPresenter presenter) throws CoreException {
        return this.getStateValidator().checkSave(presenter);
    }

    public boolean checkReadOnly() {
        return this.getStateValidator().checkReadOnly();
    }

    public boolean isDirty() {
        return this.resource.isModified();
    }

    public List getNonResourceFiles() {
        return Collections.emptyList();
    }

    public List getNonResourceInconsistentFiles() {
        return Collections.emptyList();
    }

    public List getResources() {
        return Collections.singletonList(this.getXmlResource());
    }

    public void cacheNonResourceValidateState(List roNonResourceFiles) {
    }
}

