/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal;

import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.jpa.core.JpaAnnotationDefinitionProvider;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaFactory;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPlatformFactory;
import org.eclipse.jpt.jpa.core.JpaPlatformVariation;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.internal.GenericJpaAnnotationDefinitionProvider;
import org.eclipse.jpt.jpa.core.internal.GenericJpaPlatform;
import org.eclipse.jpt.jpa.core.internal.GenericJpaPlatformFactory;
import org.eclipse.jpt.jpa.core.internal.JpaAnnotationProvider;
import org.eclipse.jpt.jpa.eclipselink.core.internal.EclipseLinkJpaAnnotationDefinitionProvider;
import org.eclipse.jpt.jpa.eclipselink.core.internal.EclipseLinkJpaFactory;
import org.eclipse.jpt.jpa.eclipselink.core.internal.EclipseLinkJpaPlatformProvider;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkJPQLGrammar1;

public class EclipseLinkJpaPlatformFactory
implements JpaPlatformFactory {
    public JpaPlatform buildJpaPlatform(String id) {
        return new GenericJpaPlatform(id, this.buildJpaVersion(), (JpaFactory)new EclipseLinkJpaFactory(), this.buildAnnotationProvider(), EclipseLinkJpaPlatformProvider.instance(), this.buildJpaPlatformVariation(), EclipseLinkJPQLGrammar1.instance());
    }

    private JpaPlatform.Version buildJpaVersion() {
        return new EclipseLinkVersion("1.0", JpaFacet.VERSION_1_0.getVersionString());
    }

    protected AnnotationProvider buildAnnotationProvider() {
        return new JpaAnnotationProvider(new JpaAnnotationDefinitionProvider[]{GenericJpaAnnotationDefinitionProvider.instance(), EclipseLinkJpaAnnotationDefinitionProvider.instance()});
    }

    protected JpaPlatformVariation buildJpaPlatformVariation() {
        return new JpaPlatformVariation(){

            public JpaPlatformVariation.Supported getTablePerConcreteClassInheritanceIsSupported() {
                return JpaPlatformVariation.Supported.NO;
            }

            public boolean isJoinTableOverridable() {
                return false;
            }

            public AccessType[] getSupportedAccessTypes(JptResourceType resourceType) {
                return GENERIC_SUPPORTED_ACCESS_TYPES;
            }
        };
    }

    public static class EclipseLinkVersion
    extends GenericJpaPlatformFactory.SimpleVersion {
        protected final String eclipseLinkVersion;

        public EclipseLinkVersion(String eclipseLinkVersion, String jpaVersion) {
            super(jpaVersion);
            this.eclipseLinkVersion = eclipseLinkVersion;
        }

        public String getVersion() {
            return this.eclipseLinkVersion;
        }

        public boolean isCompatibleWithVersion(String version) {
            return VERSION_COMPARATOR.compare(this.eclipseLinkVersion, version) >= 0;
        }

        public String toString() {
            return String.valueOf(super.toString()) + " EclipseLink version: " + this.getVersion();
        }
    }
}

