/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConversionValueAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEclipseLinkConversionValue
extends AbstractJavaJpaContextNode
implements EclipseLinkConversionValue {
    private final EclipseLinkConversionValueAnnotation conversionValueAnnotation;
    private String dataValue;
    private String objectValue;

    public JavaEclipseLinkConversionValue(JavaEclipseLinkObjectTypeConverter parent, EclipseLinkConversionValueAnnotation conversionValueAnnotation) {
        super((JpaContextNode)parent);
        this.conversionValueAnnotation = conversionValueAnnotation;
        this.dataValue = conversionValueAnnotation.getDataValue();
        this.objectValue = conversionValueAnnotation.getObjectValue();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setDataValue_(this.conversionValueAnnotation.getDataValue());
        this.setObjectValue_(this.conversionValueAnnotation.getObjectValue());
    }

    @Override
    public String getDataValue() {
        return this.dataValue;
    }

    @Override
    public void setDataValue(String value) {
        this.conversionValueAnnotation.setDataValue(value);
        this.setDataValue_(value);
    }

    protected void setDataValue_(String value) {
        String old = this.dataValue;
        this.dataValue = value;
        this.firePropertyChanged("dataValue", old, value);
    }

    @Override
    public String getObjectValue() {
        return this.objectValue;
    }

    @Override
    public void setObjectValue(String value) {
        this.conversionValueAnnotation.setObjectValue(value);
        this.setObjectValue_(value);
    }

    protected void setObjectValue_(String value) {
        String old = this.objectValue;
        this.objectValue = value;
        this.firePropertyChanged("objectValue", old, value);
    }

    @Override
    public JavaEclipseLinkObjectTypeConverter getParent() {
        return (JavaEclipseLinkObjectTypeConverter)super.getParent();
    }

    protected JavaEclipseLinkObjectTypeConverter getObjectTypeConverter() {
        return this.getParent();
    }

    public EclipseLinkConversionValueAnnotation getConversionValueAnnotation() {
        return this.conversionValueAnnotation;
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
    }

    public TextRange getDataValueTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.conversionValueAnnotation.getDataValueTextRange(), astRoot);
    }

    protected TextRange getObjectValueTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.conversionValueAnnotation.getObjectValueTextRange(), astRoot);
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.conversionValueAnnotation.getTextRange(astRoot);
        return textRange != null ? textRange : this.getObjectTypeConverter().getValidationTextRange(astRoot);
    }

    @Override
    public boolean isEquivalentTo(EclipseLinkConversionValue conversionValue) {
        return Tools.valuesAreEqual((Object)this.dataValue, (Object)conversionValue.getDataValue()) && Tools.valuesAreEqual((Object)this.objectValue, (Object)conversionValue.getObjectValue());
    }
}

