/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTracking;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTrackingType;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaTypeMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmTypeMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlChangeTracking;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlChangeTrackingHolder;

public class OrmEclipseLinkChangeTracking
extends AbstractOrmXmlContextNode
implements EclipseLinkChangeTracking {
    protected EclipseLinkChangeTrackingType specifiedType;
    protected EclipseLinkChangeTrackingType defaultType = DEFAULT_TYPE;

    public OrmEclipseLinkChangeTracking(EclipseLinkOrmTypeMapping parent) {
        super((JpaContextNode)parent);
        this.specifiedType = this.buildSpecifiedType();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedType_(this.buildSpecifiedType());
    }

    public void update() {
        super.update();
        this.setDefaultType(this.buildDefaultType());
    }

    public EclipseLinkChangeTrackingType getType() {
        return this.specifiedType != null ? this.specifiedType : this.defaultType;
    }

    public EclipseLinkChangeTrackingType getSpecifiedType() {
        return this.specifiedType;
    }

    public void setSpecifiedType(EclipseLinkChangeTrackingType type) {
        if (this.specifiedType != type) {
            XmlChangeTracking xmlChangeTracking = this.getXmlChangeTrackingForUpdate();
            this.setSpecifiedType_(type);
            xmlChangeTracking.setType(EclipseLinkChangeTrackingType.toOrmResourceModel(type));
            this.removeXmlChangeTrackingIfUnset();
        }
    }

    protected void setSpecifiedType_(EclipseLinkChangeTrackingType type) {
        EclipseLinkChangeTrackingType old = this.specifiedType;
        this.specifiedType = type;
        this.firePropertyChanged("specifiedType", (Object)old, (Object)type);
    }

    protected EclipseLinkChangeTrackingType buildSpecifiedType() {
        XmlChangeTracking xmlChangeTracking = this.getXmlChangeTracking();
        return xmlChangeTracking == null ? null : EclipseLinkChangeTrackingType.fromOrmResourceModel(xmlChangeTracking.getType());
    }

    public EclipseLinkChangeTrackingType getDefaultType() {
        return this.defaultType;
    }

    protected void setDefaultType(EclipseLinkChangeTrackingType type) {
        EclipseLinkChangeTrackingType old = this.defaultType;
        this.defaultType = type;
        this.firePropertyChanged("defaultType", (Object)old, (Object)type);
    }

    protected EclipseLinkChangeTrackingType buildDefaultType() {
        EclipseLinkChangeTracking javaChangeTracking = this.getJavaChangeTrackingForDefaults();
        return javaChangeTracking != null ? javaChangeTracking.getType() : DEFAULT_TYPE;
    }

    protected XmlChangeTracking getXmlChangeTracking() {
        return this.getXmlChangeTrackingHolder().getChangeTracking();
    }

    protected XmlChangeTracking getXmlChangeTrackingForUpdate() {
        XmlChangeTracking xmlChangeTracking = this.getXmlChangeTracking();
        return xmlChangeTracking != null ? xmlChangeTracking : this.buildXmlChangeTracking();
    }

    protected XmlChangeTracking buildXmlChangeTracking() {
        XmlChangeTracking xmlChangeTracking = EclipseLinkOrmFactory.eINSTANCE.createXmlChangeTracking();
        this.getXmlChangeTrackingHolder().setChangeTracking(xmlChangeTracking);
        return xmlChangeTracking;
    }

    protected void removeXmlChangeTrackingIfUnset() {
        if (this.getXmlChangeTracking().isUnset()) {
            this.removeXmlChangeTracking();
        }
    }

    protected void removeXmlChangeTracking() {
        this.getXmlChangeTrackingHolder().setChangeTracking(null);
    }

    public EclipseLinkOrmTypeMapping getParent() {
        return (EclipseLinkOrmTypeMapping)super.getParent();
    }

    protected EclipseLinkOrmTypeMapping getTypeMapping() {
        return this.getParent();
    }

    protected XmlTypeMapping getXmlTypeMapping() {
        return this.getTypeMapping().getXmlTypeMapping();
    }

    protected XmlChangeTrackingHolder getXmlChangeTrackingHolder() {
        return (XmlChangeTrackingHolder)this.getXmlTypeMapping();
    }

    protected EclipseLinkJavaTypeMapping getJavaTypeMappingForDefaults() {
        return this.getTypeMapping().getJavaTypeMappingForDefaults();
    }

    protected EclipseLinkChangeTracking getJavaChangeTrackingForDefaults() {
        EclipseLinkJavaTypeMapping javaTypeMapping = this.getJavaTypeMappingForDefaults();
        return javaTypeMapping == null ? null : javaTypeMapping.getChangeTracking();
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlValidationTextRange();
        return textRange != null ? textRange : this.getTypeMapping().getValidationTextRange();
    }

    protected TextRange getXmlValidationTextRange() {
        XmlChangeTracking xmlChangeTracking = this.getXmlChangeTracking();
        return xmlChangeTracking == null ? null : xmlChangeTracking.getValidationTextRange();
    }
}

