/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source.SourceEclipseLinkTimeOfDayAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.CacheCoordinationType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.CacheIsolationType2_2;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.CacheType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkCacheAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkTimeOfDayAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceEclipseLinkCacheAnnotation
extends SourceAnnotation
implements EclipseLinkCacheAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Cache");
    private static final DeclarationAnnotationElementAdapter<String> TYPE_ADAPTER = SourceEclipseLinkCacheAnnotation.buildTypeAdapter();
    private final AnnotationElementAdapter<String> typeAdapter;
    private CacheType type;
    private TextRange typeTextRange;
    private static final DeclarationAnnotationElementAdapter<Integer> SIZE_ADAPTER = SourceEclipseLinkCacheAnnotation.buildSizeAdapter();
    private final AnnotationElementAdapter<Integer> sizeAdapter;
    private Integer size;
    private TextRange sizeTextRange;
    private static final DeclarationAnnotationElementAdapter<Boolean> SHARED_ADAPTER = SourceEclipseLinkCacheAnnotation.buildSharedAdapter();
    private final AnnotationElementAdapter<Boolean> sharedAdapter;
    private Boolean shared;
    private TextRange sharedTextRange;
    private static final DeclarationAnnotationElementAdapter<Boolean> ALWAYS_REFRESH_ADAPTER = SourceEclipseLinkCacheAnnotation.buildAlwaysRefreshAdapter();
    private final AnnotationElementAdapter<Boolean> alwaysRefreshAdapter;
    private Boolean alwaysRefresh;
    private TextRange alwaysRefreshTextRange;
    private static final DeclarationAnnotationElementAdapter<Boolean> REFRESH_ONLY_IF_NEWER_ADAPTER = SourceEclipseLinkCacheAnnotation.buildRefreshOnlyIfNewerAdapter();
    private final AnnotationElementAdapter<Boolean> refreshOnlyIfNewerAdapter;
    private Boolean refreshOnlyIfNewer;
    private TextRange refreshOnlyIfNewerTextRange;
    private static final DeclarationAnnotationElementAdapter<Boolean> DISABLE_HITS_ADAPTER = SourceEclipseLinkCacheAnnotation.buildDisableHitsAdapter();
    private final AnnotationElementAdapter<Boolean> disableHitsAdapter;
    private Boolean disableHits;
    private TextRange disableHitsTextRange;
    private static final DeclarationAnnotationElementAdapter<String> COORDINATION_TYPE_ADAPTER = SourceEclipseLinkCacheAnnotation.buildCoordinationTypeAdapter();
    private final AnnotationElementAdapter<String> coordinationTypeAdapter;
    private CacheCoordinationType coordinationType;
    private TextRange coordinationTypeTextRange;
    private static final DeclarationAnnotationElementAdapter<Integer> EXPIRY_ADAPTER = SourceEclipseLinkCacheAnnotation.buildExpiryAdapter();
    private final AnnotationElementAdapter<Integer> expiryAdapter;
    private Integer expiry;
    private TextRange expiryTextRange;
    private static final NestedDeclarationAnnotationAdapter EXPIRY_TIME_OF_DAY_ADAPTER = SourceEclipseLinkCacheAnnotation.buildExpiryTimeOfDayAdapter();
    private final ElementAnnotationAdapter expiryTimeOfDayAdapter;
    private EclipseLinkTimeOfDayAnnotation expiryTimeOfDay;
    private TextRange expiryTimeOfDayTextRange;
    private static final DeclarationAnnotationElementAdapter<String> ISOLATION_ADAPTER = SourceEclipseLinkCacheAnnotation.buildIsolationAdapter();
    private final AnnotationElementAdapter<String> isolationAdapter;
    private CacheIsolationType2_2 isolation;
    private TextRange isolationTextRange;

    public SourceEclipseLinkCacheAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super((JavaResourceNode)parent, element, DECLARATION_ANNOTATION_ADAPTER);
        this.typeAdapter = new AnnotatedElementAnnotationElementAdapter(element, TYPE_ADAPTER);
        this.sizeAdapter = new AnnotatedElementAnnotationElementAdapter(element, SIZE_ADAPTER);
        this.sharedAdapter = new AnnotatedElementAnnotationElementAdapter(element, SHARED_ADAPTER);
        this.alwaysRefreshAdapter = new AnnotatedElementAnnotationElementAdapter(element, ALWAYS_REFRESH_ADAPTER);
        this.refreshOnlyIfNewerAdapter = new AnnotatedElementAnnotationElementAdapter(element, REFRESH_ONLY_IF_NEWER_ADAPTER);
        this.disableHitsAdapter = new AnnotatedElementAnnotationElementAdapter(element, DISABLE_HITS_ADAPTER);
        this.coordinationTypeAdapter = new AnnotatedElementAnnotationElementAdapter(element, COORDINATION_TYPE_ADAPTER);
        this.expiryAdapter = new AnnotatedElementAnnotationElementAdapter(element, EXPIRY_ADAPTER);
        this.expiryTimeOfDayAdapter = new ElementAnnotationAdapter(element, (DeclarationAnnotationAdapter)EXPIRY_TIME_OF_DAY_ADAPTER);
        this.isolationAdapter = new AnnotatedElementAnnotationElementAdapter(element, ISOLATION_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Cache";
    }

    public void initialize(CompilationUnit astRoot) {
        this.type = this.buildType(astRoot);
        this.typeTextRange = this.buildTypeTextRange(astRoot);
        this.size = this.buildSize(astRoot);
        this.sizeTextRange = this.buildSizeTextRange(astRoot);
        this.shared = this.buildShared(astRoot);
        this.sharedTextRange = this.buildSharedTextRange(astRoot);
        this.alwaysRefresh = this.buildAlwaysRefresh(astRoot);
        this.alwaysRefreshTextRange = this.buildAlwaysRefreshTextRange(astRoot);
        this.refreshOnlyIfNewer = this.buildRefreshOnlyIfNewer(astRoot);
        this.refreshOnlyIfNewerTextRange = this.buildRefreshOnlyIfNewerTextRange(astRoot);
        this.disableHits = this.buildDisableHits(astRoot);
        this.disableHitsTextRange = this.buildDisableHitsTextRange(astRoot);
        this.coordinationType = this.buildCoordinationType(astRoot);
        this.coordinationTypeTextRange = this.buildCoordinationTypeTextRange(astRoot);
        this.expiry = this.buildExpiry(astRoot);
        this.expiryTextRange = this.buildExpiryTextRange(astRoot);
        this.initializeExpiryTimeOfDay(astRoot);
        this.expiryTimeOfDayTextRange = this.buildExpiryTimeOfDayTextRange(astRoot);
        this.isolation = this.buildIsolation(astRoot);
        this.isolationTextRange = this.buildIsolationTextRange(astRoot);
    }

    private void initializeExpiryTimeOfDay(CompilationUnit astRoot) {
        if (this.expiryTimeOfDayAdapter.getAnnotation(astRoot) != null) {
            this.expiryTimeOfDay = this.buildExpiryTimeOfDay();
            this.expiryTimeOfDay.initialize(astRoot);
        }
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncType(this.buildType(astRoot));
        this.typeTextRange = this.buildTypeTextRange(astRoot);
        this.syncSize(this.buildSize(astRoot));
        this.sizeTextRange = this.buildSizeTextRange(astRoot);
        this.syncShared(this.buildShared(astRoot));
        this.sharedTextRange = this.buildSharedTextRange(astRoot);
        this.syncAlwaysRefresh(this.buildAlwaysRefresh(astRoot));
        this.alwaysRefreshTextRange = this.buildAlwaysRefreshTextRange(astRoot);
        this.syncRefreshOnlyIfNewer(this.buildRefreshOnlyIfNewer(astRoot));
        this.refreshOnlyIfNewerTextRange = this.buildRefreshOnlyIfNewerTextRange(astRoot);
        this.syncDisableHits(this.buildDisableHits(astRoot));
        this.disableHitsTextRange = this.buildDisableHitsTextRange(astRoot);
        this.syncCoordinationType(this.buildCoordinationType(astRoot));
        this.coordinationTypeTextRange = this.buildCoordinationTypeTextRange(astRoot);
        this.syncExpiry(this.buildExpiry(astRoot));
        this.expiryTextRange = this.buildExpiryTextRange(astRoot);
        this.syncExpiryTimeOfDay(astRoot);
        this.expiryTimeOfDayTextRange = this.buildExpiryTimeOfDayTextRange(astRoot);
        this.syncIsolation(this.buildIsolation(astRoot));
        this.isolationTextRange = this.buildIsolationTextRange(astRoot);
    }

    public boolean isUnset() {
        return super.isUnset() && this.type == null && this.size == null && this.shared == null && this.alwaysRefresh == null && this.refreshOnlyIfNewer == null && this.disableHits == null && this.coordinationType == null && this.expiry == null && this.expiryTimeOfDay == null && this.isolation == null;
    }

    public void toString(StringBuilder sb) {
        sb.append((Object)this.type);
    }

    @Override
    public CacheType getType() {
        return this.type;
    }

    @Override
    public void setType(CacheType type) {
        if (this.attributeValueHasChanged((Object)this.type, (Object)type)) {
            this.type = type;
            this.typeAdapter.setValue((Object)CacheType.toJavaAnnotationValue(type));
        }
    }

    private void syncType(CacheType astType) {
        CacheType old = this.type;
        this.type = astType;
        this.firePropertyChanged("type", (Object)old, (Object)astType);
    }

    private CacheType buildType(CompilationUnit astRoot) {
        return CacheType.fromJavaAnnotationValue(this.typeAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getTypeTextRange() {
        return this.typeTextRange;
    }

    private TextRange buildTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(TYPE_ADAPTER, astRoot);
    }

    @Override
    public Integer getSize() {
        return this.size;
    }

    @Override
    public void setSize(Integer size) {
        if (this.attributeValueHasChanged(this.size, size)) {
            this.size = size;
            this.sizeAdapter.setValue((Object)size);
        }
    }

    private void syncSize(Integer astSize) {
        Integer old = this.size;
        this.size = astSize;
        this.firePropertyChanged("size", old, astSize);
    }

    private Integer buildSize(CompilationUnit astRoot) {
        return (Integer)this.sizeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getSizeTextRange() {
        return this.sizeTextRange;
    }

    private TextRange buildSizeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SIZE_ADAPTER, astRoot);
    }

    @Override
    public Boolean getShared() {
        return this.shared;
    }

    @Override
    public void setShared(Boolean shared) {
        if (this.attributeValueHasChanged(this.shared, shared)) {
            this.shared = shared;
            this.sharedAdapter.setValue((Object)shared);
        }
    }

    private void syncShared(Boolean astShared) {
        Boolean old = this.shared;
        this.shared = astShared;
        this.firePropertyChanged("shared", old, astShared);
    }

    private Boolean buildShared(CompilationUnit astRoot) {
        return (Boolean)this.sharedAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getSharedTextRange() {
        return this.sharedTextRange;
    }

    private TextRange buildSharedTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SHARED_ADAPTER, astRoot);
    }

    @Override
    public Boolean getAlwaysRefresh() {
        return this.alwaysRefresh;
    }

    @Override
    public void setAlwaysRefresh(Boolean alwaysRefresh) {
        if (this.attributeValueHasChanged(this.alwaysRefresh, alwaysRefresh)) {
            this.alwaysRefresh = alwaysRefresh;
            this.alwaysRefreshAdapter.setValue((Object)alwaysRefresh);
        }
    }

    private void syncAlwaysRefresh(Boolean astAlwaysRefresh) {
        Boolean old = this.alwaysRefresh;
        this.alwaysRefresh = astAlwaysRefresh;
        this.firePropertyChanged("alwaysRefresh", old, astAlwaysRefresh);
    }

    private Boolean buildAlwaysRefresh(CompilationUnit astRoot) {
        return (Boolean)this.alwaysRefreshAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getAlwaysRefreshTextRange() {
        return this.alwaysRefreshTextRange;
    }

    private TextRange buildAlwaysRefreshTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(ALWAYS_REFRESH_ADAPTER, astRoot);
    }

    @Override
    public Boolean getRefreshOnlyIfNewer() {
        return this.refreshOnlyIfNewer;
    }

    @Override
    public void setRefreshOnlyIfNewer(Boolean refreshOnlyIfNewer) {
        if (this.attributeValueHasChanged(this.refreshOnlyIfNewer, refreshOnlyIfNewer)) {
            this.refreshOnlyIfNewer = refreshOnlyIfNewer;
            this.refreshOnlyIfNewerAdapter.setValue((Object)refreshOnlyIfNewer);
        }
    }

    private void syncRefreshOnlyIfNewer(Boolean astRefreshOnlyIfNewer) {
        Boolean old = this.refreshOnlyIfNewer;
        this.refreshOnlyIfNewer = astRefreshOnlyIfNewer;
        this.firePropertyChanged("refreshOnlyIfNewer", old, astRefreshOnlyIfNewer);
    }

    private Boolean buildRefreshOnlyIfNewer(CompilationUnit astRoot) {
        return (Boolean)this.refreshOnlyIfNewerAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getRefreshOnlyIfNewerTextRange() {
        return this.refreshOnlyIfNewerTextRange;
    }

    private TextRange buildRefreshOnlyIfNewerTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(REFRESH_ONLY_IF_NEWER_ADAPTER, astRoot);
    }

    @Override
    public Boolean getDisableHits() {
        return this.disableHits;
    }

    @Override
    public void setDisableHits(Boolean disableHits) {
        if (this.attributeValueHasChanged(this.disableHits, disableHits)) {
            this.disableHits = disableHits;
            this.disableHitsAdapter.setValue((Object)disableHits);
        }
    }

    private void syncDisableHits(Boolean astDisableHits) {
        Boolean old = this.disableHits;
        this.disableHits = astDisableHits;
        this.firePropertyChanged("disableHits", old, astDisableHits);
    }

    private Boolean buildDisableHits(CompilationUnit astRoot) {
        return (Boolean)this.disableHitsAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getDisableHitsTextRange() {
        return this.disableHitsTextRange;
    }

    private TextRange buildDisableHitsTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(DISABLE_HITS_ADAPTER, astRoot);
    }

    @Override
    public CacheCoordinationType getCoordinationType() {
        return this.coordinationType;
    }

    @Override
    public void setCoordinationType(CacheCoordinationType coordinationType) {
        if (this.attributeValueHasChanged((Object)this.coordinationType, (Object)coordinationType)) {
            this.coordinationType = coordinationType;
            this.coordinationTypeAdapter.setValue((Object)CacheCoordinationType.toJavaAnnotationValue(coordinationType));
        }
    }

    private void syncCoordinationType(CacheCoordinationType astCoordinationType) {
        CacheCoordinationType old = this.coordinationType;
        this.coordinationType = astCoordinationType;
        this.firePropertyChanged("type", (Object)old, (Object)astCoordinationType);
    }

    private CacheCoordinationType buildCoordinationType(CompilationUnit astRoot) {
        return CacheCoordinationType.fromJavaAnnotationValue(this.coordinationTypeAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getCoordinationTypeTextRange() {
        return this.coordinationTypeTextRange;
    }

    private TextRange buildCoordinationTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(COORDINATION_TYPE_ADAPTER, astRoot);
    }

    @Override
    public Integer getExpiry() {
        return this.expiry;
    }

    @Override
    public void setExpiry(Integer expiry) {
        if (this.attributeValueHasChanged(this.expiry, expiry)) {
            this.expiry = expiry;
            this.expiryAdapter.setValue((Object)expiry);
        }
    }

    private void syncExpiry(Integer astExpiry) {
        Integer old = this.expiry;
        this.expiry = astExpiry;
        this.firePropertyChanged("expiry", old, astExpiry);
    }

    private Integer buildExpiry(CompilationUnit astRoot) {
        return (Integer)this.expiryAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getExpiryTextRange() {
        return this.expiryTextRange;
    }

    private TextRange buildExpiryTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(EXPIRY_ADAPTER, astRoot);
    }

    @Override
    public EclipseLinkTimeOfDayAnnotation getExpiryTimeOfDay() {
        return this.expiryTimeOfDay;
    }

    @Override
    public EclipseLinkTimeOfDayAnnotation addExpiryTimeOfDay() {
        if (this.expiryTimeOfDay != null) {
            throw new IllegalStateException("'expiryTimeOfDay' element already exists: " + this.expiryTimeOfDay);
        }
        this.expiryTimeOfDay = this.buildExpiryTimeOfDay();
        this.expiryTimeOfDay.newAnnotation();
        return this.expiryTimeOfDay;
    }

    @Override
    public void removeExpiryTimeOfDay() {
        if (this.expiryTimeOfDay == null) {
            throw new IllegalStateException("'expiryTimeOfDay' element does not exist");
        }
        EclipseLinkTimeOfDayAnnotation old = this.expiryTimeOfDay;
        this.expiryTimeOfDay = null;
        old.removeAnnotation();
    }

    private EclipseLinkTimeOfDayAnnotation buildExpiryTimeOfDay() {
        return new SourceEclipseLinkTimeOfDayAnnotation((JavaResourceNode)this, this.annotatedElement, (DeclarationAnnotationAdapter)EXPIRY_TIME_OF_DAY_ADAPTER);
    }

    private void syncExpiryTimeOfDay(CompilationUnit astRoot) {
        if (this.expiryTimeOfDayAdapter.getAnnotation(astRoot) == null) {
            this.syncExpiryTimeOfDay_(null);
        } else if (this.expiryTimeOfDay == null) {
            EclipseLinkTimeOfDayAnnotation tod = this.buildExpiryTimeOfDay();
            tod.initialize(astRoot);
            this.syncExpiryTimeOfDay_(tod);
        } else {
            this.expiryTimeOfDay.synchronizeWith(astRoot);
        }
    }

    private void syncExpiryTimeOfDay_(EclipseLinkTimeOfDayAnnotation astExpiryTimeOfDay) {
        EclipseLinkTimeOfDayAnnotation old = this.expiryTimeOfDay;
        this.expiryTimeOfDay = astExpiryTimeOfDay;
        this.firePropertyChanged("expiryTimeOfDay", old, astExpiryTimeOfDay);
    }

    @Override
    public TextRange getExpiryTimeOfDayTextRange() {
        return this.expiryTimeOfDayTextRange;
    }

    private TextRange buildExpiryTimeOfDayTextRange(CompilationUnit astRoot) {
        return this.buildTextRange(this.expiryTimeOfDayAdapter.getAstNode(astRoot));
    }

    @Override
    public CacheIsolationType2_2 getIsolation() {
        return this.isolation;
    }

    @Override
    public void setIsolation(CacheIsolationType2_2 isolation) {
        if (this.attributeValueHasChanged((Object)this.isolation, (Object)isolation)) {
            this.isolation = isolation;
            this.isolationAdapter.setValue((Object)CacheIsolationType2_2.toJavaAnnotationValue(isolation));
        }
    }

    private void syncIsolation(CacheIsolationType2_2 astIsolation) {
        CacheIsolationType2_2 old = this.isolation;
        this.isolation = astIsolation;
        this.firePropertyChanged("isolation", (Object)old, (Object)astIsolation);
    }

    private CacheIsolationType2_2 buildIsolation(CompilationUnit astRoot) {
        return CacheIsolationType2_2.fromJavaAnnotationValue(this.isolationAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getIsolationTextRange() {
        return this.isolationTextRange;
    }

    private TextRange buildIsolationTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(ISOLATION_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTypeAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "type");
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildSizeAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "size", NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildSharedAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "shared", BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildExpiryAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "expiry", NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildAlwaysRefreshAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "alwaysRefresh", BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildRefreshOnlyIfNewerAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "refreshOnlyIfNewer", BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildDisableHitsAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "disableHits", BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildCoordinationTypeAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "coordinationType");
    }

    private static NestedDeclarationAnnotationAdapter buildExpiryTimeOfDayAdapter() {
        return new NestedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, "expiryTimeOfDay", "org.eclipse.persistence.annotations.TimeOfDay");
    }

    private static DeclarationAnnotationElementAdapter<String> buildIsolationAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "isolation");
    }
}

