/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source.SourceEclipseLinkBaseTypeConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source.SourceEclipseLinkConversionValueAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConversionValueAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkObjectTypeConverterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceEclipseLinkObjectTypeConverterAnnotation
extends SourceEclipseLinkBaseTypeConverterAnnotation
implements EclipseLinkObjectTypeConverterAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.ObjectTypeConverter");
    private static final DeclarationAnnotationAdapter CONTAINER_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.ObjectTypeConverters");
    private final DeclarationAnnotationElementAdapter<String> defaultObjectValueDeclarationAdapter;
    private final AnnotationElementAdapter<String> defaultObjectValueAdapter;
    private String defaultObjectValue;
    private TextRange defaultObjectValueTextRange;
    private final ConversionValuesAnnotationContainer conversionValuesContainer = new ConversionValuesAnnotationContainer();

    public static SourceEclipseLinkObjectTypeConverterAnnotation buildSourceObjectTypeConverterAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, int index) {
        IndexedDeclarationAnnotationAdapter idaa = SourceEclipseLinkObjectTypeConverterAnnotation.buildObjectTypeConverterDeclarationAnnotationAdapter(index);
        IndexedAnnotationAdapter iaa = SourceEclipseLinkObjectTypeConverterAnnotation.buildObjectTypeConverterAnnotationAdapter(element, idaa);
        return new SourceEclipseLinkObjectTypeConverterAnnotation(parent, element, idaa, iaa);
    }

    private SourceEclipseLinkObjectTypeConverterAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter daa, IndexedAnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
        this.defaultObjectValueDeclarationAdapter = this.buildDefaultObjectValueAdapter();
        this.defaultObjectValueAdapter = new AnnotatedElementAnnotationElementAdapter(element, this.defaultObjectValueDeclarationAdapter);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.ObjectTypeConverter";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.defaultObjectValue = this.buildDefaultObjectValue(astRoot);
        this.defaultObjectValueTextRange = this.buildDefaultObjectValueTextRange(astRoot);
        this.conversionValuesContainer.initializeFromContainerAnnotation(this.getAstAnnotation(astRoot));
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncDefaultObjectValue(this.buildDefaultObjectValue(astRoot));
        this.defaultObjectValueTextRange = this.buildDefaultObjectValueTextRange(astRoot);
        this.conversionValuesContainer.synchronize(this.getAstAnnotation(astRoot));
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.defaultObjectValue == null && this.conversionValuesContainer.isEmpty();
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    String getDataTypeElementName() {
        return "dataType";
    }

    @Override
    String getObjectTypeElementName() {
        return "objectType";
    }

    @Override
    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    @Override
    public void setDefaultObjectValue(String defaultObjectValue) {
        if (this.attributeValueHasChanged(this.defaultObjectValue, defaultObjectValue)) {
            this.defaultObjectValue = defaultObjectValue;
            this.defaultObjectValueAdapter.setValue((Object)defaultObjectValue);
        }
    }

    private void syncDefaultObjectValue(String astDefaultObjectValue) {
        String old = this.defaultObjectValue;
        this.defaultObjectValue = astDefaultObjectValue;
        this.firePropertyChanged("defaultObjectValue", old, astDefaultObjectValue);
    }

    private String buildDefaultObjectValue(CompilationUnit astRoot) {
        return (String)this.defaultObjectValueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getDefaultObjectValueTextRange() {
        return this.defaultObjectValueTextRange;
    }

    private TextRange buildDefaultObjectValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.defaultObjectValueDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildDefaultObjectValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(this.daa, "defaultObjectValue", StringExpressionConverter.instance());
    }

    @Override
    public ListIterable<EclipseLinkConversionValueAnnotation> getConversionValues() {
        return this.conversionValuesContainer.getNestedAnnotations();
    }

    @Override
    public int getConversionValuesSize() {
        return this.conversionValuesContainer.getNestedAnnotationsSize();
    }

    @Override
    public EclipseLinkConversionValueAnnotation conversionValueAt(int index) {
        return (EclipseLinkConversionValueAnnotation)this.conversionValuesContainer.getNestedAnnotation(index);
    }

    @Override
    public EclipseLinkConversionValueAnnotation addConversionValue(int index) {
        return (EclipseLinkConversionValueAnnotation)this.conversionValuesContainer.addNestedAnnotation(index);
    }

    @Override
    public void moveConversionValue(int targetIndex, int sourceIndex) {
        this.conversionValuesContainer.moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeConversionValue(int index) {
        this.conversionValuesContainer.removeNestedAnnotation(index);
    }

    protected EclipseLinkConversionValueAnnotation buildConversionValue(int index) {
        return SourceEclipseLinkConversionValueAnnotation.buildNestedSourceConversionValueAnnotation((JavaResourceNode)this, this.annotatedElement, this.buildConversionValueIndexedDeclarationAnnotationAdapter(index));
    }

    private IndexedDeclarationAnnotationAdapter buildConversionValueIndexedDeclarationAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(this.daa, "conversionValues", index, "org.eclipse.persistence.annotations.ConversionValue");
    }

    private static IndexedAnnotationAdapter buildObjectTypeConverterAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new ElementIndexedAnnotationAdapter(annotatedElement, idaa);
    }

    private static IndexedDeclarationAnnotationAdapter buildObjectTypeConverterDeclarationAnnotationAdapter(int index) {
        CombinationIndexedDeclarationAnnotationAdapter idaa = new CombinationIndexedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, CONTAINER_DECLARATION_ANNOTATION_ADAPTER, index, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        return idaa;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConversionValuesAnnotationContainer
    extends SourceNode.AnnotationContainer<EclipseLinkConversionValueAnnotation> {
        ConversionValuesAnnotationContainer() {
            super((SourceNode)SourceEclipseLinkObjectTypeConverterAnnotation.this);
        }

        protected String getNestedAnnotationsListName() {
            return "conversionValues";
        }

        protected String getElementName() {
            return "conversionValues";
        }

        protected String getNestedAnnotationName() {
            return "org.eclipse.persistence.annotations.ConversionValue";
        }

        protected EclipseLinkConversionValueAnnotation buildNestedAnnotation(int index) {
            return SourceEclipseLinkObjectTypeConverterAnnotation.this.buildConversionValue(index);
        }
    }
}

