/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.resource.orm;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.translators.SimpleTranslator;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.EclipseLinkOrmPackage;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlNamedConverter;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.common.internal.emf.resource.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlObjectTypeConverter
extends XmlNamedConverter {
    protected static final String DATA_TYPE_EDEFAULT = null;
    protected String dataType = DATA_TYPE_EDEFAULT;
    protected static final String OBJECT_TYPE_EDEFAULT = null;
    protected String objectType = OBJECT_TYPE_EDEFAULT;
    protected EList<XmlConversionValue> conversionValues;
    protected static final String DEFAULT_OBJECT_VALUE_EDEFAULT = null;
    protected String defaultObjectValue = DEFAULT_OBJECT_VALUE_EDEFAULT;

    protected XmlObjectTypeConverter() {
    }

    @Override
    protected EClass eStaticClass() {
        return EclipseLinkOrmPackage.Literals.XML_OBJECT_TYPE_CONVERTER;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String newDataType) {
        String oldDataType = this.dataType;
        this.dataType = newDataType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldDataType, (Object)this.dataType));
        }
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String newObjectType) {
        String oldObjectType = this.objectType;
        this.objectType = newObjectType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldObjectType, (Object)this.objectType));
        }
    }

    public EList<XmlConversionValue> getConversionValues() {
        if (this.conversionValues == null) {
            this.conversionValues = new EObjectContainmentEList(XmlConversionValue.class, (InternalEObject)this, 3);
        }
        return this.conversionValues;
    }

    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    public void setDefaultObjectValue(String newDefaultObjectValue) {
        String oldDefaultObjectValue = this.defaultObjectValue;
        this.defaultObjectValue = newDefaultObjectValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldDefaultObjectValue, (Object)this.defaultObjectValue));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getConversionValues()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getDataType();
            }
            case 2: {
                return this.getObjectType();
            }
            case 3: {
                return this.getConversionValues();
            }
            case 4: {
                return this.getDefaultObjectValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setDataType((String)newValue);
                return;
            }
            case 2: {
                this.setObjectType((String)newValue);
                return;
            }
            case 3: {
                this.getConversionValues().clear();
                this.getConversionValues().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setDefaultObjectValue((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setDataType(DATA_TYPE_EDEFAULT);
                return;
            }
            case 2: {
                this.setObjectType(OBJECT_TYPE_EDEFAULT);
                return;
            }
            case 3: {
                this.getConversionValues().clear();
                return;
            }
            case 4: {
                this.setDefaultObjectValue(DEFAULT_OBJECT_VALUE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return DATA_TYPE_EDEFAULT == null ? this.dataType != null : !DATA_TYPE_EDEFAULT.equals(this.dataType);
            }
            case 2: {
                return OBJECT_TYPE_EDEFAULT == null ? this.objectType != null : !OBJECT_TYPE_EDEFAULT.equals(this.objectType);
            }
            case 3: {
                return this.conversionValues != null && !this.conversionValues.isEmpty();
            }
            case 4: {
                return DEFAULT_OBJECT_VALUE_EDEFAULT == null ? this.defaultObjectValue != null : !DEFAULT_OBJECT_VALUE_EDEFAULT.equals(this.defaultObjectValue);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (dataType: ");
        result.append(this.dataType);
        result.append(", objectType: ");
        result.append(this.objectType);
        result.append(", defaultObjectValue: ");
        result.append(this.defaultObjectValue);
        result.append(')');
        return result.toString();
    }

    public static Translator buildTranslator(String elementName, EStructuralFeature structuralFeature) {
        return new SimpleTranslator(elementName, structuralFeature, XmlObjectTypeConverter.buildTranslatorChildren());
    }

    private static Translator[] buildTranslatorChildren() {
        return new Translator[]{XmlObjectTypeConverter.buildConversionValueTranslator(), XmlObjectTypeConverter.buildDefaultObjectValueTranslator(), XmlObjectTypeConverter.buildNameTranslator(), XmlObjectTypeConverter.buildDataTypeTranslator(), XmlObjectTypeConverter.buildObjectTypeTranslator()};
    }

    protected static Translator buildConversionValueTranslator() {
        return XmlConversionValue.buildTranslator("conversion-value", (EStructuralFeature)EclipseLinkOrmPackage.eINSTANCE.getXmlObjectTypeConverter_ConversionValues());
    }

    protected static Translator buildDefaultObjectValueTranslator() {
        return new Translator("default-object-value", (EStructuralFeature)EclipseLinkOrmPackage.eINSTANCE.getXmlObjectTypeConverter_DefaultObjectValue());
    }

    protected static Translator buildDataTypeTranslator() {
        return new Translator("data-type", (EStructuralFeature)EclipseLinkOrmPackage.eINSTANCE.getXmlObjectTypeConverter_DataType(), 1);
    }

    protected static Translator buildObjectTypeTranslator() {
        return new Translator("object-type", (EStructuralFeature)EclipseLinkOrmPackage.eINSTANCE.getXmlObjectTypeConverter_ObjectType(), 1);
    }

    public ReplaceEdit createRenameDataTypeEdit(IType originalType, String newName) {
        String originalName = originalType.getTypeQualifiedName();
        int nameIndex = this.dataType.lastIndexOf(originalName);
        int offset = this.getAttributeNode("data-type").getValueRegionStartOffset() + 1;
        return new ReplaceEdit(offset + nameIndex, originalName.length(), newName);
    }

    public ReplaceEdit createRenameDataTypePackageEdit(String newPackageName) {
        int packageLength = this.dataType.lastIndexOf(46);
        if (newPackageName == "") {
            ++packageLength;
        }
        if (packageLength == -1) {
            packageLength = 0;
            newPackageName = String.valueOf(newPackageName) + '.';
        }
        int offset = this.getAttributeNode("data-type").getValueRegionStartOffset() + 1;
        return new ReplaceEdit(offset, packageLength, newPackageName);
    }

    public ReplaceEdit createRenameObjectTypeEdit(IType originalType, String newName) {
        String originalName = originalType.getTypeQualifiedName();
        int nameIndex = this.objectType.lastIndexOf(originalName);
        int offset = this.getAttributeNode("object-type").getValueRegionStartOffset() + 1;
        return new ReplaceEdit(offset + nameIndex, originalName.length(), newName);
    }

    public ReplaceEdit createRenameObjectTypePackageEdit(String newPackageName) {
        int packageLength = this.objectType.lastIndexOf(46);
        if (newPackageName == "") {
            ++packageLength;
        }
        if (packageLength == -1) {
            packageLength = 0;
            newPackageName = String.valueOf(newPackageName) + '.';
        }
        int offset = this.getAttributeNode("object-type").getValueRegionStartOffset() + 1;
        return new ReplaceEdit(offset, packageLength, newPackageName);
    }
}

