/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.caching;

import java.util.ArrayList;
import org.eclipse.jpt.common.ui.internal.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.Caching;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.CachingEntity;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedCacheComposite
extends Pane<CachingEntity> {
    private TriStateCheckBox sharedCacheCheckBox;

    public SharedCacheComposite(Pane<CachingEntity> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    private PropertyValueModel<Caching> buildCachingHolder() {
        return new TransformationPropertyValueModel<CachingEntity, Caching>(this.getSubjectHolder()){

            protected Caching transform_(CachingEntity value) {
                return value.getParent();
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultAndNonDefaultSharedCacheHolder() {
        return new ListPropertyValueModelAdapter<Boolean>(this.buildDefaultAndNonDefaultSharedCacheListHolder()){

            protected Boolean buildValue() {
                if (this.listModel.size() == 1) {
                    return (Boolean)this.listModel.listIterator().next();
                }
                return null;
            }
        };
    }

    private ListValueModel<Boolean> buildDefaultAndNonDefaultSharedCacheListHolder() {
        ArrayList<ListValueModel<Boolean>> holders = new ArrayList<ListValueModel<Boolean>>(2);
        holders.add(this.buildSharedCacheListHolder());
        holders.add(this.buildDefaultSharedCacheListHolder());
        return new CompositeListValueModel(holders);
    }

    private PropertyValueModel<Boolean> buildDefaultSharedCacheHolder() {
        return new PropertyAspectAdapter<Caching, Boolean>(this.buildCachingHolder(), new String[]{"sharedCacheDefault"}){

            protected Boolean buildValue_() {
                Boolean value = ((Caching)this.subject).getSharedCacheDefault();
                if (value == null) {
                    value = ((Caching)this.subject).getDefaultSharedCacheDefault();
                }
                return value;
            }
        };
    }

    private ListValueModel<Boolean> buildDefaultSharedCacheListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultSharedCacheHolder());
    }

    private ModifiablePropertyValueModel<Boolean> buildSharedCacheHolder() {
        return new PropertyAspectAdapter<CachingEntity, Boolean>(this.getSubjectHolder(), new String[]{"sharedCache"}){

            protected Boolean buildValue_() {
                return SharedCacheComposite.this.getSubjectParent().getSharedCacheOf(SharedCacheComposite.this.getSubjectName());
            }

            protected void setValue_(Boolean value) {
                SharedCacheComposite.this.getSubjectParent().setSharedCacheOf(SharedCacheComposite.this.getSubjectName(), value);
            }
        };
    }

    private String getSubjectName() {
        return ((CachingEntity)this.getSubjectHolder().getValue()).getName();
    }

    private Caching getSubjectParent() {
        return ((CachingEntity)this.getSubjectHolder().getValue()).getParent();
    }

    private ListValueModel<Boolean> buildSharedCacheListHolder() {
        return new PropertyListValueModelAdapter(this.buildSharedCacheHolder());
    }

    private PropertyValueModel<String> buildSharedCacheStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultAndNonDefaultSharedCacheHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.Boolean_True : JptCommonUiMessages.Boolean_False;
                    return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlCachingTab_defaultSharedCacheLabel, (Object)defaultStringValue);
                }
                return EclipseLinkUiMessages.PersistenceXmlCachingTab_sharedCacheLabel;
            }
        };
    }

    protected void initializeLayout(Composite container) {
        this.sharedCacheCheckBox = this.addTriStateCheckBoxWithDefault(container, EclipseLinkUiMessages.PersistenceXmlCachingTab_sharedCacheLabel, this.buildSharedCacheHolder(), this.buildSharedCacheStringHolder(), "org.eclipse.jpt.jpa.ui.persistence_caching");
    }
}

