/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jpt.common.ui.internal.utility.SynchronousUiCommandExecutor;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class SynchronizeClassesAction
implements IObjectActionDelegate {
    private IFile persistenceXmlFile;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object sel = ((StructuredSelection)selection).getFirstElement();
        this.persistenceXmlFile = this.buildPersistenceXmlFile(sel);
    }

    private IFile buildPersistenceXmlFile(Object selection) {
        if (selection instanceof IFile) {
            return (IFile)selection;
        }
        if (selection instanceof PersistenceXml) {
            return (IFile)((PersistenceXml)selection).getResource();
        }
        return null;
    }

    public void run(IAction action) {
        try {
            SyncRunnable runnable = new SyncRunnable(this.persistenceXmlFile);
            this.buildProgressMonitorDialog().run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException ex) {
            JptJpaUiPlugin.log(ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            JptJpaUiPlugin.log(ex);
        }
    }

    private ProgressMonitorDialog buildProgressMonitorDialog() {
        return new ProgressMonitorDialog(null);
    }

    static class SyncCommand
    implements Command {
        private final PersistenceUnit persistenceUnit;
        private final IProgressMonitor monitor;

        SyncCommand(PersistenceUnit persistenceUnit, IProgressMonitor monitor) {
            this.persistenceUnit = persistenceUnit;
            this.monitor = monitor;
        }

        public void execute() {
            this.persistenceUnit.synchronizeClasses(this.monitor);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.persistenceUnit);
        }
    }

    static class SyncRunnable
    implements IRunnableWithProgress {
        private IFile persistenceXmlFile;

        SyncRunnable(IFile persistenceXmlFile) {
            this.persistenceXmlFile = persistenceXmlFile;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.run_(monitor);
            }
            catch (CoreException ex) {
                throw new InvocationTargetException(ex);
            }
        }

        private void run_(IProgressMonitor monitor) throws CoreException {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            ISchedulingRule rule = workspace.getRuleFactory().modifyRule((IResource)this.persistenceXmlFile.getProject());
            workspace.run((IWorkspaceRunnable)new SyncWorkspaceRunnable(this.persistenceXmlFile), rule, 1, monitor);
        }
    }

    static class SyncWorkspaceRunnable
    implements IWorkspaceRunnable {
        private IFile persistenceXmlFile;

        SyncWorkspaceRunnable(IFile persistenceXmlFile) {
            this.persistenceXmlFile = persistenceXmlFile;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            PersistenceUnit persistenceUnit;
            if (monitor.isCanceled()) {
                return;
            }
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)JptUiMessages.SynchronizingClasses_TaskName, (int)20);
            JpaProject jpaProject = this.getJpaProject();
            if (jpaProject == null) {
                return;
            }
            JpaXmlResource resource = jpaProject.getPersistenceXmlResource();
            if (resource == null) {
                return;
            }
            if (sm.isCanceled()) {
                return;
            }
            sm.worked(1);
            PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
            if (persistenceXml == null) {
                return;
            }
            Persistence persistence = persistenceXml.getPersistence();
            if (persistence == null) {
                return;
            }
            PersistenceUnit persistenceUnit2 = persistenceUnit = persistence.getPersistenceUnitsSize() == 0 ? persistence.addPersistenceUnit() : persistence.getPersistenceUnit(0);
            if (sm.isCanceled()) {
                return;
            }
            sm.worked(1);
            SyncCommand syncCommand = new SyncCommand(persistenceUnit, (IProgressMonitor)sm.newChild(17));
            try {
                this.getJpaProjectManager().execute((Command)syncCommand, SynchronousUiCommandExecutor.instance());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ex);
            }
            resource.save();
            sm.worked(1);
        }

        private JpaProjectManager getJpaProjectManager() {
            return (JpaProjectManager)this.getWorkspace().getAdapter(JpaProjectManager.class);
        }

        private IProject getProject() {
            return this.persistenceXmlFile.getProject();
        }

        private JpaProject getJpaProject() {
            return (JpaProject)this.getProject().getAdapter(JpaProject.class);
        }

        private IWorkspace getWorkspace() {
            return this.persistenceXmlFile.getWorkspace();
        }
    }
}

