/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.navigator;

import org.eclipse.jpt.common.ui.internal.jface.AbstractItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemLabelProvider;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.TransformerAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.JpaRootContextNode;
import org.eclipse.jpt.jpa.ui.JpaRootContextNodeModel;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.JptUiIcons;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootContextNodeModelItemLabelProvider
extends AbstractItemExtendedLabelProvider<JpaRootContextNodeModel> {
    protected static final Transformer<JpaRootContextNode, Image> IMAGE_TRANSFORMER = new ImageTransformer();
    protected static final Transformer<JpaRootContextNode, String> TEXT_TRANSFORMER = new TextTransformer();
    protected static final Transformer<JpaRootContextNode, String> DESCRIPTION_TRANSFORMER = new DescriptionTransformer();

    public RootContextNodeModelItemLabelProvider(JpaRootContextNodeModel rootContextNodeModel, ItemLabelProvider.Manager manager) {
        super((Object)rootContextNodeModel, manager);
    }

    protected PropertyValueModel<Image> buildImageModel() {
        return new TransformationPropertyValueModel((PropertyValueModel)this.item, IMAGE_TRANSFORMER);
    }

    protected PropertyValueModel<String> buildTextModel() {
        return new TransformationPropertyValueModel((PropertyValueModel)this.item, TEXT_TRANSFORMER);
    }

    protected PropertyValueModel<String> buildDescriptionModel() {
        return new TransformationPropertyValueModel((PropertyValueModel)this.item, DESCRIPTION_TRANSFORMER);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DescriptionTransformer
    extends TransformerAdapter<JpaRootContextNode, String> {
        protected DescriptionTransformer() {
        }

        public String transform(JpaRootContextNode root) {
            if (root == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(JptUiMessages.JpaContent_label);
            sb.append(" - ");
            sb.append(root.getResource().getFullPath().makeRelative());
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ImageTransformer
    extends TransformerAdapter<JpaRootContextNode, Image> {
        protected ImageTransformer() {
        }

        public Image transform(JpaRootContextNode root) {
            return root != null ? JptJpaUiPlugin.getImage("full/obj16/jpa-content") : JptUiIcons.ghost("full/obj16/jpa-content");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TextTransformer
    extends TransformerAdapter<JpaRootContextNode, String> {
        protected TextTransformer() {
        }

        public String transform(JpaRootContextNode root) {
            String text = JptUiMessages.JpaContent_label;
            return root != null ? text : "[" + text + "]";
        }
    }
}

