/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.SizePosition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class EntitiesCoordinatesXML {
    private Document document;
    private Element rootElement;
    private String projectName;
    public static final String XML_ELEMENT_POSITION = "\n\t\t";

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EntitiesCoordinatesXML(String projectName) {
        this.projectName = projectName;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        InputStream is = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            is = (InputStream)this.findXMLFile(true);
            this.document = documentBuilder.parse(is);
            this.rootElement = this.document.getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            JPADiagramEditorPlugin.logError(JPAEditorMessages.EntitiesCoordinatesXML_CannotParseFileErrorMSG, e);
            if (is == null) return;
            try {
                is.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (SAXException e) {
            JPADiagramEditorPlugin.logError(JPAEditorMessages.EntitiesCoordinatesXML_CannotParseFileErrorMSG, e);
            if (is == null) return;
            try {
                is.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException e) {
            JPADiagramEditorPlugin.logError(JPAEditorMessages.EntitiesCoordinatesXML_CannotReadFileErrorMSG, e);
            if (is == null) return;
            {
                catch (Throwable throwable) {
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                is.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private Closeable findXMLFile(boolean inputStream) throws FileNotFoundException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = project.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IFile existingXMLFile;
                IResource res = iResourceArray[n2];
                if (res instanceof IFolder && (existingXMLFile = ((IFolder)res).getFile(String.valueOf(this.projectName) + "." + "xml")) != null && existingXMLFile.exists()) {
                    return inputStream ? new FileInputStream(new File(existingXMLFile.getLocationURI())) : new FileOutputStream(new File(existingXMLFile.getLocationURI()));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            JPADiagramEditorPlugin.logError(JPAEditorMessages.EntitiesCoordinatesXML_CannotObtainProjectErrorMSG, e);
        }
        IFile existingXMLFile = project.getFile(ModelIntegrationUtil.getDiagramsXMLFolderPath(project).append(this.projectName).addFileExtension("xml"));
        return inputStream ? new FileInputStream(new File(existingXMLFile.getLocationURI())) : new FileOutputStream(new File(existingXMLFile.getLocationURI()));
    }

    public synchronized void store() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        Diagram diagram = ModelIntegrationUtil.getDiagramByProject(project);
        EList picts = diagram.getChildren();
        Iterator it = picts.iterator();
        this.document.removeChild(this.rootElement);
        this.rootElement = this.document.createElement("entities");
        this.document.appendChild(this.rootElement);
        while (it.hasNext()) {
            Shape pict = (Shape)it.next();
            String name = Graphiti.getPeService().getPropertyValue((PropertyContainer)pict, JPAEditorConstants.PROP_ENTITY_CLASS_NAME);
            RoundedRectangle rect = (RoundedRectangle)pict.getGraphicsAlgorithm();
            boolean isPrimaryCollapsed = JPAEditorConstants.TRUE_STRING.equals(Graphiti.getPeService().getPropertyValue((PropertyContainer)pict, "primary collapsed"));
            boolean isRelationCollapsed = JPAEditorConstants.TRUE_STRING.equals(Graphiti.getPeService().getPropertyValue((PropertyContainer)pict, "relation collapsed"));
            boolean isBasicCollapsed = JPAEditorConstants.TRUE_STRING.equals(Graphiti.getPeService().getPropertyValue((PropertyContainer)pict, "basic collapsed"));
            Element entity = this.createEntityElementTag(this.document, this.rootElement, "entity", XML_ELEMENT_POSITION);
            Text nameText = this.document.createTextNode(name);
            Element entityName = this.document.createElement("entity-name");
            this.createChildElementTag(this.document, nameText, entityName, entity, XML_ELEMENT_POSITION);
            Text width = this.document.createTextNode(String.valueOf(rect.getWidth()));
            Element entityWidth = this.document.createElement("entity-width");
            this.createChildElementTag(this.document, width, entityWidth, entity, XML_ELEMENT_POSITION);
            Text height = this.document.createTextNode(String.valueOf(rect.getHeight()));
            Element entityHeight = this.document.createElement("entity-height");
            this.createChildElementTag(this.document, height, entityHeight, entity, XML_ELEMENT_POSITION);
            Text xCoordinate = this.document.createTextNode(String.valueOf(rect.getX()));
            Element entityXCoordinate = this.document.createElement("entity-X-Coordinate");
            this.createChildElementTag(this.document, xCoordinate, entityXCoordinate, entity, XML_ELEMENT_POSITION);
            Text yCoordinate = this.document.createTextNode(String.valueOf(rect.getY()));
            Element entityYCoordinate = this.document.createElement("entity-Y-Coordinate");
            this.createChildElementTag(this.document, yCoordinate, entityYCoordinate, entity, XML_ELEMENT_POSITION);
            Text primaryCollapsed = this.document.createTextNode(String.valueOf(isPrimaryCollapsed));
            Element entityPrimaryCollapsed = this.document.createElement("primary-collapsed");
            this.createChildElementTag(this.document, primaryCollapsed, entityPrimaryCollapsed, entity, XML_ELEMENT_POSITION);
            Text relationCollapsed = this.document.createTextNode(String.valueOf(isRelationCollapsed));
            Element entityRelationCollapsed = this.document.createElement("relation-collapsed");
            this.createChildElementTag(this.document, relationCollapsed, entityRelationCollapsed, entity, XML_ELEMENT_POSITION);
            Text basicCollapsed = this.document.createTextNode(String.valueOf(isBasicCollapsed));
            Element entityBasicCollapsed = this.document.createElement("basic-collapsed");
            this.createChildElementTag(this.document, basicCollapsed, entityBasicCollapsed, entity, "\n\t");
            this.rootElement.appendChild(this.document.createTextNode("\n"));
        }
        ModelIntegrationUtil.setXmiExists(false);
    }

    public synchronized void load(Hashtable<String, SizePosition> marks) {
        if (this.rootElement.getChildNodes().getLength() <= 1 && ModelIntegrationUtil.xmiExists()) {
            this.store();
            this.save();
        }
        NodeList nodeList = this.rootElement.getElementsByTagName("entity");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element node = (Element)nodeList.item(i);
            String entityName = node.getElementsByTagName("entity-name").item(0).getTextContent();
            int width = Integer.parseInt(node.getElementsByTagName("entity-width").item(0).getTextContent());
            int height = Integer.parseInt(node.getElementsByTagName("entity-height").item(0).getTextContent());
            int xCoordinate = Integer.parseInt(node.getElementsByTagName("entity-X-Coordinate").item(0).getTextContent());
            int yCoordinate = Integer.parseInt(node.getElementsByTagName("entity-Y-Coordinate").item(0).getTextContent());
            boolean isPrimaryCollapsed = Boolean.parseBoolean(node.getElementsByTagName("primary-collapsed").item(0).getTextContent());
            boolean isRelationCollapsed = Boolean.parseBoolean(node.getElementsByTagName("relation-collapsed").item(0).getTextContent());
            boolean isBasicCollapsed = Boolean.parseBoolean(node.getElementsByTagName("basic-collapsed").item(0).getTextContent());
            SizePosition rectSP = new SizePosition(width, height, xCoordinate, yCoordinate);
            rectSP.primaryCollapsed = isPrimaryCollapsed;
            rectSP.relationCollapsed = isRelationCollapsed;
            rectSP.basicCollapsed = isBasicCollapsed;
            marks.put(entityName, rectSP);
            ++i;
        }
    }

    private Element createEntityElementTag(Document document, Element scheduleElement, String descr, String position) {
        Element job = document.createElement(descr);
        scheduleElement.appendChild(document.createTextNode("\n\t"));
        scheduleElement.appendChild(job);
        job.appendChild(document.createTextNode(position));
        return job;
    }

    private void createChildElementTag(Document document, Text nameText, Element nameEl, Element parentElement, String position) {
        parentElement.appendChild(nameEl);
        nameEl.appendChild(nameText);
        parentElement.appendChild(document.createTextNode(position));
    }

    public void save() {
        block11: {
            OutputStream os = null;
            try {
                try {
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    os = (OutputStream)this.findXMLFile(false);
                    transformer.transform(new DOMSource(this.document), new StreamResult(os));
                    os.flush();
                }
                catch (Exception e) {
                    JPADiagramEditorPlugin.logError(JPAEditorMessages.EntitiesCoordinatesXML_CannotCreateDOMFileErrorMSG, e);
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void close() {
        this.save();
        this.clean();
    }

    public synchronized void clean() {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            JPADiagramEditorPlugin.logError(JPAEditorMessages.EntitiesCoordinatesXML_CannotRefrfreshFile, e);
        }
        this.document = null;
        this.rootElement = null;
    }
}

