/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils11;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils12;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils20;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils21;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JSFUtilFactory {
    public JSFUtils create(IProject project) {
        JSFVersion jsfVersion = JSFVersion.valueOfProject(project);
        if (jsfVersion != null) {
            return this.create(jsfVersion, ModelProviderManager.getModelProvider((IProject)project));
        }
        return null;
    }

    public JSFUtils create(IProjectFacetVersion version, IModelProvider modelProvider) {
        JSFVersion jsfVersion = JSFVersion.valueOfFacetVersion(version);
        if (jsfVersion != null) {
            return this.create(jsfVersion, modelProvider);
        }
        return null;
    }

    public JSFUtils create(JSFVersion version, IModelProvider modelProvider) {
        switch (version) {
            case V1_0: 
            case V1_1: {
                return new JSFUtils11(modelProvider);
            }
            case V1_2: {
                return new JSFUtils12(modelProvider);
            }
            case V2_0: {
                return new JSFUtils20(modelProvider);
            }
            case V2_1: {
                return new JSFUtils21(modelProvider);
            }
        }
        throw new IllegalArgumentException("Unknown version: " + (Object)((Object)version));
    }
}

