/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.NodePO;
import org.eclipse.jubula.client.core.model.WrapperPO;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="SPEC_CONT")
public class SpecObjContPO
extends WrapperPO
implements ISpecObjContPO,
PersistenceWeaved,
PersistenceObject {
    private List<ISpecPersistable> m_specObjList;
    static final long serialVersionUID = 3089188243671355632L;

    SpecObjContPO() {
        this.m_specObjList = new ArrayList<ISpecPersistable>();
    }

    @Override
    @Transient
    public String getName() {
        return "SpecObjContPO";
    }

    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, targetEntity=NodePO.class)
    @OrderColumn(name="IDX")
    List<ISpecPersistable> getHbmSpecObjList() {
        return this.m_specObjList;
    }

    @Override
    @Transient
    public List<ISpecPersistable> getSpecObjList() {
        for (ISpecPersistable spec : this.m_specObjList) {
            spec.setParentNode(TCB_ROOT_NODE);
        }
        return Collections.unmodifiableList(this.getHbmSpecObjList());
    }

    private void setHbmSpecObjList(List<ISpecPersistable> specObjList) {
        this.m_specObjList = specObjList;
    }

    @Override
    public void addSpecObject(ISpecPersistable specObj) {
        this.getHbmSpecObjList().add(specObj);
        specObj.setParentNode(TCB_ROOT_NODE);
        specObj.setParentProjectId(this.getParentProjectId());
    }

    @Override
    public void removeSpecObject(ISpecPersistable specObj) {
        this.getHbmSpecObjList().remove(specObj);
        specObj.setParentNode(null);
    }

    @Override
    public void setParentProjectId(Long projectId) {
        super.setParentProjectId(projectId);
        for (ISpecPersistable spec : this.getSpecObjList()) {
            spec.setParentProjectId(projectId);
        }
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return super.getParentProjectId();
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new SpecObjContPO(persistenceObject);
    }

    public SpecObjContPO(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "hbmSpecObjList") {
            return this.hbmSpecObjList;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "hbmSpecObjList") {
            this.hbmSpecObjList = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }
}

