/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Selection;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.progress.OperationCanceledUtil;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICompIdentifierPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.AbstractNamePM;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.core.persistence.ParamNamePM;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.client.core.persistence.locking.LockedObjectPO;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.exception.JBFatalAbortException;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.utils.ValueListIterator;
import org.eclipse.jubula.tools.xml.businessmodell.CompSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompNamePM
extends AbstractNamePM {
    private static final int MAX_DB_EXPRESSIONS = 1000;
    private static final String COMP_NAME_TABLE_ID = "org.eclipse.jubula.client.core.model.ComponentNamePO";
    private static final String P_PAIR_LIST = "pairList";
    private static final String P_IGNORE_PAIRS = "ignoreNamePairIds";
    private static final String P_IGNORE_CAPS = "ignoreCapIds";
    private static final String P_COMP_NAME_GUID = "compNameGuid";
    private static final String P_PARENT_PROJECT_ID = "parentProjectId";
    private static final String P_NAME_SET = "nameSet";
    private static final String Q_PREEXISTING_NAMES = "select compName from ComponentNamePO compName where compName.hbmParentProjectId = :parentProjectId and compName.hbmName in :nameSet";
    private static final String Q_REUSE_TYPE_PAIRS = "select compNamePair from CompNamesPairPO as compNamePair, ComponentNamePO as secondCompName, ComponentNamePO as firstCompName where compNamePair.secondName = :compNameGuid and compNamePair.hbmParentProjectId = :parentProjectId and compNamePair.firstName = firstCompName.hbmGuid";
    private static final String SQ_REUSE_TYPE_PAIRS_IGNORE = " and not compNamePair.id in :ignoreNamePairIds";
    private static final String Q_REUSE_TYPE_ASSOCS = "select assoc from ObjectMappingAssoziationPO as assoc, CompIdentifierPO as compId, ComponentNamePO as compName join assoc.logicalNames as logicalName where logicalName = compName.hbmGuid and logicalName = :compNameGuid and assoc.technicalName = compId and compName.hbmParentProjectId = :parentProjectId";
    private static final String Q_REUSE_TYPE_CAPS = "select cap.componentType from CapPO as cap where cap.componentName = :compNameGuid and cap.hbmParentProjectId = :parentProjectId";
    private static final Object SQ_REUSE_TYPE_CAPS_IGNORE = " and not cap.id in :ignoreCapIds";
    private static final String Q_REF_COMP_NAME_GUIDS = "select compName.hbmGuid from ComponentNamePO as compName where compName.hbmReferencedGuid is not null and compName.hbmParentProjectId = :parentProjectId";
    private static final String Q_CAP_COMP_NAME_GUIDS = "select cap.componentName from CapPO as cap where cap.hbmParentProjectId = :parentProjectId";
    private static final String Q_PAIR_FIRST_COMP_NAME_GUIDS = "select pair.firstName from CompNamesPairPO as pair where pair.hbmParentProjectId = :parentProjectId";
    private static final String Q_PAIR_SECOND_COMP_NAME_GUIDS = "select pair.secondName from CompNamesPairPO as pair where pair.hbmParentProjectId = :parentProjectId";
    private static final String Q_ASSOC_COMP_NAME_GUIDS = "select logicalName from ObjectMappingAssoziationPO as assoc join assoc.logicalNames as logicalName where assoc.hbmParentProjectId = :parentProjectId";
    private static final String Q_COMP_NAME_REF_GUIDS = "select compName.hbmReferencedGuid from ComponentNamePO as compName where compName.hbmReferencedGuid is not null and compName.hbmParentProjectId = :parentProjectId";
    private static final String Q_EXEC_TCS_WITH_PAIR = "select execTc from ExecTestCasePO execTc left outer join execTc.hbmCompNamesMap as compNamesMap where compNamesMap.id in :pairList";
    private static final String P_COMP_NAME_REMOVAL_LIST = "compNameRemovalList";
    private static final String Q_DELETE_COMP_NAMES = "delete from ComponentNamePO compName where compName.hbmParentProjectId = :parentProjectId and compName.hbmGuid in :compNameRemovalList";
    private static Logger log = LoggerFactory.getLogger(ParamNamePM.class);
    private static LockedObjectPO lockObj = null;

    public static final List<IComponentNamePO> readAllCompNames(Long parentProjectId) throws PMException {
        EntityManager s = null;
        try {
            s = Persistor.instance().openSession();
            List<IComponentNamePO> list = CompNamePM.readAllCompNames(parentProjectId, s);
            return list;
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(s);
        }
    }

    private static final List<IComponentNamePO> readAllCompNames(Long parentProjectId, EntityManager s) throws PMException {
        ArrayList<IComponentNamePO> compNames = new ArrayList<IComponentNamePO>();
        try {
            Query q = s.createQuery("select compName from ComponentNamePO compName where compName.hbmParentProjectId = :parentProjId");
            q.setParameter("parentProjId", (Object)parentProjectId);
            compNames.addAll(q.getResultList());
        }
        catch (PersistenceException e) {
            OperationCanceledUtil.checkForOperationCanceled((RuntimeException)((Object)e));
            log.error(String.valueOf(Messages.CouldNotReadComponentNamesFromDBOfProjectWithID) + " " + "'" + String.valueOf(parentProjectId) + "'", (Throwable)e);
            PersistenceManager.handleDBExceptionForAnySession(null, e, s);
        }
        return compNames;
    }

    public static final List<IComponentNamePO> readAllRefCompNames(Long parentProjectId) throws PMException {
        EntityManager s = null;
        ArrayList<IComponentNamePO> compNames = new ArrayList<IComponentNamePO>();
        try {
            try {
                s = Persistor.instance().openSession();
                Query q = s.createQuery("select compName from ComponentNamePO compName where compName.hbmParentProjectId = :parentProjId and compName.hbmReferenceGuid is not null");
                q.setParameter("parentProjId", (Object)parentProjectId);
                compNames.addAll(q.getResultList());
            }
            catch (PersistenceException e) {
                OperationCanceledUtil.checkForOperationCanceled((RuntimeException)((Object)e));
                log.error(String.valueOf(Messages.CouldNotReadComponentNamesFromDBOfProjectWithID) + " " + "'" + String.valueOf(parentProjectId) + "'", (Throwable)e);
                PersistenceManager.handleDBExceptionForAnySession(null, e, s);
                Persistor.instance().dropSessionWithoutLockRelease(s);
            }
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(s);
        }
        return compNames;
    }

    public static final IComponentNamePO loadCompName(String compNameGuid, Long parentProjId) throws PMException {
        EntityManager s = null;
        IComponentNamePO compNamePO = null;
        try {
            s = Persistor.instance().openSession();
            Query q = s.createQuery("select compName from ComponentNamePO compName where compName.hbmParentProjectId = :parentProjId and compName.hbmGuid = :compNameGuid");
            q.setParameter("parentProjId", (Object)parentProjId);
            q.setParameter(P_COMP_NAME_GUID, (Object)compNameGuid);
            compNamePO = (IComponentNamePO)q.getSingleResult();
            if (compNamePO != null && compNamePO.getReferencedGuid() != null) {
                IComponentNamePO iComponentNamePO = CompNamePM.loadCompName(compNamePO.getReferencedGuid(), parentProjId);
                return iComponentNamePO;
            }
        }
        catch (NoResultException noResultException) {
        }
        catch (PersistenceException e) {
            OperationCanceledUtil.checkForOperationCanceled((RuntimeException)((Object)e));
            StringBuilder msg = new StringBuilder();
            msg.append(Messages.CouldNotReadComponentNamesFromDBOfProjectWithID);
            msg.append(" ");
            msg.append("'");
            msg.append(String.valueOf(parentProjId));
            msg.append("'");
            msg.append(" ");
            msg.append(Messages.AndGUID);
            msg.append(" ");
            msg.append("'");
            msg.append(String.valueOf(compNameGuid));
            msg.append("'");
            log.error(msg.toString(), (Throwable)e);
            PersistenceManager.handleDBExceptionForAnySession(null, e, s);
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(s);
        }
        return compNamePO;
    }

    public static final void deleteCompNames(EntityManager s, Collection<IComponentNamePO> toDelete) throws PMException {
        CompNamePM.lockComponentNames(s);
        for (IComponentNamePO compName : toDelete) {
            s.remove((Object)compName);
        }
    }

    public static final void deleteCompNames(EntityManager s, Long rootProjId) throws PMException {
        try {
            CompNamePM.lockComponentNames(s);
            Query q = s.createQuery("delete from ComponentNamePO c where c.hbmParentProjectId = :rootProjId");
            q.setParameter("rootProjId", (Object)rootProjId);
            q.executeUpdate();
        }
        catch (PersistenceException e) {
            OperationCanceledUtil.checkForOperationCanceled((RuntimeException)((Object)e));
            log.error(String.valueOf(Messages.CouldNotReadComponentNamesFromDBOfProjectWithID) + " " + "'" + String.valueOf(rootProjId) + "'", (Throwable)e);
            PersistenceManager.handleDBExceptionForAnySession(null, e, s);
        }
    }

    public static final void updateCompNameTypes(EntityManager s, IComponentNameMapper compNamesBinding, Collection<String> guids, Long rootProjId) throws PMException, IncompatibleTypeException {
        if (guids.isEmpty()) {
            return;
        }
        try {
            CompNamePM.lockComponentNames(s);
            Query q = s.createQuery("select c from ComponentNamePO c where c.hbmGuid in :guidList AND c.hbmParentProjectId = :projId");
            q.setParameter("guidList", guids);
            q.setParameter("projId", (Object)rootProjId);
            List compNames = q.getResultList();
            for (IComponentNamePO compName : compNames) {
                String guid = compName.getGuid();
                String newType = ComponentNamesBP.getInstance().computeComponentType(compName.getName(), compNamesBinding.getUsedTypes(guid));
                if (newType != null && !newType.equals("guidancer.abstract.Unknown") || newType != null && newType.equals(compName.getComponentType())) {
                    compName.setComponentType(newType);
                    continue;
                }
                String currType = "";
                IComponentNamePO masterCompName = (IComponentNamePO)GeneralStorage.getInstance().getMasterSession().find(PoMaker.getComponentNameClass(), (Object)compName.getId());
                if (masterCompName != null) {
                    currType = masterCompName.getComponentType();
                }
                CompNamePM.unlockComponentNames();
                StringBuilder msgbuild = new StringBuilder();
                msgbuild.append(Messages.ErrorSavingChangedComponentNameType);
                msgbuild.append(".");
                msgbuild.append("\n");
                msgbuild.append(Messages.IncompatibleType);
                msgbuild.append(currType);
                msgbuild.append("'");
                msgbuild.append(" ");
                msgbuild.append("-");
                msgbuild.append(">");
                msgbuild.append(" ");
                msgbuild.append("'");
                msgbuild.append(compName.getComponentType());
                msgbuild.append("'");
                msgbuild.append("!");
                String msg = msgbuild.toString();
                throw new IncompatibleTypeException(compName, msg, MessageIDs.E_COMP_TYPE_INCOMPATIBLE, new String[]{compName.getName(), CompSystemI18n.getString((String)currType), CompSystemI18n.getString((String)compName.getComponentType())});
            }
        }
        catch (PMObjectDeletedException e) {
            log.error(Messages.ExceptionShouldNotHappen, (Throwable)((Object)e));
            Assert.notReached((String)(String.valueOf(Messages.ExceptionShouldNotHappen) + ":" + (Object)((Object)e)));
        }
    }

    public static final Map<String, String> writeNamePOList(EntityManager s, Collection<IComponentNamePO> namePoList, Long rootProjId) throws PMException {
        if (namePoList.isEmpty()) {
            return Collections.emptyMap();
        }
        IPersistentObject persObj = null;
        HashSet<String> names = new HashSet<String>();
        HashSet<IComponentNamePO> toAddSet = new HashSet<IComponentNamePO>(namePoList);
        for (IComponentNamePO compName : toAddSet) {
            names.add(compName.getName());
        }
        HashSet preExistingNames = new HashSet();
        HashMap<String, String> createdToExistingMap = new HashMap<String, String>();
        try {
            CompNamePM.lockComponentNames(s);
            ValueListIterator iter = new ValueListIterator(new ArrayList(names));
            while (iter.hasNext()) {
                Query existingNamesQuery = s.createQuery(Q_PREEXISTING_NAMES);
                existingNamesQuery.setParameter(P_PARENT_PROJECT_ID, (Object)rootProjId);
                existingNamesQuery.setParameter(P_NAME_SET, iter.next());
                preExistingNames.addAll(existingNamesQuery.getResultList());
            }
            HashSet<IComponentNamePO> removeFromAddList = new HashSet<IComponentNamePO>();
            block4: for (IComponentNamePO preExistingName : preExistingNames) {
                for (IComponentNamePO nameToAdd : toAddSet) {
                    if (!nameToAdd.getName().equals(preExistingName.getName())) continue;
                    createdToExistingMap.put(nameToAdd.getGuid(), preExistingName.getGuid());
                    preExistingName.setComponentType(nameToAdd.getComponentType());
                    removeFromAddList.add(nameToAdd);
                    continue block4;
                }
            }
            toAddSet.removeAll(removeFromAddList);
            Iterator iterator = toAddSet.iterator();
            while (iterator.hasNext()) {
                IPersistentObject namePO;
                persObj = namePO = (IPersistentObject)iterator.next();
                namePO.setParentProjectId(rootProjId);
                s.persist((Object)namePO);
            }
        }
        catch (PersistenceException e) {
            OperationCanceledUtil.checkForOperationCanceled((RuntimeException)((Object)e));
            log.error(String.valueOf(Messages.ErrorWritingComponentNamesToDBOfProjectID) + " " + "'" + String.valueOf(rootProjId) + "'", (Throwable)e);
            PersistenceManager.handleDBExceptionForAnySession(persObj, e, s);
        }
        return createdToExistingMap;
    }

    public static final IComponentNamePO checkExistingName(Long parentProjId, String guid, String name) throws PMException {
        EntityManager s = null;
        IComponentNamePO compNamePO = null;
        try {
            try {
                s = Persistor.instance().openSession();
                Query q = s.createQuery("select compName from ComponentNamePO compName where compName.hbmParentProjectId = :parentProjId and not compName.hbmGuid = :guid and compName.hbmName = :name");
                q.setParameter("parentProjId", (Object)parentProjId);
                q.setParameter("guid", (Object)guid);
                q.setParameter("name", (Object)name);
                compNamePO = (IComponentNamePO)q.getSingleResult();
            }
            catch (NoResultException noResultException) {
                Persistor.instance().dropSession(s);
            }
            catch (PersistenceException e) {
                OperationCanceledUtil.checkForOperationCanceled((RuntimeException)((Object)e));
                StringBuilder msg = new StringBuilder();
                msg.append(Messages.CouldNotReadComponentNameWithParentProjID);
                msg.append(" ");
                msg.append("'");
                msg.append(String.valueOf(parentProjId));
                msg.append("'");
                msg.append(" ");
                msg.append(Messages.AndName);
                msg.append(" ");
                msg.append("'");
                msg.append(String.valueOf(name));
                msg.append("'");
                log.error(msg.toString(), (Throwable)e);
                PersistenceManager.handleDBExceptionForAnySession(null, e, s);
                Persistor.instance().dropSession(s);
            }
        }
        finally {
            Persistor.instance().dropSession(s);
        }
        return compNamePO;
    }

    private static final void lockComponentNames(EntityManager s) throws PMObjectDeletedException, PMAlreadyLockedException {
        try {
            if (lockObj == null) {
                CompNamePM.initLockedObj();
            }
            long start = System.currentTimeMillis();
            while (!LockManager.instance().lockPO(s, lockObj, false)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                long stop = System.currentTimeMillis();
                if (stop - start <= 5000L) continue;
                throw new PMAlreadyLockedException(lockObj, Messages.CouldNotGetALockOnTableCOMPONENT_NAMES, MessageIDs.E_DATABASE_GENERAL);
            }
        }
        catch (PMDirtyVersionException e) {
            Assert.notReached((String)(String.valueOf(Messages.ExceptionShouldNotHappen) + ":" + " " + (Object)((Object)e)));
        }
    }

    private static final void unlockComponentNames() {
        LockManager.instance().unlockPO(lockObj);
    }

    private static void loadLockedObj() {
        EntityManager sess = null;
        try {
            try {
                sess = Persistor.instance().openSession();
                EntityTransaction tx = sess.getTransaction();
                tx.begin();
                Query q = sess.createQuery("select p from LockedObjectPO p where p.hbmObjectName = :hbmObjectName");
                q.setParameter("hbmObjectName", (Object)COMP_NAME_TABLE_ID);
                try {
                    lockObj = (LockedObjectPO)q.getSingleResult();
                }
                catch (NoResultException noResultException) {
                    lockObj = null;
                }
                tx.commit();
            }
            catch (PersistenceException e) {
                throw new JBFatalAbortException(String.valueOf(Messages.ErrorInitializingComponentNamesLocking) + "!", (Throwable)e, MessageIDs.E_DATABASE_GENERAL);
            }
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(sess);
        }
    }

    private static void initLockedObj() {
        CompNamePM.createOrUpdateCompNamesLock();
        CompNamePM.loadLockedObj();
    }

    private static void createOrUpdateCompNamesLock() throws PersistenceException {
        EntityManager s = null;
        EntityTransaction tx = null;
        try {
            try {
                s = Persistor.instance().openSession();
                tx = s.getTransaction();
                tx.begin();
                Query q = s.createQuery("select p from LockedObjectPO p where p.hbmObjectName = :hbmObjectName");
                q.setParameter("hbmObjectName", (Object)COMP_NAME_TABLE_ID);
                try {
                    q.getSingleResult();
                }
                catch (NoResultException noResultException) {
                    s.persist((Object)new LockedObjectPO(COMP_NAME_TABLE_ID));
                }
                tx.commit();
            }
            catch (PersistenceException e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
        }
        finally {
            Persistor.instance().dropSession(s);
        }
    }

    public static synchronized int getNumReuseInstances(EntityManager sess, Long parentProjectId, String compNameGuid) {
        Set<Long> emptySet = Collections.emptySet();
        return CompNamePM.fillComponentNameTypeReuseCollection(sess, parentProjectId, compNameGuid, emptySet, emptySet, emptySet, new ArrayList<String>()).size();
    }

    public static synchronized Collection<String> getReuseTypes(EntityManager s, Long parentProjectId, String compNameGuid, Set<Long> ignoreNamePairIds, Set<Long> ignoreCapIds, Set<Long> ignoreAutIds) {
        Collection<String> types = CompNamePM.fillComponentNameTypeReuseCollection(s, parentProjectId, compNameGuid, ignoreNamePairIds, ignoreCapIds, ignoreAutIds, new HashSet<String>());
        return types;
    }

    private static synchronized Collection<String> fillComponentNameTypeReuseCollection(EntityManager s, Long parentProjectId, String compNameGuid, Set<Long> ignoreNamePairIds, Set<Long> ignoreCapIds, Set<Long> ignoreAutIds, Collection<String> toFill) {
        boolean shouldIgnoreCaps = !ignoreCapIds.isEmpty();
        FlushModeType flushMode = s.getFlushMode();
        s.setFlushMode(FlushModeType.COMMIT);
        try {
            toFill.addAll(CompNamePM.getPairReuseTypes(compNameGuid, parentProjectId, ignoreNamePairIds, s));
            Query mappingQuery = s.createQuery(Q_REUSE_TYPE_ASSOCS);
            mappingQuery.setParameter(P_PARENT_PROJECT_ID, (Object)parentProjectId);
            mappingQuery.setParameter(P_COMP_NAME_GUID, (Object)compNameGuid);
            List assocs = mappingQuery.getResultList();
            ArrayList<String> assocCompTypes = new ArrayList<String>();
            CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
            CriteriaQuery query = s.getCriteriaBuilder().createQuery();
            List allAuts = s.createQuery(query.select((Selection)query.from(PoMaker.getAUTMainClass()))).getResultList();
            block3: for (IObjectMappingAssoziationPO assoc : assocs) {
                ICompIdentifierPO technicalName = assoc.getTechnicalName();
                if (technicalName == null) continue;
                for (IAUTMainPO aut : allAuts) {
                    if (ignoreAutIds.contains(aut.getId()) || !aut.getObjMap().getMappings().contains(assoc)) continue;
                    List availableComponents = compSystem.getComponents(aut.getToolkit(), true);
                    assocCompTypes.add(CompSystem.getComponentType((String)technicalName.getSupportedClassName(), (Collection)availableComponents));
                    continue block3;
                }
            }
            toFill.addAll(assocCompTypes);
            StringBuilder capQuerySb = new StringBuilder(Q_REUSE_TYPE_CAPS);
            if (shouldIgnoreCaps) {
                capQuerySb.append(SQ_REUSE_TYPE_CAPS_IGNORE);
            }
            Query capQuery = s.createQuery(capQuerySb.toString());
            capQuery.setParameter(P_PARENT_PROJECT_ID, (Object)parentProjectId);
            capQuery.setParameter(P_COMP_NAME_GUID, (Object)compNameGuid);
            if (shouldIgnoreCaps) {
                capQuery.setParameter(P_IGNORE_CAPS, ignoreCapIds);
            }
            toFill.addAll(capQuery.getResultList());
        }
        finally {
            s.setFlushMode(flushMode);
        }
        return toFill;
    }

    private static Collection<String> getPairReuseTypes(String compNameGuid, Long parentProjectId, Set<Long> ignoreNamePairIds, EntityManager s) {
        HashSet<String> returnSet = new HashSet<String>();
        boolean shouldIgnorePairs = !ignoreNamePairIds.isEmpty();
        StringBuilder reuseQuerySb = new StringBuilder(Q_REUSE_TYPE_PAIRS);
        if (shouldIgnorePairs) {
            reuseQuerySb.append(SQ_REUSE_TYPE_PAIRS_IGNORE);
        }
        Query reuseQuery = s.createQuery(reuseQuerySb.toString());
        reuseQuery.setParameter(P_PARENT_PROJECT_ID, (Object)parentProjectId);
        if (shouldIgnorePairs) {
            reuseQuery.setParameter(P_IGNORE_PAIRS, ignoreNamePairIds);
        }
        reuseQuery.setParameter(P_COMP_NAME_GUID, (Object)compNameGuid);
        HashSet compNamePairs = new HashSet(reuseQuery.getResultList());
        HashSet<Long> compNamePairIds = new HashSet<Long>();
        for (ICompNamesPairPO pair : compNamePairs) {
            compNamePairIds.add(pair.getId());
        }
        if (!compNamePairs.isEmpty()) {
            Query execTcQuery;
            if (compNamePairs.size() <= 1000) {
                execTcQuery = s.createQuery(Q_EXEC_TCS_WITH_PAIR);
                execTcQuery.setParameter(P_PAIR_LIST, compNamePairIds);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("select execTc from ExecTestCasePO execTc left outer join execTc.hbmCompNamesMap as compNamesMap where");
                Object[] compNamePairArray = compNamePairIds.toArray();
                int numLists = compNamePairArray.length / 1000 + 1;
                int i = 0;
                while (i < numLists) {
                    if (i != 0) {
                        sb.append(" or");
                    }
                    sb.append(" compNamesMap.id in :pairList" + i);
                    ++i;
                }
                execTcQuery = s.createQuery(sb.toString());
                i = 0;
                while (i < numLists) {
                    Object[] subArray = new Object[Math.min((i + 1) * 1000, compNamePairArray.length) - i * 1000];
                    System.arraycopy(compNamePairArray, i * 1000, subArray, 0, subArray.length);
                    execTcQuery.setParameter(P_PAIR_LIST + i, (Object)subArray);
                    ++i;
                }
            }
            List list = execTcQuery.getResultList();
            for (IExecTestCasePO execTc : list) {
                for (ICompNamesPairPO pair : execTc.getCompNamesPairs()) {
                    if (!compNamePairs.contains(pair)) continue;
                    CompNamesBP.searchCompType(pair, execTc);
                }
            }
            for (ICompNamesPairPO pair : compNamePairs) {
                returnSet.add(pair.getType());
            }
        }
        return returnSet;
    }

    public static void flushCompNames(EntityManager session, Long projId, IWritableComponentNameMapper compNamesBinding) throws PMException, IncompatibleTypeException {
        IWritableComponentNameCache cache = compNamesBinding.getCompNameCache();
        Collection<IComponentNamePO> namesToInsert = cache.getNewNames();
        Collection<String> namesWithChangedReuse = cache.getReusedNames();
        Collection<IComponentNamePO> namesToDelete = cache.getDeletedNames();
        Map<String, String> preExistingGuidMap = CompNamePM.writeNamePOList(session, namesToInsert, projId);
        compNamesBinding.handleExistingNames(preExistingGuidMap);
        HashSet<String> namesToChangeReuse = new HashSet<String>(namesWithChangedReuse);
        namesToChangeReuse.addAll(preExistingGuidMap.values());
        CompNamePM.updateCompNameTypes(session, compNamesBinding, namesToChangeReuse, projId);
        CompNamePM.deleteCompNames(session, namesToDelete);
    }

    public static void removeUnusedCompNames(Long projectId, EntityManager session) {
        Query refCompNameGuidQuery = session.createQuery(Q_REF_COMP_NAME_GUIDS);
        refCompNameGuidQuery.setParameter(P_PARENT_PROJECT_ID, (Object)projectId);
        List refCompNameGuids = refCompNameGuidQuery.getResultList();
        if (refCompNameGuids.isEmpty()) {
            return;
        }
        Query capQuery = session.createQuery(Q_CAP_COMP_NAME_GUIDS);
        capQuery.setParameter(P_PARENT_PROJECT_ID, (Object)projectId);
        List capCompNames = capQuery.getResultList();
        refCompNameGuids.removeAll(capCompNames);
        if (refCompNameGuids.isEmpty()) {
            return;
        }
        Query pairQuery = session.createQuery(Q_PAIR_FIRST_COMP_NAME_GUIDS);
        pairQuery.setParameter(P_PARENT_PROJECT_ID, (Object)projectId);
        List pairCompNameGuids = pairQuery.getResultList();
        refCompNameGuids.removeAll(pairCompNameGuids);
        if (refCompNameGuids.isEmpty()) {
            return;
        }
        pairQuery = session.createQuery(Q_PAIR_SECOND_COMP_NAME_GUIDS);
        pairQuery.setParameter(P_PARENT_PROJECT_ID, (Object)projectId);
        pairCompNameGuids = pairQuery.getResultList();
        refCompNameGuids.removeAll(pairCompNameGuids);
        if (refCompNameGuids.isEmpty()) {
            return;
        }
        Query assocQuery = session.createQuery(Q_ASSOC_COMP_NAME_GUIDS);
        assocQuery.setParameter(P_PARENT_PROJECT_ID, (Object)projectId);
        List assocCompNameGuids = assocQuery.getResultList();
        refCompNameGuids.removeAll(assocCompNameGuids);
        if (refCompNameGuids.isEmpty()) {
            return;
        }
        Query compNameRefQuery = session.createQuery(Q_COMP_NAME_REF_GUIDS);
        compNameRefQuery.setParameter(P_PARENT_PROJECT_ID, (Object)projectId);
        List compNameRefGuidList = compNameRefQuery.getResultList();
        refCompNameGuids.removeAll(compNameRefGuidList);
        if (refCompNameGuids.isEmpty()) {
            return;
        }
        Query deleteQuery = session.createQuery(Q_DELETE_COMP_NAMES);
        deleteQuery.setParameter(P_PARENT_PROJECT_ID, (Object)projectId);
        deleteQuery.setParameter(P_COMP_NAME_REMOVAL_LIST, (Object)refCompNameGuids);
        deleteQuery.executeUpdate();
    }

    public static void dispose() {
        lockObj = null;
    }
}

