/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.eclipse.jubula.client.core.businessprocess.progress.OperationCanceledUtil;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.TestResultPM;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResultSummaryPM {
    private static Logger log = LoggerFactory.getLogger(TestResultSummaryPM.class);
    private static final String PROPNAME_GUID = "internalGuid";
    private static final String PROPNAME_PROJECT_GUID = "internalProjectGuid";
    private static final String PROPNAME_PROJECT_MAJOR_VERSION = "projectMajorVersion";
    private static final String PROPNAME_PROJECT_MINOR_VERSION = "projectMinorVersion";
    private static final String PROPNAME_AUT_AGENT_NAME = "autAgentName";
    private static final String PROPNAME_EXECUTED_TESTSTEPS = "testsuiteExecutedTeststeps";
    private static final String PROPNAME_AUT_HOSTNAME = "autHostname";
    private static final String PROPNAME_TESTSUITE_DATE = "testsuiteDate";

    private TestResultSummaryPM() {
    }

    public static final List<ITestResultSummaryPO> getAllTestResultSummaries(IProjectPO proj, EntityManager se) throws PMException {
        List ltrs;
        block5: {
            ltrs = null;
            EntityManager s = null;
            try {
                try {
                    s = se != null ? se : Persistor.instance().openSession();
                    CriteriaBuilder builder = s.getCriteriaBuilder();
                    CriteriaQuery query = builder.createQuery();
                    Root from = query.from(PoMaker.getTestResultSummaryClass());
                    query.select((Selection)from).where((Expression)builder.equal((Expression)from.get(PROPNAME_PROJECT_GUID), (Object)proj.getGuid()));
                    ltrs = s.createQuery(query).getResultList();
                }
                catch (PersistenceException e) {
                    OperationCanceledUtil.checkForOperationCanceled((RuntimeException)((Object)e));
                    PersistenceManager.handleDBExceptionForAnySession(null, e, s);
                    Persistor.instance().dropSession(s);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Persistor.instance().dropSession(s);
                throw throwable;
            }
            Persistor.instance().dropSession(s);
        }
        return ltrs;
    }

    public static final void storeTestResultSummaryInDB(ITestResultSummaryPO summary) {
        EntityManager sess = Persistor.instance().openSession();
        try {
            try {
                EntityTransaction tx = Persistor.instance().getTransaction(sess);
                sess.persist((Object)summary);
                Persistor.instance().commitTransaction(sess, tx);
            }
            catch (PMException e) {
                throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
            }
            catch (ProjectDeletedException e) {
                throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
            }
        }
        finally {
            Persistor.instance().dropSession(sess);
        }
    }

    public static final void mergeTestResultSummaryInDB(ITestResultSummaryPO summary) {
        EntityManager sess = Persistor.instance().openSession();
        try {
            try {
                EntityTransaction tx = Persistor.instance().getTransaction(sess);
                sess.merge((Object)summary);
                Persistor.instance().commitTransaction(sess, tx);
            }
            catch (PMException e) {
                throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
            }
            catch (ProjectDeletedException e) {
                throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
            }
        }
        finally {
            Persistor.instance().dropSession(sess);
        }
    }

    public static final boolean doesTestResultSummaryExist(ITestResultSummaryPO summary) {
        EntityManager sess = Persistor.instance().openSession();
        try {
            CriteriaBuilder builder = sess.getCriteriaBuilder();
            CriteriaQuery guidDuplicateQuery = builder.createQuery();
            Root guidDuplicateFrom = guidDuplicateQuery.from(PoMaker.getTestResultSummaryClass());
            guidDuplicateQuery.select((Selection)builder.count((Expression)guidDuplicateFrom)).where((Expression)builder.equal((Expression)guidDuplicateFrom.get(PROPNAME_GUID), (Object)summary.getInternalGuid()));
            Number count = (Number)sess.createQuery(guidDuplicateQuery).getSingleResult();
            if (count.longValue() > 0L) {
                return true;
            }
            CriteriaQuery duplicateQuery = builder.createQuery();
            Root duplicateFrom = duplicateQuery.from(PoMaker.getTestResultSummaryClass());
            duplicateQuery.select((Selection)builder.count((Expression)duplicateFrom)).where((Expression)builder.and(new Predicate[]{builder.equal((Expression)duplicateFrom.get(PROPNAME_TESTSUITE_DATE), (Object)summary.getTestsuiteDate()), builder.equal((Expression)duplicateFrom.get(PROPNAME_AUT_HOSTNAME), (Object)summary.getAutHostname()), builder.equal((Expression)duplicateFrom.get(PROPNAME_EXECUTED_TESTSTEPS), (Object)summary.getTestsuiteExecutedTeststeps()), builder.equal((Expression)duplicateFrom.get(PROPNAME_AUT_AGENT_NAME), (Object)summary.getAutAgentName())}));
            count = (Number)sess.createQuery(duplicateQuery).getSingleResult();
            if (count.longValue() > 0L) {
                log.error("Duplicate Test Result Summary (GUID=" + summary.getInternalGuid() + ") will not be imported.");
                return true;
            }
            return false;
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(sess);
        }
    }

    public static final List<ITestResultSummaryPO> findAllTestResultSummaries(Date startTime) throws JBException {
        EntityManager session = null;
        if (Persistor.instance() == null) {
            return null;
        }
        try {
            List metaList;
            session = Persistor.instance().openSession();
            Query query = session.createQuery("select s from TestResultSummaryPO as s where s.testsuiteDate > :startTime");
            query.setParameter("startTime", (Object)startTime);
            List list = metaList = query.getResultList();
            return list;
        }
        catch (PersistenceException e) {
            log.error(Messages.PersistenceLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static final Set<Long> findTestResultSummariesByDate(Date cleanDate, String projGUID, int majorVersion, int minorVersion) throws JBException {
        EntityManager session = null;
        if (Persistor.instance() == null) {
            return null;
        }
        try {
            HashSet<Long> idSet;
            session = Persistor.instance().openSession();
            Query query = session.createQuery("select r.internalTestResultSummaryID from TestResultPO as r where r.internalTestResultSummaryID in (select s.id from TestResultSummaryPO as s where s.testsuiteDate < :cleanDate and s.internalProjectGuid = :projGUID and s.projectMajorVersion = :majorVersion and s.projectMinorVersion = :minorVersion)");
            query.setParameter("cleanDate", (Object)cleanDate);
            query.setParameter("projGUID", (Object)projGUID);
            query.setParameter("majorVersion", (Object)majorVersion);
            query.setParameter("minorVersion", (Object)minorVersion);
            List metaList = query.getResultList();
            HashSet<Long> hashSet = idSet = new HashSet<Long>(metaList);
            return hashSet;
        }
        catch (PersistenceException e) {
            log.error(Messages.PersistenceLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static final void deleteTestruns(Long[] resultIDs) {
        if (Persistor.instance() == null || resultIDs.length == 0) {
            return;
        }
        Long[] longArray = resultIDs;
        int n = resultIDs.length;
        int n2 = 0;
        while (n2 < n) {
            Long resultID = longArray[n2];
            TestResultSummaryPM.deleteTestrun(resultID);
            ++n2;
        }
    }

    public static final void deleteTestrun(Long resultID) {
        if (Persistor.instance() == null) {
            return;
        }
        EntityManager session = Persistor.instance().openSession();
        try {
            try {
                EntityTransaction tx = Persistor.instance().getTransaction(session);
                TestResultPM.executeDeleteTestresultOfSummary(session, resultID);
                Query querySummary = session.createQuery("select s from TestResultSummaryPO as s where s.id = :id");
                querySummary.setParameter("id", (Object)resultID);
                try {
                    ITestResultSummaryPO meta = (ITestResultSummaryPO)querySummary.getSingleResult();
                    session.remove((Object)meta);
                }
                catch (NoResultException noResultException) {}
                Persistor.instance().commitTransaction(session, tx);
            }
            catch (PMException e) {
                throw new JBFatalException(Messages.DeleteTestrunMetadataFailed, (Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
            }
            catch (ProjectDeletedException e) {
                throw new JBFatalException(Messages.DeleteTestrunMetadataFailed, (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
            }
        }
        finally {
            Persistor.instance().dropSession(session);
        }
    }

    public static final void deleteTestrunsByProject(String guid, int major, int minor, boolean deleteOnlyDetails) {
        if (Persistor.instance() == null) {
            return;
        }
        EntityManager session = Persistor.instance().openSession();
        try {
            try {
                EntityTransaction tx = Persistor.instance().getTransaction(session);
                StringBuilder queryBuilder = new StringBuilder();
                queryBuilder.append("select s from TestResultSummaryPO as s where s.").append(PROPNAME_PROJECT_GUID).append(" = :guid and s.").append(PROPNAME_PROJECT_MAJOR_VERSION).append(" = :major and s.").append(PROPNAME_PROJECT_MINOR_VERSION).append(" = :minor");
                Query querySummary = session.createQuery(queryBuilder.toString());
                querySummary.setParameter("guid", (Object)guid);
                querySummary.setParameter("major", (Object)major);
                querySummary.setParameter("minor", (Object)minor);
                List summaryList = querySummary.getResultList();
                for (ITestResultSummaryPO summary : summaryList) {
                    TestResultPM.executeDeleteTestresultOfSummary(session, summary.getId());
                    if (deleteOnlyDetails) continue;
                    session.remove((Object)summary);
                }
                Persistor.instance().commitTransaction(session, tx);
            }
            catch (PMException e) {
                throw new JBFatalException(Messages.DeleteTestrunFailed, (Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
            }
            catch (ProjectDeletedException e) {
                throw new JBFatalException(Messages.DeleteTestrunFailed, (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
            }
        }
        finally {
            Persistor.instance().dropSession(session);
        }
    }

    public static final void deleteAllTestresultSummaries() {
        if (Persistor.instance() == null) {
            return;
        }
        EntityManager session = Persistor.instance().openSession();
        try {
            try {
                EntityTransaction tx = Persistor.instance().getTransaction(session);
                Query query = session.createQuery("delete from TestResultSummaryPO as s");
                query.executeUpdate();
                Persistor.instance().commitTransaction(session, tx);
            }
            catch (PMException e) {
                throw new JBFatalException(Messages.DeleteAllTestrunSummariesFailed, (Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
            }
            catch (ProjectDeletedException e) {
                throw new JBFatalException(Messages.DeleteAllTestrunSummariesFailed, (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
            }
        }
        finally {
            Persistor.instance().dropSession(session);
        }
    }
}

