/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.implclasses;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swing.swing.implclasses.AbstractSwingImplClass;
import org.eclipse.jubula.rc.swing.swing.implclasses.MenuUtil;
import org.eclipse.jubula.rc.swing.swing.implclasses.WindowHelper;
import org.eclipse.jubula.rc.swing.swing.interfaces.IJMenuBarImplClass;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.TimeUtil;

public class JMenuBarImplClass
extends AbstractSwingImplClass
implements IJMenuBarImplClass {
    private static AutServerLogger log;
    private JMenuBar m_menuBar;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.swing.implclasses.JMenuBarImplClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public void setComponent(Object graphicsComponent) {
        this.m_menuBar = (JMenuBar)graphicsComponent;
    }

    public JComponent getComponent() {
        Window activeWindow = WindowHelper.getActiveWindow();
        if (activeWindow == null) {
            log.warn((Object)"JMenuBarImplClass.getComponent(): No active window.");
        } else {
            JMenuBar menuBar = null;
            JRootPane rootPane = null;
            if (activeWindow instanceof JDialog) {
                JDialog dialog = (JDialog)activeWindow;
                menuBar = dialog.getJMenuBar();
                rootPane = dialog.getRootPane();
            } else if (activeWindow instanceof JFrame) {
                JFrame frame = (JFrame)activeWindow;
                menuBar = frame.getJMenuBar();
                rootPane = frame.getRootPane();
            }
            if (menuBar == null) {
                menuBar = this.getMenuBarWorkaround(rootPane);
            }
            this.setComponent(menuBar);
        }
        return this.m_menuBar;
    }

    public void waitForComponent(int timeout, int delay) {
        if (this.getComponent() == null) {
            long start = System.currentTimeMillis();
            do {
                RobotTiming.sleepWaitForComponentPollingDelay();
            } while (System.currentTimeMillis() - start < (long)timeout && this.getComponent() == null);
            if (this.getComponent() == null) {
                throw new StepExecutionException("No Menubar found.", EventFactory.createComponentNotFoundErrorEvent());
            }
        }
        TimeUtil.delay((long)delay);
    }

    public void selectMenuItem(String menuItem, String operator) {
        this.selectMenuItem(MenuUtil.splitPath(menuItem), operator);
    }

    public void selectMenuItem(String[] menuItem, String operator) {
        if (menuItem.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), this.getAndCheckMenu(), menuItem, operator);
        if (item == null) {
            try {
                MenuUtil.closeMenu(this.getRobot(), this.getAndCheckMenu(), menuItem[0]);
            }
            catch (StepExecutionException stepExecutionException) {
                log.info((Object)"Tried to close a disabled or already closed menu.");
            }
            throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        MenuUtil.clickMenuItem(this.getRobot(), item);
    }

    public void selectMenuItemByIndexpath(String path) {
        this.selectMenuItemByIndexpath(MenuUtil.splitIndexPath(path));
    }

    public void selectMenuItemByIndexpath(int[] path) {
        if (path.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), this.getAndCheckMenu(), path);
        if (item == null) {
            try {
                MenuUtil.closeMenu(this.getRobot(), this.getAndCheckMenu(), path[0]);
            }
            catch (StepExecutionException stepExecutionException) {
                log.info((Object)"Tried to close a disabled or already closed menu.");
            }
            throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        MenuUtil.clickMenuItem(this.getRobot(), item);
    }

    public void verifyExists(String menuItem, String operator, boolean exists) {
        this.verifyExists(MenuUtil.splitPath(menuItem), operator, exists);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyExists(String[] menuItem, String operator, boolean exists) {
        if (menuItem.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
        final JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), this.getAndCheckMenu(), menuItem, operator);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.jubula.rc.swing.swing.implclasses.JMenuBarImplClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            this.verify(exists, String.valueOf(clazz.getName()) + ".verifyExists", new IRunnable(){

                public Object run() {
                    return item != null && item instanceof JMenuItem ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            JMenu menu = MenuUtil.findMenu(this.getAndCheckMenu(), menuItem[0], operator);
            if (menu == null) throw throwable;
            if (!menu.isPopupMenuVisible()) throw throwable;
            this.getRobot().click((Object)menu, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        JMenu menu = MenuUtil.findMenu(this.getAndCheckMenu(), menuItem[0], operator);
        if (menu == null) return;
        if (!menu.isPopupMenuVisible()) return;
        this.getRobot().click((Object)menu, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
    }

    public void verifyExistsByIndexpath(String menuItem, boolean exists) {
        this.verifyExistsByIndexpath(MenuUtil.splitIndexPath(menuItem), exists);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyExistsByIndexpath(int[] menuItem, boolean exists) {
        if (menuItem.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        final JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), this.getAndCheckMenu(), menuItem);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.jubula.rc.swing.swing.implclasses.JMenuBarImplClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            this.verify(exists, String.valueOf(clazz.getName()) + ".verifyExists", new IRunnable(){

                public Object run() {
                    return item != null && item instanceof JMenuItem ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            JMenu menu = MenuUtil.findMenu(this.getAndCheckMenu(), menuItem[0]);
            if (menu == null) throw throwable;
            if (!menu.isPopupMenuVisible()) throw throwable;
            this.getRobot().click((Object)menu, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        JMenu menu = MenuUtil.findMenu(this.getAndCheckMenu(), menuItem[0]);
        if (menu == null) return;
        if (!menu.isPopupMenuVisible()) return;
        this.getRobot().click((Object)menu, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
    }

    public void verifyEnabled(String menuItem, String operator, boolean enabled) {
        this.verifyEnabled(MenuUtil.splitPath(menuItem), operator, enabled);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyEnabled(String[] menuItem, String operator, boolean enabled) {
        if (menuItem.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        final JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), this.getAndCheckMenu(), menuItem, operator);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.jubula.rc.swing.swing.implclasses.JMenuBarImplClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            this.verify(enabled, String.valueOf(clazz.getName()) + ".verifyEnabled", new IRunnable(){

                public Object run() {
                    return item != null && item instanceof JMenuItem && item.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            JMenu menu = MenuUtil.findMenu(this.getAndCheckMenu(), menuItem[0], operator);
            if (menu == null) throw throwable;
            if (!menu.isPopupMenuVisible()) throw throwable;
            this.getRobot().click((Object)menu, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        JMenu menu = MenuUtil.findMenu(this.getAndCheckMenu(), menuItem[0], operator);
        if (menu == null) return;
        if (!menu.isPopupMenuVisible()) return;
        this.getRobot().click((Object)menu, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
    }

    public void verifyEnabledByIndexpath(String menuItem, boolean enabled) {
        this.verifyEnabledByIndexpath(MenuUtil.splitIndexPath(menuItem), enabled);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyEnabledByIndexpath(int[] menuItem, boolean enabled) {
        if (menuItem.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        final JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), this.getAndCheckMenu(), menuItem);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.jubula.rc.swing.swing.implclasses.JMenuBarImplClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            this.verify(enabled, String.valueOf(clazz.getName()) + ".verifyEnabled", new IRunnable(){

                public Object run() {
                    return item != null && item instanceof JMenuItem && item.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            JMenu menu = MenuUtil.findMenu(this.getAndCheckMenu(), menuItem[0]);
            if (menu == null) throw throwable;
            if (!menu.isPopupMenuVisible()) throw throwable;
            this.getRobot().click((Object)menu, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        JMenu menu = MenuUtil.findMenu(this.getAndCheckMenu(), menuItem[0]);
        if (menu == null) return;
        if (!menu.isPopupMenuVisible()) return;
        this.getRobot().click((Object)menu, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
    }

    public void verifySelected(String menuItem, String operator, boolean selected) {
        this.verifySelected(MenuUtil.splitPath(menuItem), operator, selected);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifySelected(String[] menuItem, String operator, boolean selected) {
        if (menuItem.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        final JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), this.getAndCheckMenu(), menuItem, operator);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.jubula.rc.swing.swing.implclasses.JMenuBarImplClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            this.verify(selected, String.valueOf(clazz.getName()) + ".verifySelected", new IRunnable(){

                public Object run() {
                    return item != null && item instanceof JMenuItem && ((JMenuItem)item).isSelected() ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            JMenu menu = MenuUtil.findMenu(this.getAndCheckMenu(), menuItem[0], operator);
            if (menu == null) throw throwable;
            if (!menu.isPopupMenuVisible()) throw throwable;
            this.getRobot().click((Object)menu, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        JMenu menu = MenuUtil.findMenu(this.getAndCheckMenu(), menuItem[0], operator);
        if (menu == null) return;
        if (!menu.isPopupMenuVisible()) return;
        this.getRobot().click((Object)menu, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
    }

    public void verifySelectedByIndexpath(String menuItem, boolean selected) {
        this.verifySelectedByIndexpath(MenuUtil.splitIndexPath(menuItem), selected);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifySelectedByIndexpath(int[] menuItem, boolean selected) {
        if (menuItem.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        final JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), this.getAndCheckMenu(), menuItem);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.jubula.rc.swing.swing.implclasses.JMenuBarImplClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            this.verify(selected, String.valueOf(clazz.getName()) + ".verifySelected", new IRunnable(){

                public Object run() {
                    return item != null && item instanceof JMenuItem && ((JMenuItem)item).isSelected() ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            JMenu menu = MenuUtil.findMenu(this.getAndCheckMenu(), menuItem[0]);
            if (menu == null) throw throwable;
            if (!menu.isPopupMenuVisible()) throw throwable;
            this.getRobot().click((Object)menu, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        JMenu menu = MenuUtil.findMenu(this.getAndCheckMenu(), menuItem[0]);
        if (menu == null) return;
        if (!menu.isPopupMenuVisible()) return;
        this.getRobot().click((Object)menu, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
    }

    private JMenuBar getAndCheckMenu() throws StepExecutionException {
        JMenuBar menu = (JMenuBar)this.getComponent();
        if (menu == null) {
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.NoMenuBar"), EventFactory.createActionError((String)"TestErrorEvent.NoMenuBar"));
        }
        return menu;
    }

    public String[] getTextArrayFromComponent() {
        ArrayList<JMenu> visibleMenuList = new ArrayList<JMenu>();
        MenuElement[] subElements = this.m_menuBar.getSubElements();
        int i = 0;
        while (i < subElements.length) {
            JMenu menu;
            if (subElements[i] instanceof JMenu && (menu = (JMenu)subElements[i]) != null && !menu.isShowing()) {
                visibleMenuList.add(menu);
            }
            ++i;
        }
        JMenu[] visibleMenuArray = visibleMenuList.toArray(new JMenu[visibleMenuList.size()]);
        String[] componentTextArray = new String[visibleMenuArray.length];
        int i2 = 0;
        while (i2 < componentTextArray.length) {
            JMenu menu = visibleMenuArray[i2];
            componentTextArray[i2] = menu == null ? null : menu.getText();
            ++i2;
        }
        return componentTextArray;
    }

    protected String getText() {
        return null;
    }

    private JMenuBar getMenuBarWorkaround(Container rootPane) {
        JMenuBar menuBar = null;
        ArrayList menuList = new ArrayList();
        this.collectMenuBarsWorkaround(rootPane, menuList);
        Iterator menuIter = menuList.iterator();
        while (menuIter.hasNext() && menuBar == null) {
            JMenuBar menu = (JMenuBar)menuIter.next();
            boolean hasAtLeastOneItem = false;
            MenuElement[] subElements = menu.getSubElements();
            int i = 0;
            while (i < subElements.length && !hasAtLeastOneItem) {
                if (subElements[i] instanceof JMenu) {
                    JMenu subMenu = (JMenu)subElements[i];
                    hasAtLeastOneItem = subMenu != null && subMenu.isShowing();
                }
                ++i;
            }
            if (!hasAtLeastOneItem) continue;
            menuBar = menu;
        }
        return menuBar;
    }

    private void collectMenuBarsWorkaround(Container container, List menuBarList) {
        Component[] children = container.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof JMenuBar && children[i].isShowing()) {
                menuBarList.add(children[i]);
            }
            ++i;
        }
        i = 0;
        while (i < children.length) {
            if (children[i] instanceof Container && children[i].isVisible()) {
                this.collectMenuBarsWorkaround((Container)children[i], menuBarList);
            }
            ++i;
        }
    }
}

