/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.ChildTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.ExpandCollapseTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.INodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.IndexNodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.ParentTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.PathBasedTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.SelectTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.SiblingTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.StringNodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperationConstraint;
import org.eclipse.jubula.rc.swt.implclasses.TableTreeOperationContext;
import org.eclipse.jubula.rc.swt.implclasses.TreeImplClass;
import org.eclipse.jubula.rc.swt.implclasses.TreeOperationContext;
import org.eclipse.jubula.rc.swt.interfaces.ITableTreeImplClass;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.objects.event.TestErrorEvent;
import org.eclipse.jubula.tools.utils.StringParsing;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TableTreeImplClass
extends TreeImplClass
implements ITableTreeImplClass {
    private Tree m_treeTable;
    private TreeImplClass m_treeImplClass;

    public Control getComponent() {
        return this.m_treeTable;
    }

    public void setComponent(Object graphicsComponent) {
        super.setComponent(graphicsComponent);
        this.m_treeTable = (Tree)graphicsComponent;
        this.m_treeImplClass = new TreeImplClass();
        this.m_treeImplClass.setComponent(this.m_treeTable);
    }

    public void gdExpand(String pathType, int preAscend, String treePath, String operator) throws StepExecutionException {
        this.m_treeImplClass.gdExpand(pathType, preAscend, treePath, operator);
    }

    public void gdExpandByIndices(String pathType, int preAscend, String indexPath) throws StepExecutionException {
        this.m_treeImplClass.gdExpandByIndices(pathType, preAscend, indexPath);
    }

    public void gdCollapse(String pathType, int preAscend, String treePath, String operator) throws StepExecutionException {
        this.m_treeImplClass.gdCollapse(pathType, preAscend, treePath, operator);
    }

    public void gdCollapseByIndices(String pathType, int preAscend, String indexPath) throws StepExecutionException {
        this.m_treeImplClass.gdCollapseByIndices(pathType, preAscend, indexPath);
    }

    public void gdMove(String direction, int distance, int clickCount) throws StepExecutionException {
        if (this.getColumnCount() > 0) {
            int mouseColumn = this.getMouseColumn();
            TableTreeOperationContext context = mouseColumn == -1 ? new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_treeTable) : new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_treeTable, mouseColumn);
            TreeItem selectedNode = this.getSelectedNode(context);
            SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(ClickOptions.create().setClickCount(clickCount));
            TreeNodeOperationConstraint constraint = new TreeNodeOperationConstraint();
            if ("up".equalsIgnoreCase(direction)) {
                ParentTraverser traverser = new ParentTraverser((AbstractTreeOperationContext)context, distance, constraint);
                traverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
            } else if ("down".equalsIgnoreCase(direction)) {
                ExpandCollapseTreeNodeOperation expandOp = new ExpandCollapseTreeNodeOperation(false);
                ChildTraverser expandTraverser = new ChildTraverser((AbstractTreeOperationContext)context, distance - 1);
                expandTraverser.traversePath((TreeNodeOperation)expandOp, (Object)selectedNode);
                ChildTraverser selectTraverser = new ChildTraverser((AbstractTreeOperationContext)context, distance, constraint);
                selectTraverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
            } else if ("next".equalsIgnoreCase(direction)) {
                SiblingTraverser traverser = new SiblingTraverser((AbstractTreeOperationContext)context, distance, true, constraint);
                traverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
            } else if ("previous".equalsIgnoreCase(direction)) {
                SiblingTraverser traverser = new SiblingTraverser((AbstractTreeOperationContext)context, distance, false, constraint);
                traverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
            }
        } else {
            super.gdMove(direction, distance, clickCount);
        }
    }

    private int getMouseColumn() {
        final Tree treeTable = this.m_treeTable;
        int column = (Integer)this.getEventThreadQueuer().invokeAndWait("getMouseColumn", new IRunnable(){

            public Object run() throws StepExecutionException {
                Point cursorPosition;
                Rectangle treeTableBounds = SwtUtils.getWidgetBounds((Widget)TableTreeImplClass.this.m_treeTable);
                boolean isCursorInBounds = treeTableBounds.contains(cursorPosition = treeTable.getDisplay().getCursorLocation());
                if (isCursorInBounds) {
                    int horizontalScrollOffset = 0;
                    ScrollBar horizontalBar = TableTreeImplClass.this.m_treeTable.getHorizontalBar();
                    if (horizontalBar != null && !horizontalBar.isDisposed()) {
                        horizontalScrollOffset = horizontalBar.getSelection();
                    }
                    Rectangle columnBounds = new Rectangle(treeTableBounds.x - horizontalScrollOffset, treeTableBounds.y, 0, treeTableBounds.height);
                    int i = 0;
                    while (i < treeTable.getColumnCount()) {
                        columnBounds.x += columnBounds.width;
                        columnBounds.width = treeTable.getColumn(i).getWidth();
                        if (columnBounds.contains(cursorPosition)) {
                            return new Integer(i);
                        }
                        ++i;
                    }
                }
                return new Integer(-1);
            }
        });
        return column;
    }

    public void gdSelect(String pathType, int preAscend, String treePath, String operator, int clickCount, int column, int button) throws StepExecutionException {
        int implCol = IndexConverter.toImplementationIndex((int)column);
        this.checkColumnIndex(implCol);
        this.selectByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator), ClickOptions.create().setClickCount(clickCount).setMouseButton(button), implCol);
    }

    public void gdSelectByIndices(String pathType, int preAscend, String indexPath, int clickCount, int column, int button) throws StepExecutionException {
        int implCol = IndexConverter.toImplementationIndex((int)column);
        this.checkColumnIndex(implCol);
        this.selectByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)), ClickOptions.create().setClickCount(clickCount).setMouseButton(button), implCol);
    }

    public void gdVerifySelectedValue(String pattern, int column) throws StepExecutionException {
        this.gdVerifySelectedValue(pattern, "equals", column);
    }

    public void gdVerifySelectedValue(String pattern, String operator, int column) throws StepExecutionException {
        int implCol = IndexConverter.toImplementationIndex((int)column);
        this.checkColumnIndex(implCol);
        TableTreeOperationContext context = new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_treeTable, implCol);
        String text = context.getNodeTextAtColumn(context.getSelectedNode());
        Verifier.match((String)text, (String)pattern, (String)operator);
    }

    public void gdVerifyPath(String pathType, int preAscend, String treePath, String operator, boolean exists) {
        this.m_treeImplClass.gdVerifyPath(pathType, preAscend, treePath, operator, exists);
    }

    public void gdVerifyPathByIndices(String pathType, int preAscend, String treePath, boolean exists) {
        this.m_treeImplClass.gdVerifyPathByIndices(pathType, preAscend, treePath, exists);
    }

    public void gdClick(int count, int button) {
        this.m_treeImplClass.gdClick(count, button);
    }

    private INodePath createIndexNodePath(Integer[] treePath) {
        return new IndexNodePath(treePath);
    }

    private void traverseTreeByPath(INodePath treePath, String pathType, int preAscend, TreeNodeOperation operation) throws StepExecutionException {
        Validate.notNull((Object)treePath);
        Validate.notNull((Object)operation);
        TreeOperationContext context = this.createContext();
        TreeItem startNode = this.getStartNode(pathType, preAscend, context);
        PathBasedTraverser traverser = new PathBasedTraverser((AbstractTreeOperationContext)context, treePath);
        traverser.traversePath(operation, (Object)startNode);
    }

    private int getColumnCount() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getColumnCount", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Integer(TableTreeImplClass.this.m_treeTable.getColumnCount());
            }
        });
    }

    private TreeOperationContext createContext() {
        if (this.getColumnCount() > 0) {
            return new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_treeTable);
        }
        return new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_treeTable);
    }

    private void traverseLastElementByPath(INodePath treePath, String pathType, int preAscend, TreeNodeOperation operation, int column) throws StepExecutionException {
        Validate.notNull((Object)treePath);
        Validate.notNull((Object)operation);
        TableTreeOperationContext context = new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_treeTable, column);
        TreeItem startNode = this.getStartNode(pathType, preAscend, context);
        PathBasedTraverser traverser = new PathBasedTraverser((AbstractTreeOperationContext)context, treePath, new TreeNodeOperationConstraint());
        traverser.traversePath(operation, (Object)startNode);
    }

    private TreeItem getStartNode(String pathType, final int preAscend, final TreeOperationContext context) {
        TreeItem startNode;
        if (pathType.equals("relative")) {
            startNode = (TreeItem)this.getEventThreadQueuer().invokeAndWait("getStartNode", new IRunnable(){

                public Object run() throws StepExecutionException {
                    TreeItem curNode;
                    TreeItem child = curNode = TableTreeImplClass.this.getSelectedNode(context);
                    int i = 0;
                    while (i < preAscend) {
                        if (curNode == null) {
                            TestErrorEvent event = EventFactory.createActionError((String)"TestErrorEvent.TreeNodeNotFound");
                            throw new StepExecutionException("Tree node not found: Parent of " + child.toString(), event);
                        }
                        child = curNode;
                        curNode = curNode.getParentItem();
                        ++i;
                    }
                    return curNode;
                }
            });
        } else if (pathType.equals("absolute")) {
            startNode = null;
        } else {
            throw new StepExecutionException(String.valueOf(pathType) + " is not a valid Path Type", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
        return startNode;
    }

    private TreeItem getSelectedNode(TreeOperationContext context) {
        return (TreeItem)context.getSelectedNode();
    }

    private void selectByPath(String pathType, int preAscend, INodePath objectPath, ClickOptions co, int column) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(co);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, (TreeNodeOperation)expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, (TreeNodeOperation)selectOp, column);
    }

    private String[] splitTextTreePath(String treePath) {
        return StringParsing.splitToArray((String)treePath, (char)'/', (char)'\\', (boolean)true);
    }

    private Integer[] splitIndexTreePath(String treePath) throws StepExecutionException {
        Integer[] indexPath = null;
        String[] path = this.splitTextTreePath(treePath);
        if (path != null) {
            indexPath = new Integer[path.length];
            int i = 0;
            while (i < path.length) {
                indexPath[i] = new Integer(IndexConverter.intValue((String)path[i]));
                ++i;
            }
        }
        return IndexConverter.toImplementationIndices(indexPath);
    }

    private INodePath createStringNodePath(String[] treePath, String operator) {
        return new StringNodePath(treePath, operator);
    }

    private void checkColumnIndex(int index) throws StepExecutionException {
        int numColumns = (Integer)this.getEventThreadQueuer().invokeAndWait("checkColumnIndex", new IRunnable(){

            public Object run() {
                return new Integer(TableTreeImplClass.this.m_treeTable.getColumnCount());
            }
        });
        if ((index < 0 || index >= numColumns) && index != 0) {
            throw new StepExecutionException("Invalid column: " + IndexConverter.toUserIndex((int)index), EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    public void gdPopupByIndexPathAtIndexNode(String treeIndexPath, String popupIndexPath) {
        this.throwUnsupportedAction();
    }

    public void gdPopupByIndexPathAtSelectedNode(String indexPath) {
        this.throwUnsupportedAction();
    }

    public void gdPopupByIndexPathAtTextNode(String treeTextPath, String operator, String popupIndexPath) {
        this.throwUnsupportedAction();
    }

    public void gdPopupByTextPathAtIndexNode(String treeIndexPath, String popupTextPath) {
        this.throwUnsupportedAction();
    }

    public void gdPopupByTextPathAtSelectedNode(String textPath) {
        this.throwUnsupportedAction();
    }

    public void gdPopupByTextPathAtTextNode(String treeTextPath, String operator, String popupTextPath) {
        this.throwUnsupportedAction();
    }

    public void gdVerifyTextAtMousePosition(String pattern, String operator) {
        TreeItem itemAtMousePosition = this.m_treeImplClass.getItemAtMousePosition();
        int column = this.getMouseColumn();
        TableTreeOperationContext context = column != -1 ? new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_treeTable, column) : new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_treeTable);
        Verifier.match((String)context.getRenderedText(itemAtMousePosition), (String)pattern, (String)operator);
    }

    public String gdStoreValueAtMousePosition(String variable) {
        TreeItem itemAtMousePosition = this.m_treeImplClass.getItemAtMousePosition();
        int column = this.getMouseColumn();
        TableTreeOperationContext context = column != -1 ? new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_treeTable, column) : new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_treeTable);
        return context.getRenderedText(itemAtMousePosition);
    }
}

