/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.base.init;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jwt.transformations.api.TransformationService;
import org.eclipse.jwt.transformations.base.TransformationsMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationRegistry {
    private Map<String, TransformationService> transformations = new HashMap<String, TransformationService>();
    private static TransformationRegistry instance = null;

    public static TransformationRegistry getInstance() {
        if (instance == null) {
            instance = new TransformationRegistry();
        }
        return instance;
    }

    private TransformationRegistry() {
    }

    public void addTransformation(String name, TransformationService transformation) {
        if (this.transformations.put(name, transformation) != null) {
            Display display = Display.getCurrent();
            Shell shell = new Shell(display);
            ErrorDialog.openError((Shell)shell, (String)TransformationsMessages.transformationAlreadyExists_title, (String)TransformationsMessages.bind((String)TransformationsMessages.transformationAlreadyExists_details, (Object)name), (IStatus)Status.OK_STATUS);
        }
    }

    public TransformationService getTransformation(String name) {
        return this.transformations.get(name);
    }

    public Set<String> getTransformationsName() {
        return this.transformations.keySet();
    }
}

