/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.pages.overviewPage;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jwt.meta.model.application.Application;
import org.eclipse.jwt.meta.model.application.ApplicationFactory;
import org.eclipse.jwt.meta.model.core.CorePackage;
import org.eclipse.jwt.meta.model.core.Model;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.data.Data;
import org.eclipse.jwt.meta.model.data.DataFactory;
import org.eclipse.jwt.meta.model.organisations.OrganisationsFactory;
import org.eclipse.jwt.meta.model.organisations.Role;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.meta.model.processes.ProcessesFactory;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.dnd.IDropListenerFactory;
import org.eclipse.jwt.we.editors.dnd.internal.DropListenerExtensionPoint;
import org.eclipse.jwt.we.misc.util.FontUtil;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.misc.wizards.NotResizableWizardDialog;
import org.eclipse.jwt.we.misc.wizards.model.CreateApplicationWizard;
import org.eclipse.jwt.we.misc.wizards.model.CreateDataWizard;
import org.eclipse.jwt.we.misc.wizards.model.CreateProcessWizard;
import org.eclipse.jwt.we.misc.wizards.model.CreateRoleWizard;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class WEOverviewSheet
extends ScrolledComposite
implements Adapter {
    private final WEEditor editor;
    private Text nameField;
    private Text authorField;
    private Text versionField;
    private Text modifiedField;
    private Text locationField;
    private StyledText documentationField;
    private Button deleteRoleButton;
    private Button deleteDataButton;
    private Button deleteApplicationButton;
    private Button deleteProcessButton;
    private ArrayList<Scope> scopeList = new ArrayList();
    private Tree roleTree;
    private Tree dataTree;
    private Tree applicationTree;
    private Tree processTree;
    private TreeViewer roleViewer;
    private TreeViewer dataViewer;
    private TreeViewer applicationViewer;
    private TreeViewer processViewer;
    private Object rootPackage;
    private Composite main;

    public WEOverviewSheet(Composite container, WEEditor editor) {
        super(container, 772);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.editor = editor;
        this.rootPackage = editor.getModel();
        if (this.rootPackage instanceof Package) {
            this.collect((Package)this.rootPackage);
        }
        ((EObject)this.rootPackage).eAdapters().add((Object)this);
        this.createConfigPage();
    }

    public void notifyChanged(Notification notification) {
        if (!(this.rootPackage instanceof Model)) {
            return;
        }
        if (notification.getNotifier() instanceof Model) {
            if (notification.getFeatureID(Model.class) == 1) {
                this.nameField.setText(((Model)this.rootPackage).getName());
            }
            if (notification.getFeatureID(Model.class) == 7) {
                this.versionField.setText(((Model)this.rootPackage).getVersion());
            }
            if (notification.getFeatureID(Model.class) == 6) {
                this.authorField.setText(((Model)this.rootPackage).getAuthor());
            }
            if (notification.getFeatureID(Model.class) == 8) {
                this.documentationField.setText(((Model)this.rootPackage).getDescription());
            }
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void reloadOverviewSheet() {
        if (this.rootPackage != null) {
            ((EObject)this.rootPackage).eAdapters().remove((Object)this);
        }
        this.rootPackage = this.editor.getModel();
        if (this.rootPackage instanceof Package) {
            this.collect((Package)this.rootPackage);
        }
        ((EObject)this.rootPackage).eAdapters().add((Object)this);
        this.main.dispose();
        this.main = null;
        this.createConfigPage();
    }

    public void reloadFileInformation() {
        XMIResourceImpl xmiresource = (XMIResourceImpl)this.editor.getEmfEditingDomain().getResourceSet().getResources().get(0);
        String filepath = xmiresource.getURI().toFileString();
        if (xmiresource.getURI().isRelative()) {
            File tempFile = new File(filepath);
            filepath = tempFile.getAbsolutePath();
            tempFile = null;
        }
        if (filepath == null) {
            filepath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + xmiresource.getURI().toPlatformString(false);
        }
        File file = new File(filepath);
        long time = file.lastModified();
        Date date = new Date(time);
        SimpleDateFormat dateformat = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
        this.modifiedField.setText(dateformat.format(date));
        IPath ospath = Path.fromOSString((String)filepath);
        filepath = ospath.toOSString();
        this.locationField.setText(filepath);
    }

    private void createConfigPage() {
        this.main = new Composite((Composite)this, 0);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.main.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        this.main.setLayout((Layout)layout);
        Composite firstRow = new Composite(this.main, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        firstRow.setLayout((Layout)layout);
        GridData data2 = new GridData();
        data2.verticalAlignment = 1;
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        firstRow.setLayoutData((Object)data2);
        Composite secondRow = new Composite(this.main, 0);
        data2 = new GridData();
        data2.verticalAlignment = 4;
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = true;
        secondRow.setLayoutData((Object)data2);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 2;
        layout2.makeColumnsEqualWidth = true;
        secondRow.setLayout((Layout)layout2);
        Composite thirdRow = new Composite(this.main, 0);
        GridData data3 = new GridData();
        data3.verticalAlignment = 4;
        data3.horizontalAlignment = 4;
        data3.grabExcessHorizontalSpace = true;
        data3.grabExcessVerticalSpace = true;
        thirdRow.setLayoutData((Object)data3);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 2;
        layout3.makeColumnsEqualWidth = true;
        thirdRow.setLayout((Layout)layout3);
        Group general = new Group(firstRow, 0);
        general.setText(PluginProperties.configPage_Properties);
        general.setFont(FontUtil.getSystemStyle(1));
        layout3 = new GridLayout();
        layout3.numColumns = 2;
        general.setLayout((Layout)layout3);
        GridData data4 = new GridData();
        data4.verticalAlignment = 4;
        data4.horizontalAlignment = 4;
        data4.grabExcessVerticalSpace = true;
        data4.grabExcessHorizontalSpace = true;
        general.setLayoutData((Object)data4);
        Label nameLabel = new Label((Composite)general, 16384);
        nameLabel.setText(String.valueOf(PluginProperties.configPage_Name) + ":");
        this.nameField = new Text((Composite)general, 2048);
        data4 = new GridData();
        data4.horizontalAlignment = 4;
        data4.grabExcessHorizontalSpace = true;
        this.nameField.setLayoutData((Object)data4);
        if (this.editor.getModel() instanceof Package && ((Package)this.editor.getModel()).getName() != null) {
            this.nameField.setText(((Package)this.editor.getModel()).getName());
        }
        this.nameField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (WEOverviewSheet.this.editor.getModel() instanceof Package && !WEOverviewSheet.this.nameField.getText().equals(((Package)WEOverviewSheet.this.editor.getModel()).getName())) {
                    Command cmd = SetCommand.create((EditingDomain)WEOverviewSheet.this.editor.getEmfEditingDomain(), (Object)WEOverviewSheet.this.editor.getModel(), (Object)CorePackage.Literals.NAMED_ELEMENT__NAME, (Object)WEOverviewSheet.this.nameField.getText());
                    WEOverviewSheet.this.editor.getEmfEditingDomain().getCommandStack().execute(cmd);
                }
            }
        });
        Label authorLabel = new Label((Composite)general, 16384);
        authorLabel.setText(String.valueOf(PluginProperties.configPage_Author) + ":");
        this.authorField = new Text((Composite)general, 2048);
        GridData data5 = new GridData();
        data5.horizontalAlignment = 4;
        data5.grabExcessHorizontalSpace = true;
        this.authorField.setLayoutData((Object)data5);
        if (this.editor.getModel() instanceof Model && ((Model)this.editor.getModel()).getAuthor() != null) {
            this.authorField.setText(((Model)this.editor.getModel()).getAuthor());
        }
        this.authorField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (WEOverviewSheet.this.editor.getModel() instanceof Model && !WEOverviewSheet.this.authorField.getText().equals(((Model)WEOverviewSheet.this.editor.getModel()).getAuthor())) {
                    Command cmd = SetCommand.create((EditingDomain)WEOverviewSheet.this.editor.getEmfEditingDomain(), (Object)WEOverviewSheet.this.editor.getModel(), (Object)CorePackage.Literals.MODEL__AUTHOR, (Object)WEOverviewSheet.this.authorField.getText());
                    WEOverviewSheet.this.editor.getEmfEditingDomain().getCommandStack().execute(cmd);
                }
            }
        });
        Label versionLabel = new Label((Composite)general, 16384);
        versionLabel.setText(String.valueOf(PluginProperties.configPage_VNumber) + ":");
        this.versionField = new Text((Composite)general, 2048);
        GridData data6 = new GridData();
        data6.horizontalAlignment = 4;
        data6.grabExcessHorizontalSpace = true;
        this.versionField.setLayoutData((Object)data6);
        if (this.editor.getModel() instanceof Model && ((Model)this.editor.getModel()).getVersion() != null) {
            this.versionField.setText(((Model)this.editor.getModel()).getVersion());
        }
        this.versionField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (WEOverviewSheet.this.editor.getModel() instanceof Model && !WEOverviewSheet.this.versionField.getText().equals(((Model)WEOverviewSheet.this.editor.getModel()).getVersion())) {
                    Command cmd = SetCommand.create((EditingDomain)WEOverviewSheet.this.editor.getEmfEditingDomain(), (Object)WEOverviewSheet.this.editor.getModel(), (Object)CorePackage.Literals.MODEL__VERSION, (Object)WEOverviewSheet.this.versionField.getText());
                    WEOverviewSheet.this.editor.getEmfEditingDomain().getCommandStack().execute(cmd);
                }
            }
        });
        Label locationLabel = new Label((Composite)general, 16384);
        locationLabel.setText(String.valueOf(PluginProperties.configPage_Location) + ":");
        this.locationField = new Text((Composite)general, 0);
        GridData data7 = new GridData();
        data7.horizontalAlignment = 4;
        data7.grabExcessHorizontalSpace = true;
        this.locationField.setLayoutData((Object)data7);
        this.locationField.setEditable(false);
        Label modifiedLabel = new Label((Composite)general, 16384);
        modifiedLabel.setText(String.valueOf(PluginProperties.configPage_LastModified) + ":");
        this.modifiedField = new Text((Composite)general, 0);
        GridData data8 = new GridData();
        data8.horizontalAlignment = 4;
        data8.grabExcessHorizontalSpace = true;
        this.modifiedField.setLayoutData((Object)data8);
        this.modifiedField.setEditable(false);
        this.reloadFileInformation();
        Group documentation = new Group(firstRow, 0);
        documentation.setFont(FontUtil.getSystemStyle(1));
        documentation.setText(PluginProperties.configPage_Documentation);
        GridLayout layout4 = new GridLayout();
        layout4.numColumns = 1;
        documentation.setLayout((Layout)layout4);
        GridData data9 = new GridData();
        data9.verticalAlignment = 4;
        data9.horizontalAlignment = 4;
        data9.grabExcessVerticalSpace = true;
        data9.grabExcessHorizontalSpace = true;
        documentation.setLayoutData((Object)data9);
        this.documentationField = new StyledText((Composite)documentation, 514);
        this.documentationField.setWordWrap(true);
        GC gc = new GC((Drawable)this.documentationField);
        FontMetrics fm = gc.getFontMetrics();
        GridData data10 = new GridData();
        data10.horizontalAlignment = 4;
        data10.verticalAlignment = 4;
        data10.grabExcessVerticalSpace = true;
        data10.grabExcessHorizontalSpace = true;
        data10.minimumHeight = 8 * fm.getHeight();
        this.documentationField.setLayoutData((Object)data10);
        if (this.editor.getModel() instanceof Model && ((Model)this.editor.getModel()).getDescription() != null) {
            this.documentationField.setText(((Model)this.editor.getModel()).getDescription());
        }
        this.documentationField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (WEOverviewSheet.this.editor.getModel() instanceof Model && !WEOverviewSheet.this.documentationField.getText().equals(((Model)WEOverviewSheet.this.editor.getModel()).getDescription())) {
                    Command cmd = SetCommand.create((EditingDomain)WEOverviewSheet.this.editor.getEmfEditingDomain(), (Object)WEOverviewSheet.this.editor.getModel(), (Object)CorePackage.Literals.MODEL__DESCRIPTION, (Object)WEOverviewSheet.this.documentationField.getText());
                    WEOverviewSheet.this.editor.getEmfEditingDomain().getCommandStack().execute(cmd);
                }
            }
        });
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        Image deleteImage = Plugin.getInstance().getFactoryRegistry().getImageFactory(new Object[0]).getImage(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        Image addRoleImage = Plugin.getInstance().getFactoryRegistry().getImageFactory(new Object[0]).getImage(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createModelTypeImageDescriptor(OrganisationsFactory.eINSTANCE.createRole()));
        Image addDataImage = Plugin.getInstance().getFactoryRegistry().getImageFactory(new Object[0]).getImage(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createModelTypeImageDescriptor(DataFactory.eINSTANCE.createData()));
        Image addAppImage = Plugin.getInstance().getFactoryRegistry().getImageFactory(new Object[0]).getImage(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createModelTypeImageDescriptor(ApplicationFactory.eINSTANCE.createApplication()));
        Image addProcessImage = Plugin.getInstance().getFactoryRegistry().getImageFactory(new Object[0]).getImage(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createModelTypeImageDescriptor(ProcessesFactory.eINSTANCE.createActivity()));
        Group role = new Group(secondRow, 0);
        role.setFont(FontUtil.getSystemStyle(1));
        role.setText(PluginProperties.configPage_Roles);
        GridLayout layout5 = new GridLayout();
        layout5.numColumns = 2;
        role.setLayout((Layout)layout5);
        GridData data11 = new GridData();
        data11.verticalAlignment = 4;
        data11.horizontalAlignment = 4;
        data11.grabExcessVerticalSpace = true;
        data11.grabExcessHorizontalSpace = true;
        role.setLayoutData((Object)data11);
        this.roleTree = new Tree((Composite)role, 4);
        GridData data12 = new GridData();
        data12.grabExcessHorizontalSpace = true;
        data12.grabExcessVerticalSpace = true;
        data12.horizontalAlignment = 4;
        data12.verticalAlignment = 4;
        data12.horizontalSpan = 1;
        data12.verticalSpan = 3;
        data12.minimumHeight = 8 * fm.getHeight();
        this.roleTree.setLayoutData((Object)data12);
        this.roleViewer = new TreeViewer(this.roleTree);
        this.roleViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.editor.getAdapterFactory()));
        this.roleViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.editor.getAdapterFactory()));
        DelegatingDropAdapter roleDropAdapter = new DelegatingDropAdapter();
        for (IDropListenerFactory factory : DropListenerExtensionPoint.getDropListenersFactories()) {
            TransferDropTargetListener dropListener = factory.createWEOutlineDropListerner(this.roleViewer, (Model)this.editor.getModel(), this.editor.getEditDomain());
            if (dropListener == null) continue;
            roleDropAdapter.addDropTargetListener(dropListener);
        }
        this.roleViewer.addDropSupport(23, roleDropAdapter.getTransfers(), (DropTargetListener)roleDropAdapter);
        this.roleViewer.addFilter((ViewerFilter)new RoleFilter());
        this.roleViewer.setInput(this.editor.getModel());
        this.roleViewer.expandAll();
        this.roleViewer.collapseAll();
        this.editor.getSelectionSynchronizer().addSelectionProvider((ISelectionProvider)this.roleViewer);
        MenuManager roleContextMenuManager = new MenuManager();
        roleContextMenuManager.setRemoveAllWhenShown(true);
        roleContextMenuManager.addMenuListener(this.editor.getContextMenuProvider());
        Menu roleContextMenu = roleContextMenuManager.createContextMenu(this.roleViewer.getControl());
        this.roleViewer.getControl().setMenu(roleContextMenu);
        this.editor.getSite().registerContextMenu(roleContextMenuManager, (ISelectionProvider)this.roleViewer);
        ArrayList roleList = this.collectItems(this.roleTree, null);
        int i = 0;
        while (i < roleList.size()) {
            try {
                Object treeItemData = ((TreeItem)roleList.get(i)).getData();
                if (treeItemData instanceof Package && this.findElement((Package)treeItemData, 0)) {
                    this.roleViewer.setExpandedState((Object)((Package)treeItemData), true);
                }
            }
            catch (SWTException sWTException) {}
            ++i;
        }
        Button addRoleButton = new Button((Composite)role, 0x800000);
        addRoleButton.setImage(addRoleImage);
        addRoleButton.setToolTipText(PluginProperties.menu_Role_item);
        GridData data13 = new GridData();
        data13.horizontalAlignment = 0x1000008;
        addRoleButton.setLayoutData((Object)data13);
        addRoleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (WEOverviewSheet.this.editor != null) {
                    CreateRoleWizard wizard = WEOverviewSheet.this.roleTree.getSelectionCount() == 1 && WEOverviewSheet.this.roleTree.getSelection()[0].getData() instanceof Package ? new CreateRoleWizard((Package)WEOverviewSheet.this.roleTree.getSelection()[0].getData()) : new CreateRoleWizard();
                    wizard.init(PlatformUI.getWorkbench(), null);
                    NotResizableWizardDialog dialog = new NotResizableWizardDialog(GeneralHelper.getActiveShell(), (IWizard)wizard);
                    dialog.create();
                    dialog.open();
                }
            }
        });
        this.deleteRoleButton = new Button((Composite)role, 0x800000);
        this.deleteRoleButton.setToolTipText(PluginProperties.configPage_Delete);
        this.deleteRoleButton.setImage(deleteImage);
        data13 = new GridData();
        data13.horizontalAlignment = 0x1000008;
        this.deleteRoleButton.setLayoutData((Object)data13);
        this.deleteRoleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (WEOverviewSheet.this.roleTree.getSelectionCount() > 0) {
                    EditingDomain editingDomain = (EditingDomain)WEOverviewSheet.this.editor.getAdapter(EditingDomain.class);
                    Command cmd = DeleteCommand.create((EditingDomain)editingDomain, (Object)WEOverviewSheet.this.roleTree.getSelection()[0].getData());
                    editingDomain.getCommandStack().execute(cmd);
                    WEOverviewSheet.this.editor.activatePage(WEOverviewSheet.this.editor.getOverviewPageID());
                }
            }
        });
        Group datas = new Group(secondRow, 0);
        datas.setFont(FontUtil.getSystemStyle(1));
        datas.setText(PluginProperties.configPage_Data);
        GridLayout layout6 = new GridLayout();
        layout6.numColumns = 2;
        datas.setLayout((Layout)layout6);
        GridData data14 = new GridData();
        data14.verticalAlignment = 4;
        data14.horizontalAlignment = 4;
        data14.grabExcessVerticalSpace = true;
        data14.grabExcessHorizontalSpace = true;
        datas.setLayoutData((Object)data14);
        this.dataTree = new Tree((Composite)datas, 4);
        GridData data15 = new GridData();
        data15.grabExcessHorizontalSpace = true;
        data15.grabExcessVerticalSpace = true;
        data15.horizontalAlignment = 4;
        data15.verticalAlignment = 4;
        data15.horizontalSpan = 1;
        data15.verticalSpan = 3;
        data15.minimumHeight = 8 * fm.getHeight();
        this.dataTree.setLayoutData((Object)data15);
        this.dataViewer = new TreeViewer(this.dataTree);
        this.dataViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.editor.getAdapterFactory()));
        this.dataViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.editor.getAdapterFactory()));
        DelegatingDropAdapter dataDropAdapter = new DelegatingDropAdapter();
        for (IDropListenerFactory factory : DropListenerExtensionPoint.getDropListenersFactories()) {
            TransferDropTargetListener dropListener = factory.createWEOutlineDropListerner(this.dataViewer, (Model)this.editor.getModel(), this.editor.getEditDomain());
            if (dropListener == null) continue;
            dataDropAdapter.addDropTargetListener(dropListener);
        }
        this.dataViewer.addDropSupport(23, roleDropAdapter.getTransfers(), (DropTargetListener)roleDropAdapter);
        this.dataViewer.addFilter((ViewerFilter)new DataFilter());
        this.dataViewer.setInput(this.editor.getModel());
        this.dataViewer.expandAll();
        this.dataViewer.collapseAll();
        this.editor.getSelectionSynchronizer().addSelectionProvider((ISelectionProvider)this.dataViewer);
        MenuManager dataContextMenuManager = new MenuManager();
        dataContextMenuManager.setRemoveAllWhenShown(true);
        dataContextMenuManager.addMenuListener(this.editor.getContextMenuProvider());
        Menu dataContextMenu = dataContextMenuManager.createContextMenu(this.dataViewer.getControl());
        this.dataViewer.getControl().setMenu(dataContextMenu);
        this.editor.getSite().registerContextMenu(dataContextMenuManager, (ISelectionProvider)this.dataViewer);
        ArrayList dataList = this.collectItems(this.dataTree, null);
        int i2 = 0;
        while (i2 < dataList.size()) {
            try {
                Object treeItemData = ((TreeItem)dataList.get(i2)).getData();
                if (treeItemData instanceof Package && this.findElement((Package)treeItemData, 2)) {
                    this.dataViewer.setExpandedState((Object)((Package)treeItemData), true);
                }
            }
            catch (SWTException sWTException) {}
            ++i2;
        }
        Button addDataButton = new Button((Composite)datas, 0x800000);
        addDataButton.setToolTipText(PluginProperties.menu_Data_item);
        addDataButton.setImage(addDataImage);
        GridData data16 = new GridData();
        data16.horizontalAlignment = 0x1000008;
        addDataButton.setLayoutData((Object)data16);
        addDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (WEOverviewSheet.this.editor != null) {
                    CreateDataWizard wizard = WEOverviewSheet.this.dataTree.getSelectionCount() == 1 && WEOverviewSheet.this.dataTree.getSelection()[0].getData() instanceof Package ? new CreateDataWizard((Package)WEOverviewSheet.this.dataTree.getSelection()[0].getData()) : new CreateDataWizard();
                    wizard.init(PlatformUI.getWorkbench(), null);
                    NotResizableWizardDialog dialog = new NotResizableWizardDialog(GeneralHelper.getActiveShell(), (IWizard)wizard);
                    dialog.create();
                    dialog.open();
                }
            }
        });
        this.deleteDataButton = new Button((Composite)datas, 0x800000);
        this.deleteDataButton.setToolTipText(PluginProperties.configPage_Delete);
        this.deleteDataButton.setImage(deleteImage);
        data16 = new GridData();
        data16.horizontalAlignment = 4;
        this.deleteDataButton.setLayoutData((Object)data16);
        this.deleteDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (WEOverviewSheet.this.dataTree.getSelectionCount() > 0) {
                    EditingDomain editingDomain = (EditingDomain)WEOverviewSheet.this.editor.getAdapter(EditingDomain.class);
                    Command cmd = DeleteCommand.create((EditingDomain)editingDomain, (Object)WEOverviewSheet.this.dataTree.getSelection()[0].getData());
                    editingDomain.getCommandStack().execute(cmd);
                    WEOverviewSheet.this.editor.activatePage(WEOverviewSheet.this.editor.getOverviewPageID());
                }
            }
        });
        Group application = new Group(thirdRow, 0);
        application.setFont(FontUtil.getSystemStyle(1));
        application.setText(PluginProperties.configPage_Application);
        GridLayout layout7 = new GridLayout();
        layout7.numColumns = 2;
        application.setLayout((Layout)layout7);
        GridData data17 = new GridData();
        data17.verticalAlignment = 4;
        data17.horizontalAlignment = 4;
        data17.grabExcessVerticalSpace = true;
        data17.grabExcessHorizontalSpace = true;
        application.setLayoutData((Object)data17);
        this.applicationTree = new Tree((Composite)application, 4);
        GridData data18 = new GridData();
        data18.grabExcessHorizontalSpace = true;
        data18.grabExcessVerticalSpace = true;
        data18.horizontalAlignment = 4;
        data18.verticalAlignment = 4;
        data18.horizontalSpan = 1;
        data18.verticalSpan = 3;
        data18.minimumHeight = 8 * fm.getHeight();
        this.applicationTree.setLayoutData((Object)data18);
        this.applicationViewer = new TreeViewer(this.applicationTree);
        this.applicationViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.editor.getAdapterFactory()));
        this.applicationViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.editor.getAdapterFactory()));
        DelegatingDropAdapter applicationDropAdapter = new DelegatingDropAdapter();
        for (IDropListenerFactory factory : DropListenerExtensionPoint.getDropListenersFactories()) {
            TransferDropTargetListener dropListener = factory.createWEOutlineDropListerner(this.applicationViewer, (Model)this.editor.getModel(), this.editor.getEditDomain());
            if (dropListener == null) continue;
            applicationDropAdapter.addDropTargetListener(dropListener);
        }
        this.applicationViewer.addDropSupport(23, roleDropAdapter.getTransfers(), (DropTargetListener)roleDropAdapter);
        this.applicationViewer.addFilter((ViewerFilter)new ApplicationFilter());
        this.applicationViewer.setInput(this.editor.getModel());
        this.applicationViewer.expandAll();
        this.applicationViewer.collapseAll();
        this.editor.getSelectionSynchronizer().addSelectionProvider((ISelectionProvider)this.applicationViewer);
        MenuManager applicationContextMenuManager = new MenuManager();
        applicationContextMenuManager.setRemoveAllWhenShown(true);
        applicationContextMenuManager.addMenuListener(this.editor.getContextMenuProvider());
        Menu applicationContextMenu = applicationContextMenuManager.createContextMenu(this.applicationViewer.getControl());
        this.applicationViewer.getControl().setMenu(applicationContextMenu);
        this.editor.getSite().registerContextMenu(applicationContextMenuManager, (ISelectionProvider)this.applicationViewer);
        ArrayList applicationList = this.collectItems(this.applicationTree, null);
        int i3 = 0;
        while (i3 < applicationList.size()) {
            try {
                Object treeItemData = ((TreeItem)applicationList.get(i3)).getData();
                if (treeItemData instanceof Package && this.findElement((Package)treeItemData, 1)) {
                    this.applicationViewer.setExpandedState((Object)((Package)treeItemData), true);
                }
            }
            catch (SWTException sWTException) {}
            ++i3;
        }
        Button addApplicationButton = new Button((Composite)application, 0x800000);
        addApplicationButton.setToolTipText(PluginProperties.menu_Application_item);
        addApplicationButton.setImage(addAppImage);
        GridData data19 = new GridData();
        data19.horizontalAlignment = 0x1000008;
        addApplicationButton.setLayoutData((Object)data19);
        addApplicationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (WEOverviewSheet.this.editor != null) {
                    CreateApplicationWizard wizard = WEOverviewSheet.this.applicationTree.getSelectionCount() == 1 && WEOverviewSheet.this.applicationTree.getSelection()[0].getData() instanceof Package ? new CreateApplicationWizard((Package)WEOverviewSheet.this.applicationTree.getSelection()[0].getData()) : new CreateApplicationWizard();
                    wizard.init(PlatformUI.getWorkbench(), null);
                    NotResizableWizardDialog dialog = new NotResizableWizardDialog(GeneralHelper.getActiveShell(), (IWizard)wizard);
                    dialog.create();
                    dialog.open();
                }
            }
        });
        this.deleteApplicationButton = new Button((Composite)application, 0x800000);
        this.deleteApplicationButton.setToolTipText(PluginProperties.configPage_Delete);
        this.deleteApplicationButton.setImage(deleteImage);
        data19 = new GridData();
        data19.horizontalAlignment = 0x1000008;
        this.deleteApplicationButton.setLayoutData((Object)data19);
        this.deleteApplicationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (WEOverviewSheet.this.applicationTree.getSelectionCount() > 0) {
                    EditingDomain editingDomain = (EditingDomain)WEOverviewSheet.this.editor.getAdapter(EditingDomain.class);
                    Command cmd = DeleteCommand.create((EditingDomain)editingDomain, (Object)WEOverviewSheet.this.applicationTree.getSelection()[0].getData());
                    editingDomain.getCommandStack().execute(cmd);
                    WEOverviewSheet.this.editor.activatePage(WEOverviewSheet.this.editor.getOverviewPageID());
                }
            }
        });
        Group process = new Group(thirdRow, 0);
        process.setFont(FontUtil.getSystemStyle(1));
        process.setText(PluginProperties.configPage_Activity);
        GridLayout layout8 = new GridLayout();
        layout8.numColumns = 2;
        process.setLayout((Layout)layout8);
        GridData data20 = new GridData();
        data20.verticalAlignment = 4;
        data20.horizontalAlignment = 4;
        data20.grabExcessVerticalSpace = true;
        data20.grabExcessHorizontalSpace = true;
        process.setLayoutData((Object)data20);
        this.processTree = new Tree((Composite)process, 4);
        GridData data21 = new GridData();
        data21.grabExcessHorizontalSpace = true;
        data21.grabExcessVerticalSpace = true;
        data21.horizontalAlignment = 4;
        data21.verticalAlignment = 4;
        data21.horizontalSpan = 1;
        data21.verticalSpan = 3;
        data21.minimumHeight = 8 * fm.getHeight();
        this.processTree.setLayoutData((Object)data21);
        this.processViewer = new TreeViewer(this.processTree);
        this.processViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.editor.getAdapterFactory()));
        this.processViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.editor.getAdapterFactory()));
        DelegatingDropAdapter processDropAdapter = new DelegatingDropAdapter();
        for (IDropListenerFactory factory : DropListenerExtensionPoint.getDropListenersFactories()) {
            TransferDropTargetListener dropListener = factory.createWEOutlineDropListerner(this.processViewer, (Model)this.editor.getModel(), this.editor.getEditDomain());
            if (dropListener == null) continue;
            processDropAdapter.addDropTargetListener(dropListener);
        }
        this.processViewer.addDropSupport(23, roleDropAdapter.getTransfers(), (DropTargetListener)roleDropAdapter);
        this.processViewer.addFilter((ViewerFilter)new ProcessFilter());
        this.processViewer.setInput(this.editor.getModel());
        this.processViewer.expandAll();
        this.processViewer.collapseAll();
        this.editor.getSelectionSynchronizer().addSelectionProvider((ISelectionProvider)this.processViewer);
        MenuManager processContextMenuManager = new MenuManager();
        processContextMenuManager.setRemoveAllWhenShown(true);
        processContextMenuManager.addMenuListener(this.editor.getContextMenuProvider());
        Menu processContextMenu = processContextMenuManager.createContextMenu(this.processViewer.getControl());
        this.processViewer.getControl().setMenu(processContextMenu);
        this.editor.getSite().registerContextMenu(processContextMenuManager, (ISelectionProvider)this.processViewer);
        this.processTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                WEOverviewSheet.this.editor.openActivityInNewPage((Activity)WEOverviewSheet.this.processTree.getSelection()[0].getData());
            }
        });
        ArrayList processList = this.collectItems(this.processTree, null);
        int i4 = 0;
        while (i4 < processList.size()) {
            try {
                Object treeItemData = ((TreeItem)processList.get(i4)).getData();
                if (treeItemData instanceof Package && this.findElement((Package)treeItemData, 3)) {
                    this.processViewer.setExpandedState((Object)((Package)treeItemData), true);
                }
            }
            catch (SWTException sWTException) {}
            ++i4;
        }
        Button addProcessButton = new Button((Composite)process, 0x800000);
        addProcessButton.setToolTipText(PluginProperties.menu_Process_item);
        addProcessButton.setImage(addProcessImage);
        GridData data22 = new GridData();
        data22.horizontalAlignment = 0x1000008;
        addProcessButton.setLayoutData((Object)data22);
        addProcessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (WEOverviewSheet.this.editor != null) {
                    CreateProcessWizard wizard = WEOverviewSheet.this.processTree.getSelectionCount() == 1 && WEOverviewSheet.this.processTree.getSelection()[0].getData() instanceof Package ? new CreateProcessWizard((Package)WEOverviewSheet.this.processTree.getSelection()[0].getData()) : new CreateProcessWizard();
                    wizard.init(PlatformUI.getWorkbench(), null);
                    NotResizableWizardDialog dialog = new NotResizableWizardDialog(GeneralHelper.getActiveShell(), (IWizard)wizard);
                    dialog.create();
                    dialog.open();
                }
            }
        });
        this.deleteProcessButton = new Button((Composite)process, 0x800000);
        this.deleteProcessButton.setToolTipText(PluginProperties.configPage_Delete);
        this.deleteProcessButton.setImage(deleteImage);
        data22 = new GridData();
        data22.horizontalAlignment = 0x1000008;
        this.deleteProcessButton.setLayoutData((Object)data22);
        this.deleteProcessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (WEOverviewSheet.this.processTree.getSelectionCount() > 0) {
                    EditingDomain editingDomain = (EditingDomain)WEOverviewSheet.this.editor.getAdapter(EditingDomain.class);
                    Command cmd = DeleteCommand.create((EditingDomain)editingDomain, (Object)WEOverviewSheet.this.processTree.getSelection()[0].getData());
                    editingDomain.getCommandStack().execute(cmd);
                    WEOverviewSheet.this.editor.activatePage(WEOverviewSheet.this.editor.getOverviewPageID());
                }
            }
        });
        this.setContent((Control)this.main);
        this.main.pack();
    }

    private ArrayList collectItems(Tree tree, TreeItem item) {
        int i;
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        if (tree != null) {
            i = 0;
            while (i < tree.getItemCount()) {
                result.add(tree.getItem(i));
                ++i;
            }
        } else {
            i = 0;
            while (i < item.getItemCount()) {
                result.add(item.getItem(i));
                ++i;
            }
        }
        i = 0;
        while (i < result.size()) {
            result.addAll(this.collectItems(null, (TreeItem)result.get(i)));
            ++i;
        }
        return result;
    }

    private boolean findElement(Package pack, int type) {
        Iterator iterator = pack.getElements().iterator();
        while (iterator.hasNext()) {
            switch (type) {
                case 0: {
                    if (!(iterator.next() instanceof Role)) break;
                    return true;
                }
                case 1: {
                    if (!(iterator.next() instanceof Application)) break;
                    return true;
                }
                case 2: {
                    if (!(iterator.next() instanceof Data)) break;
                    return true;
                }
                case 3: {
                    if (!(iterator.next() instanceof Scope)) break;
                    return true;
                }
            }
        }
        boolean elementInSubpackage = false;
        Iterator iterator2 = pack.getSubpackages().iterator();
        while (iterator2.hasNext()) {
            elementInSubpackage |= this.findElement((Package)iterator2.next(), type);
        }
        return elementInSubpackage;
    }

    private void collect(Package pack) {
        if (pack.getElements().size() != 0) {
            this.searchPackage(pack);
        }
        if (pack.getSubpackages().size() != 0) {
            EList subPack = pack.getSubpackages();
            int i = 0;
            while (i < subPack.size()) {
                this.collect((Package)subPack.get(i));
                ++i;
            }
        }
    }

    private void searchPackage(Package pack) {
        EList elements = pack.getElements();
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i) instanceof Scope) {
                this.scopeList.add((Scope)elements.get(i));
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.rootPackage != null) {
            ((EObject)this.rootPackage).eAdapters().remove((Object)this);
        }
        this.nameField.dispose();
        this.authorField.dispose();
        this.versionField.dispose();
        this.modifiedField.dispose();
        this.documentationField.dispose();
        this.deleteRoleButton.dispose();
        this.deleteDataButton.dispose();
        this.deleteApplicationButton.dispose();
        this.deleteProcessButton.dispose();
        this.scopeList.clear();
        this.editor.getSelectionSynchronizer().removeSelectionProvider((ISelectionProvider)this.dataViewer);
        this.editor.getSelectionSynchronizer().removeSelectionProvider((ISelectionProvider)this.roleViewer);
        this.editor.getSelectionSynchronizer().removeSelectionProvider((ISelectionProvider)this.processViewer);
        this.editor.getSelectionSynchronizer().removeSelectionProvider((ISelectionProvider)this.applicationViewer);
        this.roleTree.dispose();
        this.dataTree.dispose();
        this.applicationTree.dispose();
        this.processTree.dispose();
        this.roleViewer = null;
        this.dataViewer = null;
        this.applicationViewer = null;
        this.processViewer = null;
        this.main.dispose();
        this.main = null;
        super.dispose();
    }

    class ApplicationFilter
    extends ViewerFilter {
        ApplicationFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Application) {
                return true;
            }
            return element instanceof Package;
        }
    }

    class CaseInsensitiveComparator
    implements Comparator {
        CaseInsensitiveComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1.toString().toUpperCase();
            String s2 = o2.toString().toUpperCase();
            return s1.compareTo(s2);
        }
    }

    class DataFilter
    extends ViewerFilter {
        DataFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Data) {
                return true;
            }
            return element instanceof Package;
        }
    }

    class ProcessFilter
    extends ViewerFilter {
        ProcessFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Activity) {
                return true;
            }
            return element instanceof Package;
        }
    }

    class RoleFilter
    extends ViewerFilter {
        RoleFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Role) {
                return true;
            }
            return element instanceof Package;
        }
    }
}

