/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.guards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jwt.meta.model.data.Data;
import org.eclipse.jwt.meta.model.processes.GuardSpecification;
import org.eclipse.jwt.meta.model.processes.OperationType;
import org.eclipse.jwt.meta.model.processes.ProcessesPackage;
import org.eclipse.jwt.we.misc.guards.BooleanConnector;
import org.eclipse.jwt.we.misc.guards.BooleanParserState;
import org.eclipse.jwt.we.misc.guards.NotaFormulaException;
import org.eclipse.jwt.we.misc.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringtoTreeParser {
    Logger logger = Logger.getLogger(StringtoTreeParser.class);
    private static final String AND = "&";
    private static final String OR = "|";
    private static final String L = "<";
    private static final String IS = "=";
    private static final String G = ">";
    private static final String OB = "(";
    private static final String CB = ")";
    private static final String NOT = "!";
    private static final String[] allowedSigns = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "\u00ef\u00bf\u00bd", "\u00ef\u00bf\u00bd", "\u00ef\u00bf\u00bd", "<", "=", ">", "(", ")", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ".", "&", "|", "!"};
    private GuardSpecification rootnode;
    private List<Data> datalist;

    public StringtoTreeParser(String formula, List<Data> datalist) throws NotaFormulaException {
        this.datalist = datalist;
        formula = formula.replaceAll(" ", "");
        StringtoTreeParser.isCorrectSyntax(formula);
        if (formula.length() > 0) {
            while (formula.substring(0, 1).equals(OB)) {
                int index = StringtoTreeParser.searchClosingBracket(formula, 0);
                if (index == formula.length() - 1) {
                    formula = formula.substring(1);
                    formula = formula.substring(0, formula.length() - 1);
                    continue;
                }
                if (index >= 0) break;
                throw new NotaFormulaException(0, 0);
            }
        }
        StringBuilder strb = new StringBuilder();
        ArrayList<Object> objects = new ArrayList<Object>();
        BooleanParserState ps = BooleanParserState.None;
        int i = 0;
        while (i < formula.length()) {
            String sign = formula.substring(i, i + 1);
            if (sign.equals(OB)) {
                int getclosingbracket = StringtoTreeParser.searchClosingBracket(formula, i);
                if (getclosingbracket < 0) {
                    throw new NotaFormulaException(i, 0);
                }
                String term = formula.substring(i + 1, getclosingbracket);
                if (!strb.toString().equals("")) {
                    objects.add(strb.toString());
                    strb.delete(0, strb.length());
                    if (ps != BooleanParserState.ReadLogicalAnd && ps != BooleanParserState.ReadLogicalOr) {
                        throw new NotaFormulaException(0, 5);
                    }
                    objects.add(new BooleanConnector(ps));
                }
                objects.add(new StringtoTreeParser(term, datalist));
                i = getclosingbracket;
                ps = BooleanParserState.ReadOpeningBracket;
            } else if (sign.equals(NOT)) {
                ps = BooleanParserState.ReadNot;
            } else if (sign.equals(IS)) {
                ps = ps == BooleanParserState.ReadIs ? BooleanParserState.ReadEquals : (ps == BooleanParserState.ReadLower ? BooleanParserState.ReadLowerEquals : (ps == BooleanParserState.ReadGreater ? BooleanParserState.ReadGreaterEquals : (ps == BooleanParserState.ReadNot ? BooleanParserState.ReadUnequal : BooleanParserState.ReadIs)));
            } else if (sign.equals(L)) {
                ps = BooleanParserState.ReadLower;
            } else if (sign.equals(G)) {
                ps = BooleanParserState.ReadGreater;
            } else if (sign.equals(AND)) {
                ps = ps == BooleanParserState.ReadAnd ? BooleanParserState.ReadLogicalAnd : BooleanParserState.ReadAnd;
            } else if (sign.equals(OR)) {
                ps = ps == BooleanParserState.ReadOr ? BooleanParserState.ReadLogicalOr : BooleanParserState.ReadOr;
            } else {
                if (ps != BooleanParserState.ReadSign) {
                    if (ps != BooleanParserState.None) {
                        String buffer = strb.toString();
                        if (!buffer.equals("")) {
                            objects.add(buffer);
                        }
                        objects.add(new BooleanConnector(ps));
                    }
                    strb.delete(0, strb.length());
                }
                strb.append(sign);
                ps = BooleanParserState.ReadSign;
            }
            ++i;
        }
        if (ps == BooleanParserState.ReadSign) {
            objects.add(strb.toString());
        }
        this.rootnode = null;
        GuardSpecification currentnode = null;
        GuardSpecification ornode = null;
        GuardSpecification andnode = null;
        GuardSpecification lastnode = null;
        if (objects.size() >= 3) {
            int i2 = 0;
            while (i2 < objects.size() - 2) {
                if (objects.get(i2 + 1) instanceof BooleanConnector) {
                    BooleanConnector ops = (BooleanConnector)objects.get(i2 + 1);
                    if (ops.getOperator() == BooleanParserState.ReadLogicalAnd || ops.getOperator() == BooleanParserState.ReadLogicalOr) {
                        StringtoTreeParser stp;
                        if (ops.getOperator() == BooleanParserState.ReadLogicalAnd) {
                            if (andnode == null) {
                                andnode = this.createnewGuardSpec(null, ops.getOperator(), null);
                                if (ornode == null) {
                                    this.rootnode = andnode;
                                } else if (this.rootnode == andnode || this.rootnode == ornode) {
                                    this.rootnode = this.createnewGuardSpec(null, BooleanParserState.ReadLogicalAnd, null);
                                    this.rootnode.getSubSpecification().add((Object)andnode);
                                    this.rootnode.getSubSpecification().add((Object)ornode);
                                }
                            }
                            currentnode = andnode;
                        } else {
                            if (ornode == null) {
                                ornode = this.createnewGuardSpec(null, ops.getOperator(), null);
                                if (andnode == null) {
                                    this.rootnode = ornode;
                                } else if (this.rootnode == andnode || this.rootnode == ornode) {
                                    this.rootnode = this.createnewGuardSpec(null, BooleanParserState.ReadLogicalAnd, null);
                                    this.rootnode.getSubSpecification().add((Object)andnode);
                                    this.rootnode.getSubSpecification().add((Object)ornode);
                                }
                            }
                            currentnode = ornode;
                        }
                        if (lastnode != null) {
                            currentnode.getSubSpecification().add(lastnode);
                            lastnode = null;
                        }
                        if (objects.get(i2) instanceof StringtoTreeParser) {
                            stp = (StringtoTreeParser)objects.get(i2);
                            currentnode.getSubSpecification().add((Object)stp.getRootNode());
                        } else if (objects.get(i2 + 2) instanceof StringtoTreeParser) {
                            stp = (StringtoTreeParser)objects.get(i2 + 2);
                            currentnode.getSubSpecification().add((Object)stp.getRootNode());
                        }
                    } else if (objects.get(i2) instanceof String && objects.get(i2 + 2) instanceof String) {
                        lastnode = this.createnewGuardSpec((String)objects.get(i2), ops.getOperator(), (String)objects.get(i2 + 2));
                        if (currentnode != null) {
                            currentnode.getSubSpecification().add((Object)lastnode);
                            lastnode = null;
                        }
                        if (this.rootnode == null) {
                            this.rootnode = lastnode;
                        }
                    } else {
                        throw new NotaFormulaException(0, 5);
                    }
                }
                i2 += 2;
            }
        } else {
            throw new NotaFormulaException(0, 4);
        }
    }

    private GuardSpecification createnewGuardSpec(String attribute, BooleanParserState op, String value) throws NotaFormulaException {
        GuardSpecification node = (GuardSpecification)EcoreUtil.create((EClass)ProcessesPackage.Literals.GUARD_SPECIFICATION);
        String[] attrparts = new String[]{""};
        if (attribute != null) {
            attrparts = attribute.split("[.]");
        }
        if (attrparts.length == 0) {
            node.setAttribute(attribute);
        }
        if (attrparts.length == 1) {
            node.setAttribute(attrparts[0]);
        } else if (attrparts.length == 2) {
            node.setData(this.getData(attrparts[0]));
            node.setAttribute(attrparts[1]);
        } else {
            throw new NotaFormulaException(0, 6);
        }
        StringtoTreeParser.setOperationinGuardSpec(node, op);
        node.setValue(value);
        return node;
    }

    private Data getData(String name) {
        int i = 0;
        while (i < this.datalist.size()) {
            Data d = this.datalist.get(i);
            String dataname = d.getName().replaceAll(" ", "");
            if (dataname.toLowerCase().equals(name.toLowerCase())) {
                return d;
            }
            ++i;
        }
        return null;
    }

    private static void setOperationinGuardSpec(GuardSpecification gs, BooleanParserState bs) throws NotaFormulaException {
        switch (bs) {
            case ReadLower: {
                gs.setSubSpecificationConnector(null);
                gs.setOperation(OperationType.LOWER_LITERAL);
                break;
            }
            case ReadLowerEquals: {
                gs.setSubSpecificationConnector(null);
                gs.setOperation(OperationType.LOWER_EQUALS_LITERAL);
                break;
            }
            case ReadGreater: {
                gs.setSubSpecificationConnector(null);
                gs.setOperation(OperationType.GREATER_LITERAL);
                break;
            }
            case ReadGreaterEquals: {
                gs.setSubSpecificationConnector(null);
                gs.setOperation(OperationType.GREATE_EQUALS_LITERAL);
                break;
            }
            case ReadEquals: {
                gs.setSubSpecificationConnector(null);
                gs.setOperation(OperationType.EQUALS_LITERAL);
                break;
            }
            case ReadUnequal: {
                gs.setSubSpecificationConnector(null);
                gs.setOperation(OperationType.UN_EQUALS_LITERAL);
                break;
            }
            case ReadLogicalAnd: {
                gs.setOperation(null);
                gs.setSubSpecificationConnector(org.eclipse.jwt.meta.model.processes.BooleanConnector.AND_LITERAL);
                break;
            }
            case ReadLogicalOr: {
                gs.setOperation(null);
                gs.setSubSpecificationConnector(org.eclipse.jwt.meta.model.processes.BooleanConnector.XOR_LITERAL);
                break;
            }
            default: {
                throw new NotaFormulaException(0, 3);
            }
        }
    }

    public static void isCorrectSyntax(String term) throws NotaFormulaException {
        int i = 0;
        while (i < term.length()) {
            boolean found = false;
            int i2 = 0;
            while (i2 < allowedSigns.length) {
                if (allowedSigns[i2].equals(term.substring(i, i + 1).toLowerCase())) {
                    found = true;
                    break;
                }
                ++i2;
            }
            if (!found) {
                throw new NotaFormulaException(i, 1);
            }
            ++i;
        }
        int openingbrackets = 0;
        int closingbrackets = 0;
        int i2 = 0;
        while (i2 < term.length()) {
            String substr = term.substring(i2, i2 + 1);
            if (substr.equals(OB)) {
                ++openingbrackets;
            } else if (substr.equals(CB)) {
                ++closingbrackets;
            }
            ++i2;
        }
        if (openingbrackets != closingbrackets) {
            throw new NotaFormulaException(0, 2);
        }
    }

    public GuardSpecification getRootNode() {
        return this.rootnode;
    }

    private static int searchClosingBracket(String formula, int startindex) {
        int countbrackets = 0;
        while (startindex < formula.length()) {
            if (formula.substring(startindex, startindex + 1).equals(OB)) {
                ++countbrackets;
            }
            if (formula.substring(startindex, startindex + 1).equals(CB)) {
                --countbrackets;
            }
            if (countbrackets == 0) {
                return startindex;
            }
            ++startindex;
        }
        return -1;
    }
}

