/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.parser.format;

import com.naef.jnlua.LuaRuntimeException;
import com.naef.jnlua.LuaState;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.koneki.ldt.metalua.MetaluaStateFactory;
import org.eclipse.koneki.ldt.module.AbstractLuaModule;
import org.eclipse.koneki.ldt.parser.Activator;
import org.eclipse.koneki.ldt.parser.format.Messages;

public final class LuaFormatterModule
extends AbstractLuaModule {
    public static final String FORMATTER_PATH = "/script/external";
    public static final String FORMATTER_LIB_NAME = "luaformatter";
    public static final String INDENTATION_FUNTION = "indentCode";

    public int depth(String source, int offset) {
        LuaState lua = this.loadLuaModule();
        this.pushLuaModule(lua);
        lua.getField(-1, "indentLevel");
        lua.pushString(source);
        lua.pushInteger(offset);
        try {
            lua.call(2, 1);
        }
        catch (LuaRuntimeException e) {
            Activator.logWarning(Messages.LuaSourceFormatDepthError, e);
            return 0;
        }
        int result = lua.toInteger(-1);
        lua.close();
        return result > 0 ? result - 1 : result;
    }

    public String indent(String source, String delimiter, String tabulation, boolean indentInTable, int originalIndentationLevel) {
        LuaState lua = this.loadLuaModule();
        this.pushLuaModule(lua);
        lua.getField(-1, INDENTATION_FUNTION);
        lua.pushString(source);
        lua.pushString(delimiter);
        lua.pushString(tabulation);
        lua.pushInteger(originalIndentationLevel);
        lua.pushBoolean(indentInTable);
        try {
            lua.call(5, 1);
        }
        catch (LuaRuntimeException e) {
            Activator.logWarning(Messages.LuaSourceFormatIndentationError, e);
            return source;
        }
        String formattedCode = lua.toString(-1);
        lua.close();
        return formattedCode;
    }

    public String indent(String source, String delimiter, int tabSize, int indentationSize, boolean indentInTable, int originalIndentationLevel) {
        LuaState lua = this.loadLuaModule();
        this.pushLuaModule(lua);
        lua.getField(-1, INDENTATION_FUNTION);
        lua.pushString(source);
        lua.pushString(delimiter);
        lua.pushInteger(tabSize);
        lua.pushInteger(indentationSize);
        lua.pushInteger(originalIndentationLevel);
        lua.pushBoolean(indentInTable);
        try {
            lua.call(6, 1);
        }
        catch (LuaRuntimeException e) {
            Activator.logWarning(Messages.LuaSourceFormatIndentationError, e);
            return source;
        }
        String formattedCode = lua.toString(-1);
        lua.close();
        return formattedCode;
    }

    @Override
    protected List<String> getLuaSourcePaths() {
        ArrayList<String> sourcepaths = new ArrayList<String>();
        sourcepaths.add(FORMATTER_PATH);
        return sourcepaths;
    }

    @Override
    protected List<String> getLuacSourcePaths() {
        return null;
    }

    @Override
    protected LuaState createLuaState() {
        return MetaluaStateFactory.newLuaState();
    }

    @Override
    protected String getPluginID() {
        return "org.eclipse.koneki.ldt.parser";
    }

    @Override
    protected String getModuleName() {
        return FORMATTER_LIB_NAME;
    }
}

