/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.integration.admin.osgijmx;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.libra.framework.editor.integration.admin.osgijmx.AbstractOSGiJMXFrameworkAdmin;
import org.eclipse.libra.framework.editor.integration.admin.osgijmx.Messages;
import org.eclipse.libra.framework.editor.integration.internal.IntegrationPlugin;

public class LaunchOSGiJMXFrameworkAdmin
extends AbstractOSGiJMXFrameworkAdmin {
    private ILaunch launch;

    public LaunchOSGiJMXFrameworkAdmin(ILaunch launch) {
        this.launch = launch;
    }

    protected String getHost() throws CoreException {
        return "localhost";
    }

    protected String getPort() throws CoreException {
        return LaunchOSGiJMXFrameworkAdmin.getJmxPort(this.launch);
    }

    public static String getJmxPort(ILaunch launch) throws CoreException {
        String[] vmArgs;
        String rawVMArgs = IntegrationPlugin.getProcess(launch).getAttribute(IProcess.ATTR_CMDLINE);
        if (rawVMArgs == null) {
            throw IntegrationPlugin.newCoreException(Messages.OSGiJMXFrameworkAdmin_CannotGetCmdLineArgs);
        }
        String port = null;
        String[] stringArray = vmArgs = DebugPlugin.parseArguments((String)rawVMArgs);
        int n = vmArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith("-Dcom.sun.management.jmxremote.port=")) {
                int index = arg.indexOf(61);
                port = arg.substring(index + 1).trim();
            }
            ++n2;
        }
        if (port == null) {
            throw IntegrationPlugin.newCoreException(Messages.OSGiJMXFrameworkAdmin_JmxRemoteNotConfigured);
        }
        return port;
    }
}

