/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.ICreateSessionDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TargetNodeComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionGroup;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.IRemoteSystemProxy;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateSessionDialog
extends Dialog
implements ICreateSessionDialog {
    public static final String CREATE_SESSION_ICON_FILE = "icons/elcl16/add_button.gif";
    private Composite fDialogComposite = null;
    private Text fSessionNameText = null;
    private Text fSessionPathText = null;
    private TraceSessionGroup fParent = null;
    private String fSessionName = null;
    private String fSessionPath = null;
    private boolean fIsDefaultPath = true;

    public CreateSessionDialog(Shell shell) {
        super(shell);
        this.setShellStyle(16);
    }

    @Override
    public String getSessionName() {
        return this.fSessionName;
    }

    @Override
    public String getSessionPath() {
        return this.fSessionPath;
    }

    @Override
    public boolean isDefaultSessionPath() {
        return this.fIsDefaultPath;
    }

    @Override
    public void setTraceSessionGroup(TraceSessionGroup group) {
        this.fParent = group;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_CreateSessionDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(CREATE_SESSION_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        this.fDialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, true);
        this.fDialogComposite.setLayout((Layout)layout);
        this.fDialogComposite.setLayoutData((Object)new GridData(1808));
        Label sessionNameLabel = new Label(this.fDialogComposite, 131072);
        sessionNameLabel.setText(Messages.TraceControl_CreateSessionNameLabel);
        this.fSessionNameText = new Text(this.fDialogComposite, 0);
        this.fSessionNameText.setToolTipText(Messages.TraceControl_CreateSessionNameTooltip);
        Label sessionPath = new Label(this.fDialogComposite, 131072);
        sessionPath.setText(Messages.TraceControl_CreateSessionPathLabel);
        this.fSessionPathText = new Text(this.fDialogComposite, 0);
        this.fSessionPathText.setToolTipText(Messages.TraceControl_CreateSessionPathTooltip);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        this.fSessionNameText.setLayoutData((Object)data);
        this.fSessionPathText.setLayoutData((Object)data);
        this.getShell().setMinimumSize(new Point(300, 150));
        return this.fDialogComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    protected void okPressed() {
        this.fSessionName = this.fSessionNameText.getText();
        this.fSessionPath = this.fSessionPathText.getText();
        if (!"".equals(this.fSessionPath)) {
            TargetNodeComponent node = (TargetNodeComponent)this.fParent.getParent();
            IRemoteSystemProxy proxy = node.getRemoteSystemProxy();
            IFileServiceSubSystem fsss = proxy.getFileServiceSubSystem();
            if (fsss != null) {
                try {
                    IRemoteFile remoteFolder = fsss.getRemoteFileObject(this.fSessionPath, (IProgressMonitor)new NullProgressMonitor());
                    if (remoteFolder.exists()) {
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_CreateSessionDialogTitle, (String)(String.valueOf(Messages.TraceControl_SessionPathAlreadyExistsError) + " (" + this.fSessionPath + ") \n"));
                        return;
                    }
                }
                catch (SystemMessageException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_CreateSessionDialogTitle, (String)(String.valueOf(Messages.TraceControl_FileSubSystemError) + "\n" + (Object)((Object)e)));
                    return;
                }
            }
            this.fIsDefaultPath = false;
        }
        if ("".equals(this.fSessionName)) {
            this.fSessionName = "auto";
        }
        if (!this.fSessionName.matches("^[a-zA-Z0-9\\-\\_]{1,}$")) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_CreateSessionDialogTitle, (String)(String.valueOf(Messages.TraceControl_InvalidSessionNameError) + " (" + this.fSessionName + ") \n"));
            return;
        }
        if (this.fParent.containsChild(this.fSessionName)) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_CreateSessionDialogTitle, (String)(String.valueOf(Messages.TraceControl_SessionAlreadyExistsError) + " (" + this.fSessionName + ")"));
            return;
        }
        super.okPressed();
    }
}

