/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.model.PMCommand;
import org.eclipse.linuxtools.internal.perf.model.PMDso;
import org.eclipse.linuxtools.internal.perf.model.PMEvent;
import org.eclipse.linuxtools.internal.perf.model.PMFile;
import org.eclipse.linuxtools.internal.perf.model.PMSymbol;
import org.eclipse.linuxtools.internal.perf.model.TreeParent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PerfCore {
    private static HashMap<String, ArrayList<String>> eventList = null;

    public static String spitStream(BufferedReader br, String blockTitle, PrintStream print) {
        StringBuffer strBuf = new StringBuffer();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                strBuf.append(String.valueOf(line) + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String str = strBuf.toString();
        if (!str.trim().equals("") && print != null) {
            print.println(String.valueOf(blockTitle) + ": \n" + str + "\n END OF " + blockTitle);
        }
        return str;
    }

    public static HashMap<String, ArrayList<String>> getEventList() {
        if (eventList == null) {
            eventList = PerfCore.loadEventList();
        }
        return eventList;
    }

    public static HashMap<String, ArrayList<String>> loadEventList() {
        HashMap<String, ArrayList<String>> events;
        block24: {
            events = new HashMap<String, ArrayList<String>>();
            if (!PerfCore.checkPerfInPath()) {
                return events;
            }
            Process p = null;
            BufferedReader input = null;
            try {
                p = Runtime.getRuntime().exec(new String[]{"perf", "list"});
                BufferedReader stdoutIn = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader stderrIn = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while (!stdoutIn.ready() && !stderrIn.ready()) {
                }
                input = stdoutIn.ready() ? stdoutIn : stderrIn;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                try {
                    String line;
                    while ((line = input.readLine()) != null) {
                        String event;
                        String cat;
                        if (!line.contains("[")) continue;
                        if (line.contains("Hardware breakpoint")) {
                            cat = "Hardware breakpoint";
                            event = line.substring(1, line.indexOf("[", 0)).trim();
                        } else if (line.contains("Raw hardware event descriptor")) {
                            cat = "Raw hardware event descriptor";
                            event = line.substring(1, line.indexOf("[", 0)).trim();
                        } else {
                            event = line.substring(1, line.indexOf("[", 0)).trim();
                            if (event.contains("OR")) {
                                event = event.split("OR")[0];
                            }
                            cat = line.replaceFirst(".*\\[(.+)\\]", "$1").trim();
                        }
                        ArrayList<String> catevs = events.get(cat);
                        if (catevs == null) {
                            catevs = new ArrayList();
                            events.put(cat, catevs);
                        }
                        catevs.add(event.trim());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return events;
    }

    public static String getPerfVersion(String[] environ, File workingDir) {
        Process p = null;
        try {
            p = workingDir == null ? Runtime.getRuntime().exec(new String[]{"perf", "--version"}) : Runtime.getRuntime().exec(new String[]{"perf", "--version"}, environ, workingDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        return PerfCore.spitStream(input, "Perf --version STDOUT", null);
    }

    public static boolean checkPerfInPath() {
        try {
            Runtime.getRuntime().exec(new String[]{"perf", "--version"});
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static String[] getRecordString(ILaunchConfiguration config) {
        String[] base = new String[]{"perf", "record", "-f"};
        if (config == null) {
            return base;
        }
        ArrayList<String> newCommand = new ArrayList<String>();
        newCommand.addAll(Arrays.asList(base));
        try {
            if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Record.Realtime", false)) {
                newCommand.add("-r");
            }
            if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Record.Verbose", false)) {
                newCommand.add("-v");
            }
            if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Multiplex", false)) {
                newCommand.add("-M");
            }
            List selE = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", PerfPlugin.ATTR_SelectedEvents_default);
            if (!config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true) && selE != null) {
                for (String e : selE) {
                    newCommand.add("-e");
                    newCommand.add(e);
                }
            }
        }
        catch (CoreException coreException) {}
        return newCommand.toArray(new String[0]);
    }

    public static String[] getReportString(ILaunchConfiguration config, String perfDataLoc) {
        ArrayList<String> base = new ArrayList<String>();
        base.addAll(Arrays.asList("perf", "report", "--sort", "comm,dso,sym", "-n", "-t", "\u0001"));
        if (config != null) {
            try {
                String kernelLoc = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Kernel.Location", "");
                if (kernelLoc != "") {
                    base.add("--vmlinux");
                    base.add(kernelLoc);
                }
                if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ModuleSymbols", false)) {
                    base.add("-m");
                }
                if (perfDataLoc != null) {
                    base.add("-i");
                    base.add(perfDataLoc);
                }
            }
            catch (CoreException coreException) {}
        }
        return base.toArray(new String[base.size()]);
    }

    public static String[] getAnnotateString(ILaunchConfiguration config, String dso, String symbol, String perfDataLoc, boolean OldPerfVersion) {
        ArrayList<String> base = new ArrayList<String>();
        if (OldPerfVersion) {
            base.addAll(Arrays.asList("perf", "annotate", "-s", symbol, "-l", "-P"));
        } else {
            base.addAll(Arrays.asList("perf", "annotate", "-d", dso, "-s", symbol, "-l", "-P"));
        }
        if (config != null) {
            try {
                String kernelLoc = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Kernel.Location", "");
                if (kernelLoc != "") {
                    base.add("--vmlinux");
                    base.add(kernelLoc);
                }
                if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ModuleSymbols", false)) {
                    base.add("-m");
                }
                if (perfDataLoc != null) {
                    base.add("-i");
                    base.add(perfDataLoc);
                }
            }
            catch (CoreException coreException) {}
        }
        return base.toArray(new String[base.size()]);
    }

    public static void Record(String binaryPath) {
        BufferedReader error = null;
        try {
            Process perfRecord = Runtime.getRuntime().exec((String[])ArrayUtil.addAll((Object[])PerfCore.getRecordString(null), (Object[])new String[]{binaryPath}));
            error = new BufferedReader(new InputStreamReader(perfRecord.getErrorStream()));
            perfRecord.waitFor();
            PerfCore.spitStream(error, "Perf Record STDERR", null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        PerfCore.Report();
    }

    public static void Report() {
        PerfCore.Report(null, null, null, null, null, null);
    }

    public static void Report(ILaunchConfiguration config, String[] environ, File workingDir, IProgressMonitor monitor, String perfDataLoc, PrintStream print) {
        boolean hasProfileData;
        float percent;
        String[] items;
        TreeParent invisibleRoot = PerfPlugin.getDefault().getModelRoot();
        if (invisibleRoot == null) {
            invisibleRoot = new TreeParent("");
            PerfPlugin.getDefault().setModelRoot(invisibleRoot);
        } else {
            invisibleRoot.clear();
        }
        boolean OldPerfVersion = false;
        if (PerfCore.getPerfVersion(environ, workingDir).contains("perf version 0.0.2.PERF")) {
            OldPerfVersion = true;
            if (print != null) {
                print.println("WARNING: You are running an older version of Perf, please update if you can. The plugin may produce unpredictable results.");
            }
        }
        BufferedReader input = null;
        BufferedReader error = null;
        String line = null;
        Process p = null;
        if (monitor != null && monitor.isCanceled()) {
            PerfCore.RefreshView();
            return;
        }
        try {
            if (workingDir == null) {
                p = Runtime.getRuntime().exec(PerfCore.getReportString(config, perfDataLoc));
            } else {
                String perfDefaultDataLoc = workingDir + "/" + "perf.data";
                p = Runtime.getRuntime().exec(PerfCore.getReportString(config, perfDefaultDataLoc));
            }
            input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (monitor != null && monitor.isCanceled()) {
            PerfCore.RefreshView();
            return;
        }
        line = null;
        PMEvent currentEvent = null;
        TreeParent currentCommand = null;
        TreeParent currentDso = null;
        PMFile currentFile = null;
        PMSymbol currentSym = null;
        try {
            if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true)) {
                currentEvent = new PMEvent("Default Event");
                invisibleRoot.addChild(currentEvent);
            } else if (!config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.MultipleEvents", true)) {
                ArrayList selE = (ArrayList)config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", PerfPlugin.ATTR_SelectedEvents_default);
                currentEvent = selE != null ? new PMEvent((String)selE.get(0)) : new PMEvent("Error please fix profiling events chosen in launch config");
            }
            while ((line = input.readLine()) != null) {
                if (monitor != null && monitor.isCanceled()) {
                    PerfCore.RefreshView();
                    return;
                }
                if (line.startsWith("#")) {
                    if (line.contains("Events:") && config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.MultipleEvents", true) && !config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true)) {
                        String[] tmp = line.trim().split(" ");
                        currentEvent = new PMEvent(tmp[tmp.length - 1]);
                        invisibleRoot.addChild(currentEvent);
                        currentCommand = null;
                        currentDso = null;
                        continue;
                    }
                    if (!line.contains("Samples:")) continue;
                    if (print != null) {
                        print.println("WARNING: You are running an older version of Perf, please update if you can. The plugin may produce unpredictable results.");
                    }
                    invisibleRoot.addChild(new PMEvent("WARNING: You are running an older version of Perf, the plugin may produce unpredictable results."));
                    continue;
                }
                items = line.trim().split("\u0001");
                if (items.length != 5) continue;
                percent = Float.parseFloat(items[0]);
                double samples = Double.parseDouble(items[1].trim());
                String comm = items[2].trim();
                String dso = items[3].trim();
                String symbol = items[4].trim();
                boolean kernelFlag = ("" + symbol.charAt(1)).equals("k");
                if (!(currentCommand != null && currentCommand.getName().equals(comm) || (currentCommand = (PMCommand)currentEvent.getChild(comm)) != null)) {
                    currentCommand = new PMCommand(comm);
                    currentEvent.addChild(currentCommand);
                }
                if (!(currentDso != null && currentDso.getName().equals(dso) || (currentDso = (PMDso)currentCommand.getChild(dso)) != null)) {
                    currentDso = new PMDso(dso, kernelFlag);
                    currentCommand.addChild(currentDso);
                }
                currentFile = ((PMDso)currentDso).getFile("Unfiled Symbols");
                currentSym = new PMSymbol(symbol, samples, percent);
                currentFile.addChild(currentSym);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        PerfCore.spitStream(error, "Perf Report STDERR", print);
        boolean SourceLineNumbers = true;
        boolean Kernel_SourceLineNumbers = false;
        try {
            SourceLineNumbers = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SourceLineNumbers", true);
            Kernel_SourceLineNumbers = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Kernel.SourceLineNumbers", false);
        }
        catch (CoreException e2) {
            e2.printStackTrace();
        }
        if (monitor != null && monitor.isCanceled()) {
            PerfCore.RefreshView();
            return;
        }
        boolean bl = hasProfileData = invisibleRoot.getChildren().length != 0;
        if (SourceLineNumbers) {
            TreeParent[] treeParentArray = invisibleRoot.getChildren();
            int n = treeParentArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeParent ev = treeParentArray[n2];
                if (ev instanceof PMEvent) {
                    currentEvent = (PMEvent)ev;
                    TreeParent[] treeParentArray2 = currentEvent.getChildren();
                    int n3 = treeParentArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TreeParent c = treeParentArray2[n4];
                        if (c instanceof PMCommand) {
                            currentCommand = (PMCommand)c;
                            TreeParent[] treeParentArray3 = currentCommand.getChildren();
                            int n5 = treeParentArray3.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                TreeParent d = treeParentArray3[n6];
                                if (d instanceof PMDso) {
                                    currentDso = (PMDso)d;
                                    if (Kernel_SourceLineNumbers || !((PMDso)currentDso).isKernelDso()) {
                                        TreeParent[] treeParentArray4 = ((PMDso)currentDso).getFile("Unfiled Symbols").getChildren();
                                        int n7 = treeParentArray4.length;
                                        int n8 = 0;
                                        while (n8 < n7) {
                                            TreeParent s = treeParentArray4[n8];
                                            if (s instanceof PMSymbol) {
                                                if (monitor != null && monitor.isCanceled()) {
                                                    PerfCore.RefreshView();
                                                    return;
                                                }
                                                currentSym = (PMSymbol)s;
                                                try {
                                                    String[] annotateCmd;
                                                    if (workingDir == null) {
                                                        annotateCmd = PerfCore.getAnnotateString(config, currentDso.getName(), currentSym.getName().substring(4), perfDataLoc, OldPerfVersion);
                                                    } else {
                                                        String perfDefaultDataLoc = workingDir + "/" + "perf.data";
                                                        annotateCmd = PerfCore.getAnnotateString(config, currentDso.getName(), currentSym.getName().substring(4), perfDefaultDataLoc, OldPerfVersion);
                                                    }
                                                    p = Runtime.getRuntime().exec(annotateCmd);
                                                    input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                                                    error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                                                }
                                                catch (IOException e) {
                                                    e.printStackTrace();
                                                }
                                                if (monitor != null && monitor.isCanceled()) {
                                                    PerfCore.RefreshView();
                                                    return;
                                                }
                                                boolean grabBlock = false;
                                                boolean blockStarted = false;
                                                try {
                                                    while ((line = input.readLine()) != null) {
                                                        if (line.startsWith("Sorted summary for file")) {
                                                            grabBlock = true;
                                                            String dsoName = line.replace("Sorted summary for file ", "");
                                                            blockStarted = false;
                                                            if (workingDir != null && dsoName.startsWith("./")) {
                                                                dsoName = workingDir.getAbsolutePath().endsWith("/") ? String.valueOf(workingDir.getAbsolutePath()) + dsoName.substring(2) : String.valueOf(workingDir.getAbsolutePath()) + dsoName.substring(1);
                                                            }
                                                            ((PMDso)currentDso).setPath(dsoName);
                                                            continue;
                                                        }
                                                        if (line.startsWith("---")) {
                                                            if (blockStarted) {
                                                                blockStarted = false;
                                                                grabBlock = false;
                                                                continue;
                                                            }
                                                            blockStarted = true;
                                                            continue;
                                                        }
                                                        if (!grabBlock || !blockStarted || (items = line.trim().split(" +")).length != 2) continue;
                                                        percent = Float.parseFloat(items[0]);
                                                        String lineRef = items[1];
                                                        items = lineRef.split(":");
                                                        if (currentDso != null) {
                                                            currentSym.addPercent(Integer.parseInt(items[1]), Float.valueOf(percent));
                                                            if (currentSym.getParent().getName().equals("Unfiled Symbols")) {
                                                                currentSym.getParent().removeChild(currentSym);
                                                                ((PMDso)currentDso).getFile(items[0]).addChild(currentSym);
                                                                continue;
                                                            }
                                                            if (((PMFile)currentSym.getParent()).getPath().equals(items[0])) continue;
                                                            currentSym.markConflict();
                                                            currentSym.getParent().removeChild(currentSym);
                                                            ((PMDso)currentDso).getFile("Symbols conflicting in multiple files").addChild(currentSym);
                                                            continue;
                                                        }
                                                        break;
                                                    }
                                                }
                                                catch (IOException e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                            ++n8;
                                        }
                                        if (((PMDso)currentDso).getFile("Unfiled Symbols").getChildren().length == 0) {
                                            currentDso.removeChild(((PMDso)currentDso).getFile("Unfiled Symbols"));
                                        }
                                        PerfCore.spitStream(error, "Perf Annotate STDERR", print);
                                    }
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        if (print != null) {
            if (hasProfileData) {
                print.println("Profile data loaded into Perf Profile View.");
            } else {
                print.println("No profile data generated to be displayed.");
            }
        }
        PerfCore.RefreshView();
    }

    public static void RefreshView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.perf.ui.ProfileView");
                    PerfPlugin.getDefault().getProfileView().refreshModel();
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

