/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.trace;

import org.eclipse.linuxtools.internal.tmf.core.trace.TmfExperimentLocation;
import org.eclipse.linuxtools.internal.tmf.core.trace.TmfLocationArray;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.TmfContext;

public class TmfExperimentContext
extends TmfContext
implements Cloneable {
    public static final int NO_TRACE = -1;
    private ITmfContext[] fContexts;
    private ITmfEvent[] fEvents;
    private int fLastTraceRead;

    public TmfExperimentContext(ITmfContext[] contexts) {
        this.fContexts = contexts;
        this.fEvents = new ITmfEvent[this.fContexts.length];
        ITmfLocation[] locations = new ITmfLocation[this.fContexts.length];
        this.setLocation(new TmfExperimentLocation(new TmfLocationArray((ITmfLocation[])locations.clone())));
        long[] ranks = new long[this.fContexts.length];
        long rank = 0L;
        int i = 0;
        while (i < this.fContexts.length) {
            if (contexts[i] != null) {
                locations[i] = contexts[i].getLocation();
                ranks[i] = contexts[i].getRank();
                rank += contexts[i].getRank();
            }
            ++i;
        }
        this.setRank(rank);
        this.fLastTraceRead = -1;
    }

    public TmfExperimentContext(TmfExperimentContext other) {
        this(other.cloneContexts());
        this.fEvents = other.fEvents;
        if (other.getLocation() != null) {
            this.setLocation(other.getLocation().clone());
        }
        this.setRank(other.getRank());
        this.setLastTrace(other.fLastTraceRead);
    }

    @Override
    public TmfExperimentContext clone() {
        TmfExperimentContext clone = null;
        clone = (TmfExperimentContext)super.clone();
        clone.fContexts = this.cloneContexts();
        clone.fEvents = this.cloneEvents();
        clone.fLastTraceRead = this.fLastTraceRead;
        return clone;
    }

    private ITmfContext[] cloneContexts() {
        ITmfContext[] contexts = new ITmfContext[this.fContexts.length];
        int i = 0;
        while (i < this.fContexts.length) {
            contexts[i] = this.fContexts[i] != null ? this.fContexts[i].clone() : null;
            ++i;
        }
        return contexts;
    }

    private ITmfEvent[] cloneEvents() {
        ITmfEvent[] events = new ITmfEvent[this.fEvents.length];
        int i = 0;
        while (i < this.fEvents.length) {
            events[i] = this.fEvents[i] != null ? this.fEvents[i].clone() : null;
            ++i;
        }
        return events;
    }

    public ITmfContext[] getContexts() {
        return this.fContexts;
    }

    public ITmfEvent[] getEvents() {
        return this.fEvents;
    }

    public int getLastTrace() {
        return this.fLastTraceRead;
    }

    public void setLastTrace(int newIndex) {
        this.fLastTraceRead = newIndex;
    }

    @Override
    public int hashCode() {
        int result = 17;
        int i = 0;
        while (i < this.fContexts.length) {
            result = 37 * result + this.fContexts[i].hashCode();
            ++i;
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof TmfExperimentContext)) {
            return false;
        }
        TmfExperimentContext o = (TmfExperimentContext)other;
        boolean isEqual = true;
        int i = 0;
        while (isEqual && i < this.fContexts.length) {
            isEqual &= this.fContexts[i].equals(o.fContexts[i]);
            ++i;
        }
        return isEqual;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TmfExperimentContext [\n");
        sb.append("\tfLocation=" + this.getLocation() + ", fRank=" + this.getRank() + "\n");
        sb.append("\tfContexts=[");
        int i = 0;
        while (i < this.fContexts.length) {
            sb.append("(" + this.fContexts[i].getLocation() + "," + this.fContexts[i].getRank() + (i < this.fContexts.length - 1 ? ")," : ")]\n"));
            ++i;
        }
        sb.append("\tfEvents=[");
        i = 0;
        while (i < this.fEvents.length) {
            ITmfEvent event = this.fEvents[i];
            sb.append((event != null ? this.fEvents[i].getTimestamp() : "(null)") + (i < this.fEvents.length - 1 ? "," : "]\n"));
            ++i;
        }
        sb.append("\tfLastTraceRead=" + this.fLastTraceRead + "\n");
        sb.append("]");
        return sb.toString();
    }
}

