/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfIterator;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfLocation;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;

public class CtfTmfLightweightContext
implements ITmfContext {
    private static final int MAX_COLLISIONS = 10;
    private CtfLocation curLocation;
    private long curRank;
    private int collisions;
    private CtfIterator fSeeker;
    private final ArrayList<CtfIterator> fIteratorPool;
    private ListIterator<CtfIterator> fCurrentIterator;

    public CtfTmfLightweightContext(ArrayList<CtfIterator> iters, ListIterator<CtfIterator> pos) {
        this.fIteratorPool = iters;
        this.fCurrentIterator = pos;
        this.fSeeker = this.getIterator();
        this.curLocation = new CtfLocation(null);
        this.collisions = 0;
    }

    @Override
    public long getRank() {
        return this.curRank;
    }

    @Override
    public ITmfLocation<? extends Comparable<?>> getLocation() {
        return this.curLocation;
    }

    @Override
    public boolean hasValidRank() {
        return this.curRank != CtfLocation.INVALID_LOCATION;
    }

    @Override
    public void setLocation(ITmfLocation<? extends Comparable<?>> location) {
        this.curLocation = (CtfLocation)location;
        this.updateLocation();
    }

    @Override
    public void setRank(long rank) {
        this.curRank = rank;
    }

    @Override
    public void increaseRank() {
        if (this.hasValidRank()) {
            ++this.curRank;
        }
    }

    public synchronized CtfTmfEvent getCurrentEvent() {
        this.updateLocation();
        return this.fSeeker.getCurrentEvent();
    }

    public synchronized boolean advance() {
        this.updateLocation();
        boolean retVal = this.fSeeker.advance();
        CtfTmfEvent currentEvent = this.fSeeker.getCurrentEvent();
        if (currentEvent != null) {
            this.curLocation.setLocation(currentEvent.getTimestampValue());
        } else {
            this.curLocation.setLocation(CtfLocation.INVALID_LOCATION);
        }
        return retVal;
    }

    @Override
    public void dispose() {
    }

    public synchronized boolean seek(long timestamp) {
        this.curLocation.setLocation(timestamp);
        this.collisions = 0;
        this.fSeeker = this.getIterator();
        return this.updateLocation();
    }

    @Override
    public CtfTmfLightweightContext clone() {
        CtfTmfLightweightContext ret = new CtfTmfLightweightContext(this.fIteratorPool, this.fCurrentIterator);
        ret.curLocation = this.curLocation.clone();
        ret.curRank = this.curRank;
        return ret;
    }

    private synchronized boolean updateLocation() {
        if (!this.curLocation.getLocation().equals(this.fSeeker.getLocation().getLocation())) {
            ++this.collisions;
            if (this.collisions > 10) {
                this.fSeeker = this.getIterator();
                this.collisions = 0;
            }
            this.fSeeker.setRank(this.curRank);
            return this.fSeeker.seek(this.curLocation.getLocation());
        }
        this.collisions = 0;
        return true;
    }

    private CtfIterator getIterator() {
        if (!this.fCurrentIterator.hasNext()) {
            this.fCurrentIterator = this.fIteratorPool.listIterator(0);
        }
        return this.fCurrentIterator.next();
    }
}

