/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.events;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomEventsTable;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtTrace;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomXmlTrace;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentDisposedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ide.IGotoMarker;
import org.osgi.framework.Bundle;

public class TmfEventsView
extends TmfView
implements IResourceChangeListener {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.events";
    private TmfExperiment<?> fExperiment;
    private TmfEventsTable fEventsTable;
    private static final int DEFAULT_CACHE_SIZE = 100;
    private String fTitlePrefix;
    private Composite fParent;

    public TmfEventsView(int cacheSize) {
        super("TmfEventsView");
    }

    public TmfEventsView() {
        this(100);
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        this.fTitlePrefix = this.getTitle();
        TmfExperiment experiment = TmfExperiment.getCurrentExperiment();
        if (experiment != null) {
            this.experimentSelected((TmfExperimentSelectedSignal<ITmfEvent>)new TmfExperimentSelectedSignal((Object)this, experiment));
        } else {
            this.fEventsTable = this.createEventsTable(parent);
        }
    }

    @Override
    public void dispose() {
        if (this.fEventsTable != null) {
            this.fEventsTable.dispose();
        }
        super.dispose();
    }

    protected TmfEventsTable createEventsTable(Composite parent) {
        if (this.fExperiment == null) {
            return new TmfEventsTable(parent, 100);
        }
        int cacheSize = this.fExperiment.getCacheSize();
        String commonTraceType = null;
        try {
            ITmfTrace[] iTmfTraceArray = this.fExperiment.getTraces();
            int n = iTmfTraceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfTrace trace = iTmfTraceArray[n2];
                IResource resource = trace.getResource();
                if (resource == null) {
                    return new TmfEventsTable(parent, cacheSize);
                }
                String traceType = resource.getPersistentProperty(TmfCommonConstants.TRACETYPE);
                if (commonTraceType != null && !commonTraceType.equals(traceType)) {
                    return new TmfEventsTable(parent, cacheSize);
                }
                commonTraceType = traceType;
                ++n2;
            }
            if (commonTraceType == null) {
                return new TmfEventsTable(parent, cacheSize);
            }
            if (commonTraceType.startsWith(CustomTxtTrace.class.getCanonicalName())) {
                return new CustomEventsTable(((CustomTxtTrace)this.fExperiment.getTraces()[0]).getDefinition(), parent, cacheSize);
            }
            if (commonTraceType.startsWith(CustomXmlTrace.class.getCanonicalName())) {
                return new CustomEventsTable(((CustomXmlTrace)this.fExperiment.getTraces()[0]).getDefinition(), parent, cacheSize);
            }
            iTmfTraceArray = TmfTraceType.getTypeElements();
            n = iTmfTraceArray.length;
            n2 = 0;
            while (n2 < n) {
                ITmfTrace ce = iTmfTraceArray[n2];
                if (ce.getAttribute("id").equals(commonTraceType)) {
                    String eventsTableType;
                    IConfigurationElement[] eventsTableTypeCE = ce.getChildren("eventsTableType");
                    if (eventsTableTypeCE.length == 1 && (eventsTableType = eventsTableTypeCE[0].getAttribute("class")) != null && eventsTableType.length() != 0) {
                        Bundle bundle = Platform.getBundle((String)ce.getContributor().getName());
                        Class c = bundle.loadClass(eventsTableType);
                        Class[] constructorArgs = new Class[]{Composite.class, Integer.TYPE};
                        Constructor constructor = c.getConstructor(constructorArgs);
                        Object[] args = new Object[]{parent, cacheSize};
                        return (TmfEventsTable)constructor.newInstance(args);
                    }
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error creating events table", e);
        }
        catch (InvalidRegistryObjectException e) {
            Activator.getDefault().logError("Error creating events table", e);
        }
        catch (SecurityException e) {
            Activator.getDefault().logError("Error creating events table", e);
        }
        catch (IllegalArgumentException e) {
            Activator.getDefault().logError("Error creating events table", e);
        }
        catch (ClassNotFoundException e) {
            Activator.getDefault().logError("Error creating events table", e);
        }
        catch (NoSuchMethodException e) {
            Activator.getDefault().logError("Error creating events table", e);
        }
        catch (InstantiationException e) {
            Activator.getDefault().logError("Error creating events table", e);
        }
        catch (IllegalAccessException e) {
            Activator.getDefault().logError("Error creating events table", e);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().logError("Error creating events table", e);
        }
        return new TmfEventsTable(parent, cacheSize);
    }

    public void setFocus() {
        this.fEventsTable.setFocus();
    }

    public Object getAdapter(Class adapter) {
        if (IGotoMarker.class.equals((Object)adapter)) {
            return this.fEventsTable;
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return "[TmfEventsView]";
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<ITmfEvent> signal) {
        TmfExperiment exp = signal.getExperiment();
        if (!exp.equals(this.fExperiment)) {
            this.fExperiment = exp;
            this.setPartName(String.valueOf(this.fTitlePrefix) + " - " + this.fExperiment.getName());
            if (this.fEventsTable != null) {
                this.fEventsTable.dispose();
            }
            this.fEventsTable = this.createEventsTable(this.fParent);
            this.fEventsTable.setTrace((ITmfTrace<?>)this.fExperiment, false);
            this.fEventsTable.refreshBookmarks(this.fExperiment.getBookmarksFile());
            if (this.fExperiment.getBookmarksFile() != null) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
            }
            this.fParent.layout();
        }
    }

    @TmfSignalHandler
    public void experimentDisposed(TmfExperimentDisposedSignal<ITmfEvent> signal) {
        TmfExperiment experiment = signal.getExperiment();
        if (experiment.equals(this.fExperiment)) {
            this.fEventsTable.setTrace(null, false);
            Activator.getDefault().getWorkbench().getWorkbenchWindows()[0].getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    TmfEventsView.this.setPartName(TmfEventsView.this.fTitlePrefix);
                }
            });
            if (this.fExperiment != null && this.fExperiment.getBookmarksFile() != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.fExperiment == null || this.fExperiment.getBookmarksFile() == null) {
            return;
        }
        IMarkerDelta[] iMarkerDeltaArray = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", false);
        int n = iMarkerDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            if (delta.getResource().equals((Object)this.fExperiment.getBookmarksFile())) {
                if (delta.getKind() == 2) {
                    final IMarker bookmark = delta.getMarker();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TmfEventsView.this.fEventsTable.removeBookmark(bookmark);
                        }
                    });
                } else if (delta.getKind() == 4) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TmfEventsView.this.fEventsTable.getTable().refresh();
                        }
                    });
                }
            }
            ++n2;
        }
    }
}

