/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.filter;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.Messages;
import org.eclipse.linuxtools.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterRootNode;
import org.eclipse.linuxtools.tmf.core.filter.xml.TmfFilterXMLParser;
import org.eclipse.linuxtools.tmf.core.filter.xml.TmfFilterXMLWriter;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.views.filter.FilterManager;
import org.eclipse.linuxtools.tmf.ui.views.filter.FilterViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.xml.sax.SAXException;

public class FilterView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.filter";
    private static final Image SAVE_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/save_button.gif");
    private static final Image ADD_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/add_button.gif");
    private static final Image DELETE_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/delete_button.gif");
    private static final Image IMPORT_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/import_button.gif");
    private static final Image EXPORT_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/export_button.gif");
    private FilterViewer fViewer;
    private final ITmfFilterTreeNode fRoot;
    private final IWorkspace fWorkspace = ResourcesPlugin.getWorkspace();
    private SaveAction fSaveAction;
    private AddAction fAddAction;
    private DeleteAction fDeleteAction;
    private ExportAction fExportAction;
    private ImportAction fImportAction;

    public ITmfFilterTreeNode getFilterRoot() {
        return this.fRoot;
    }

    public FilterView() {
        super("Filter");
        try {
            this.fWorkspace.getRoot().refreshLocal(2, null);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error refreshing workspace", e);
        }
        this.fRoot = new TmfFilterRootNode();
        ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = FilterManager.getSavedFilters();
        int n = iTmfFilterTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfFilterTreeNode node = iTmfFilterTreeNodeArray[n2];
            this.fRoot.addChild(node);
            ++n2;
        }
    }

    public void refresh() {
        this.fViewer.refresh();
    }

    public void setSelection(ITmfFilterTreeNode node) {
        this.fViewer.setSelection(node, true);
    }

    public void createPartControl(Composite parent) {
        this.fViewer = new FilterViewer(parent, 0);
        this.fViewer.setInput(this.fRoot);
        this.contributeToActionBars();
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
                    FilterView.this.fDeleteAction.setEnabled(true);
                    FilterView.this.fExportAction.setEnabled(true);
                } else {
                    FilterView.this.fDeleteAction.setEnabled(false);
                    FilterView.this.fExportAction.setEnabled(false);
                }
            }
        });
    }

    public void setFocus() {
        this.fViewer.setFocus();
    }

    public String toString() {
        return "[FilterView]";
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        this.fSaveAction = new SaveAction();
        this.fSaveAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)SAVE_IMAGE));
        this.fSaveAction.setToolTipText(Messages.FilterView_SaveActionToolTipText);
        this.fAddAction = new AddAction();
        this.fAddAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)ADD_IMAGE));
        this.fAddAction.setToolTipText(Messages.FilterView_AddActionToolTipText);
        this.fDeleteAction = new DeleteAction();
        this.fDeleteAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)DELETE_IMAGE));
        this.fDeleteAction.setToolTipText(Messages.FilterView_DeleteActionToolTipText);
        this.fDeleteAction.setEnabled(false);
        this.fExportAction = new ExportAction();
        this.fExportAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)EXPORT_IMAGE));
        this.fExportAction.setToolTipText(Messages.FilterView_ExportActionToolTipText);
        this.fImportAction = new ImportAction();
        this.fImportAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)IMPORT_IMAGE));
        this.fImportAction.setToolTipText(Messages.FilterView_ImportActionToolTipText);
        manager.add((IAction)this.fSaveAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fAddAction);
        manager.add((IAction)this.fDeleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fExportAction);
        manager.add((IAction)this.fImportAction);
    }

    private class AddAction
    extends Action {
        private AddAction() {
        }

        public void run() {
            TmfFilterNode newNode = new TmfFilterNode(FilterView.this.fRoot, "");
            FilterView.this.refresh();
            FilterView.this.setSelection((ITmfFilterTreeNode)newNode);
        }
    }

    private class DeleteAction
    extends Action {
        private DeleteAction() {
        }

        public void run() {
            ITmfFilterTreeNode node = FilterView.this.fViewer.getSelection();
            if (node != null) {
                node.remove();
            }
            FilterView.this.refresh();
        }
    }

    private class ExportAction
    extends Action {
        private ExportAction() {
        }

        public void run() {
            try {
                FileDialog dlg = new FileDialog(new Shell(), 8192);
                dlg.setFilterNames(new String[]{String.valueOf(Messages.FilterView_FileDialogFilterName) + " (*.filter.xml)"});
                dlg.setFilterExtensions(new String[]{"*.filter.xml"});
                String fn = dlg.open();
                if (fn != null) {
                    TmfFilterXMLWriter writerXML = new TmfFilterXMLWriter(FilterView.this.fRoot);
                    writerXML.saveTree(fn);
                }
            }
            catch (ParserConfigurationException e) {
                Activator.getDefault().logError("Error parsing filter xml file", e);
            }
            catch (IOException e) {
                Activator.getDefault().logError("Error parsing filter xml file", e);
            }
        }
    }

    private class ImportAction
    extends Action {
        private ImportAction() {
        }

        public void run() {
            if (FilterView.this.fViewer != null) {
                ITmfFilterTreeNode root = null;
                try {
                    FileDialog dlg = new FileDialog(new Shell(), 4096);
                    dlg.setFilterNames(new String[]{String.valueOf(Messages.FilterView_FileDialogFilterName) + " (*.filter.xml)"});
                    dlg.setFilterExtensions(new String[]{"*.filter.xml"});
                    TmfFilterXMLParser parserXML = null;
                    String fn = dlg.open();
                    if (fn != null) {
                        parserXML = new TmfFilterXMLParser(fn);
                        root = parserXML.getTree();
                    }
                }
                catch (SAXException e) {
                    Activator.getDefault().logError("Error importing filter xml file", e);
                }
                catch (IOException e) {
                    Activator.getDefault().logError("Error importing filter xml file", e);
                }
                if (root != null) {
                    ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = root.getChildren();
                    int n = iTmfFilterTreeNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITmfFilterTreeNode node = iTmfFilterTreeNodeArray[n2];
                        if (node instanceof TmfFilterNode) {
                            FilterView.this.fRoot.addChild(node);
                            FilterView.this.refresh();
                            FilterView.this.fViewer.setSelection(node);
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    private class SaveAction
    extends Action {
        private SaveAction() {
        }

        public void run() {
            FilterManager.setSavedFilters(FilterView.this.fRoot.getChildren());
        }
    }
}

